/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.block.entity;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.mcreator.pocketvillagers.block.entity.PocketCubeBlockEntity;
import net.mcreator.pocketvillagers.config.PocketVillagersConfigCache;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlockEntities;
import net.mcreator.pocketvillagers.network.SyncMiningMenuPayload;
import net.mcreator.pocketvillagers.world.inventory.MiningPocketCubeGUIMenu;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9304;
import org.jetbrains.annotations.Nullable;

public class MiningPocketCubeBlockEntity
extends PocketCubeBlockEntity
implements ExtendedScreenHandlerFactory<class_2338> {
    private static final int TOTAL_SLOTS = 13;
    private int progressTicks = 0;
    private int progressNeeded = 0;

    public int getProgressTicks() {
        return this.progressTicks;
    }

    public int getProgressNeeded() {
        return this.progressNeeded;
    }

    public void resetProgress() {
        try {
            this.progressTicks = 0;
            this.progressNeeded = 0;
            this.method_5431();
            this.syncToClient();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void resetProgressTicks() {
        try {
            this.progressTicks = 0;
            this.method_5431();
            this.syncToClient();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void recomputeProgressNeededFromCurrentTool() {
        try {
            int needed;
            class_2371<class_1799> items = this.method_11282();
            if (items == null || items.size() == 0) {
                this.progressNeeded = 0;
                this.method_5431();
                this.syncToClient();
                return;
            }
            class_1799 tool = (class_1799)items.get(0);
            if (tool == null || tool.method_7960()) {
                this.progressNeeded = 0;
                this.method_5431();
                this.syncToClient();
                return;
            }
            int baseTicks = PocketVillagersConfigCache.getMiningTickInterval();
            double mult = this.getToolMultiplier(tool);
            this.progressNeeded = needed = Math.max(1, (int)Math.round((double)baseTicks * mult));
            this.method_5431();
            this.syncToClient();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isAutomationReady() {
        try {
            if (!this.hasVillager()) {
                return false;
            }
            class_2371<class_1799> items = this.method_11282();
            if (items == null || items.size() < 13) {
                return false;
            }
            class_1799 tool = (class_1799)items.get(0);
            return tool != null && !tool.method_7960();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public MiningPocketCubeBlockEntity(class_2338 position, class_2680 state) {
        super(PocketVillagersModBlockEntities.MINING_POCKET_CUBE, position, state);
        try {
            this.method_11281((class_2371<class_1799>)class_2371.method_10213((int)13, (Object)class_1799.field_8037));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void method_11014(class_11368 valueInput) {
        super.method_11014(valueInput);
        if (!this.method_54871(valueInput)) {
            this.method_11281((class_2371<class_1799>)class_2371.method_10213((int)13, (Object)class_1799.field_8037));
        }
        class_1262.method_5429((class_11368)valueInput, this.method_11282());
    }

    @Override
    public void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        if (!this.method_54872(valueOutput)) {
            class_1262.method_5426((class_11372)valueOutput, this.method_11282());
        }
    }

    @Override
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 lookupProvider) {
        class_2487 tag = this.method_38242(lookupProvider);
        try {
            tag.method_10569("ProgressTicks", this.progressTicks);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10569("ProgressNeeded", this.progressNeeded);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10556("CanAutomate", this.isAutomationReady());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return tag;
    }

    public void handleUpdateTag(class_2487 tag) {
        block8: {
            try {
                if (tag == null) break block8;
                try {
                    if (tag.method_10545("ProgressTicks")) {
                        this.progressTicks = tag.method_10550("ProgressTicks").orElse(this.progressTicks);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (tag.method_10545("ProgressNeeded")) {
                        this.progressNeeded = tag.method_10550("ProgressNeeded").orElse(this.progressNeeded);
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public int method_5439() {
        return this.method_11282().size();
    }

    @Override
    public boolean method_5442() {
        return super.method_5442();
    }

    @Override
    public class_2561 method_17823() {
        return class_2561.method_43470((String)"mining_pocket_cube");
    }

    @Override
    public class_1703 method_5465(int id, class_1661 inventory) {
        return class_1707.method_19248((int)id, (class_1661)inventory);
    }

    public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
        return new MiningPocketCubeGUIMenu(containerId, playerInventory, this);
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.method_11016();
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Mining Pocket Cube");
    }

    @Override
    protected class_2371<class_1799> method_11282() {
        return super.method_11282();
    }

    @Override
    protected void method_11281(class_2371<class_1799> stacks) {
        super.method_11281(stacks);
    }

    public void method_5447(int index, class_1799 stack) {
        try {
            class_1799 toSet = stack == null ? class_1799.field_8037 : stack.method_7972();
            class_2371<class_1799> items = this.method_11282();
            if (index >= 0 && index < items.size()) {
                items.set(index, (Object)toSet);
                this.method_11281(items);
                this.method_5431();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public class_1799 method_5434(int index, int count) {
        try {
            class_1799 res = super.method_5434(index, count);
            try {
                this.method_5431();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return res;
        }
        catch (Throwable ignored) {
            return class_1799.field_8037;
        }
    }

    public class_1799 method_5441(int index) {
        try {
            class_1799 res = super.method_5441(index);
            try {
                this.method_5431();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return res;
        }
        catch (Throwable ignored) {
            return class_1799.field_8037;
        }
    }

    @Override
    public boolean method_5437(int index, class_1799 stack) {
        return true;
    }

    public void serverTick(class_1937 level) {
        block21: {
            try {
                boolean inserted;
                int needed;
                if (level == null || level.method_8608()) {
                    return;
                }
                if (!this.hasVillager()) {
                    return;
                }
                class_2371<class_1799> items = this.method_11282();
                if (items == null || items.size() < 13) {
                    return;
                }
                class_1799 tool = (class_1799)items.get(0);
                if (tool == null || tool.method_7960()) {
                    return;
                }
                int baseTicks = PocketVillagersConfigCache.getMiningTickInterval();
                double mult = this.getToolMultiplier(tool);
                this.progressNeeded = needed = Math.max(1, (int)Math.round((double)baseTicks * mult));
                ++this.progressTicks;
                try {
                    if (this.progressTicks % 5 == 0) {
                        this.sendMenuStateUpdateToViewers();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.progressTicks < this.progressNeeded) {
                    return;
                }
                this.progressTicks = 0;
                class_1799 drop = this.sampleMiningDrop(level.method_8409(), tool);
                if (drop == null || drop.method_7960() || !(inserted = this.insertIntoOutputs(drop))) break block21;
                this.method_5431();
                this.syncToClient();
                try {
                    if (level instanceof class_3218) {
                        class_3218 serverLevel = (class_3218)level;
                        for (class_3222 p : serverLevel.method_8503().method_3760().method_14571()) {
                            try {
                                if (p.method_51469() != serverLevel || !(p.field_7512 instanceof MiningPocketCubeGUIMenu)) continue;
                                MiningPocketCubeGUIMenu menu = (MiningPocketCubeGUIMenu)p.field_7512;
                                if (menu.x != this.method_11016().method_10263() || menu.y != this.method_11016().method_10264() || menu.z != this.method_11016().method_10260()) continue;
                                try {
                                    Map<Integer, class_1735> slots = menu.getSlots();
                                    for (int i = 0; i < this.method_5439(); ++i) {
                                        class_1735 slot = slots.get(i);
                                        if (slot == null) continue;
                                        slot.method_7673(this.method_5438(i) == null ? class_1799.field_8037 : this.method_5438(i).method_7972());
                                    }
                                    try {
                                        menu.method_7623();
                                    }
                                    catch (Throwable throwable) {}
                                }
                                catch (Throwable throwable) {
                                }
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void sendMenuStateUpdateToViewers() {
        try {
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                int rem = Math.max(0, this.progressNeeded - this.progressTicks);
                for (class_3222 p : serverLevel.method_8503().method_3760().method_14571()) {
                    try {
                        if (p.method_51469() != serverLevel || !(p.field_7512 instanceof MiningPocketCubeGUIMenu)) continue;
                        MiningPocketCubeGUIMenu menu = (MiningPocketCubeGUIMenu)p.field_7512;
                        if (menu.x != this.method_11016().method_10263() || menu.y != this.method_11016().method_10264() || menu.z != this.method_11016().method_10260()) continue;
                        try {
                            SyncMiningMenuPayload.send(p, this.method_11016(), rem, this.progressNeeded, this.isAutomationReady());
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private double getToolMultiplier(class_1799 toolStack) {
        if (toolStack == null || toolStack.method_7960()) {
            return 1.0;
        }
        class_1792 it = toolStack.method_7909();
        double baseMult = 1.0;
        if (it == class_1802.field_22024) {
            baseMult = 0.4;
        } else if (it == class_1802.field_8377) {
            baseMult = 0.5;
        } else if (it == class_1802.field_8403) {
            baseMult = 0.75;
        } else if (it == class_1802.field_8387) {
            baseMult = 1.0;
        } else if (it == class_1802.field_8647 || it == class_1802.field_8335) {
            baseMult = 1.5;
        }
        int efficiencyLevel = this.getEfficiencyLevel(toolStack);
        try {
            if (efficiencyLevel > 0 && PocketVillagersConfigCache.getEnableEfficiency()) {
                double bonus = PocketVillagersConfigCache.getEfficiencySpeedBonus();
                if (bonus < 0.0) {
                    bonus = 0.0;
                }
                if (bonus >= 1.0) {
                    bonus = 0.99;
                }
                baseMult *= Math.pow(1.0 - bonus, efficiencyLevel);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return baseMult;
    }

    private int getEfficiencyLevel(class_1799 tool) {
        if (tool == null || tool.method_7960()) {
            return 0;
        }
        try {
            class_9304 enchantments = tool.method_58657();
            for (Object2IntMap.Entry entry : enchantments.method_57539()) {
                Optional key = ((class_6880)entry.getKey()).method_40230();
                if (!key.isPresent() || !((class_5321)key.get()).method_29177().method_12832().equals("efficiency")) continue;
                return entry.getIntValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    private class_1799 sampleMiningDrop(class_5819 rand, class_1799 toolStack) {
        boolean hasNetheritePick;
        boolean bl = hasNetheritePick = toolStack != null && !toolStack.method_7960() && toolStack.method_7909() == class_1802.field_22024;
        if (hasNetheritePick && rand.method_43048(100) < 5) {
            int netherRoll = rand.method_43048(100);
            if (netherRoll < 50) {
                return new class_1799((class_1935)class_1802.field_22021, 1);
            }
            if (netherRoll < 80) {
                return new class_1799((class_1935)class_1802.field_8155, 1);
            }
            return new class_1799((class_1935)class_1802.field_8397, 1);
        }
        int roll = rand.method_43048(100);
        class_1799 drop = roll < 30 ? new class_1799((class_1935)class_1802.field_8713, 1) : (roll < 53 ? new class_1799((class_1935)class_1802.field_33401, 1) : (roll < 72 ? new class_1799((class_1935)class_1802.field_33400, 1) : (roll < 84 ? new class_1799((class_1935)class_1802.field_33402, 1) : (roll < 90 ? new class_1799((class_1935)class_1802.field_8725, 1) : (roll < 95 ? new class_1799((class_1935)class_1802.field_8759, 1) : (roll < 98 ? new class_1799((class_1935)class_1802.field_8687, 1) : new class_1799((class_1935)class_1802.field_8477, 1)))))));
        int fortuneLevel = this.getFortuneLevel(toolStack);
        try {
            class_1792 item;
            if (fortuneLevel > 0 && PocketVillagersConfigCache.getEnableFortune() && drop != null && !drop.method_7960() && ((item = drop.method_7909()) == class_1802.field_8713 || item == class_1802.field_8725 || item == class_1802.field_8759 || item == class_1802.field_8477 || item == class_1802.field_8687 || item == class_1802.field_8155)) {
                int bonus = rand.method_43048(fortuneLevel + 1);
                drop.method_7939(drop.method_7947() + bonus);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return drop;
    }

    private int getFortuneLevel(class_1799 tool) {
        if (tool == null || tool.method_7960()) {
            return 0;
        }
        try {
            class_9304 enchantments = tool.method_58657();
            for (Object2IntMap.Entry entry : enchantments.method_57539()) {
                Optional key = ((class_6880)entry.getKey()).method_40230();
                if (!key.isPresent() || !((class_5321)key.get()).method_29177().method_12832().equals("fortune")) continue;
                return entry.getIntValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    private boolean insertIntoOutputs(class_1799 drop) {
        try {
            class_2371<class_1799> items = this.method_11282();
            for (int i = 1; i < 13; ++i) {
                boolean sameItem;
                class_1799 s = (class_1799)items.get(i);
                if (s.method_7960()) {
                    items.set(i, (Object)drop.method_7972());
                    this.method_11281(items);
                    return true;
                }
                boolean bl = sameItem = s.method_7909() == drop.method_7909();
                if (!sameItem || s.method_7947() >= s.method_7914()) continue;
                int can = Math.min(s.method_7914() - s.method_7947(), drop.method_7947());
                s.method_7933(can);
                drop.method_7934(can);
                items.set(i, (Object)s);
                this.method_11281(items);
                if (!drop.method_7960()) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        try {
            int start = 1;
            int end = this.method_5439();
            return IntStream.range(start, end).toArray();
        }
        catch (Throwable ignored) {
            return IntStream.range(0, this.method_5439()).toArray();
        }
    }

    @Override
    public boolean method_5492(int index, class_1799 itemstack, @Nullable class_2350 direction) {
        try {
            if (index >= 1) {
                return false;
            }
            return this.method_5437(index, itemstack);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public boolean method_5493(int index, class_1799 itemstack, class_2350 direction) {
        try {
            return index >= 1 && index < this.method_5439();
        }
        catch (Throwable ignored) {
            return false;
        }
    }
}

