/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.client;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1432;
import net.minecraft.class_1550;
import net.minecraft.class_4048;

public class VillagerScalingManager {
    private static final float MAX_SCALE = 0.8f;
    private static final float DEFAULT_SCALE = 0.3f;
    private static final float UI_MULTIPLIER = 45.0f;
    private static final Map<Class<? extends class_1297>, Float> scaleCache = new HashMap<Class<? extends class_1297>, Float>();

    private VillagerScalingManager() {
    }

    public static float getEntityScale(class_1297 entity) {
        if (entity == null) {
            return 0.3f;
        }
        return scaleCache.computeIfAbsent(entity.getClass(), cls -> {
            float entityHeight;
            float entityWidth;
            if (entity.method_5829().method_17939() > 0.0 && entity.method_5829().method_17940() > 0.0) {
                entityWidth = (float)entity.method_5829().method_17939();
                entityHeight = (float)entity.method_5829().method_17940();
            } else {
                class_4048 dimensions = entity.method_18377(entity.method_18376());
                entityWidth = dimensions.comp_2185();
                entityHeight = dimensions.comp_2186();
            }
            if (entityWidth == 0.0f || entityHeight == 0.0f) {
                return Float.valueOf(0.3f);
            }
            if (entity instanceof class_1550) {
                entityWidth *= 1.8f;
            }
            if (entityWidth < 0.8f && entityHeight < 0.8f || entityWidth * 0.3f < 0.8f && entityHeight * 0.3f < 0.8f) {
                return Float.valueOf(0.3f);
            }
            float scaleFactor = Math.max(entityWidth, entityHeight) / 0.8f;
            if (scaleFactor > 1.0f) {
                class_1432 flyingAnimal;
                if (entity instanceof class_1432 && (flyingAnimal = (class_1432)entity).method_6581()) {
                    return Float.valueOf(0.8f / scaleFactor * 0.6f);
                }
                return Float.valueOf(0.8f / scaleFactor);
            }
            return Float.valueOf(0.8f);
        }).floatValue();
    }

    public static float getUIScale(class_1297 entity) {
        float entityScale = VillagerScalingManager.getEntityScale(entity);
        return entityScale * 45.0f;
    }

    public static int getUIScalePixels(class_1297 entity) {
        return Math.round(VillagerScalingManager.getUIScale(entity));
    }

    public static float getYOffset(class_1297 entity, float renderAreaHeight, int scaledSize) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            float entityHeight = livingEntity.method_17682();
            if (entityHeight < 1.5f) {
                float yOffset = renderAreaHeight * 0.8f / (float)scaledSize;
                yOffset = Math.max(0.0f, Math.min(yOffset, 1.0f));
                return yOffset;
            }
            return 0.0625f;
        }
        return 0.0625f;
    }

    public static void clearCache() {
        scaleCache.clear();
    }
}

