/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.item;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.mcreator.pocketvillagers.util.VillagerDataHandler;
import net.minecraft.class_10712;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class PocketCubeItem
extends class_1747 {
    public PocketCubeItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 display, Consumer<class_2561> adder, class_1836 flag) {
        try {
            super.method_67187(stack, context, display, adder, flag);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.buildTooltip(stack, adder);
    }

    public void appendHoverText(class_1799 stack, @Nullable class_1937 level, List<class_2561> components, class_1836 flag) {
        this.buildTooltip(stack, components::add);
    }

    private void buildTooltip(class_1799 stack, Consumer<class_2561> adder) {
        if (VillagerDataHandler.hasVillager(stack)) {
            Optional offersTagOpt;
            class_2487 villagerData = VillagerDataHandler.getVillagerData(stack);
            adder.accept((class_2561)class_2561.method_43470((String)""));
            adder.accept((class_2561)class_2561.method_43470((String)"\u00a76\u00a7l\u2728 Captured Villager \u2728"));
            adder.accept((class_2561)class_2561.method_43470((String)""));
            if (villagerData.method_10545("CustomName")) {
                String customName = villagerData.method_10558("CustomName").orElse("Unnamed");
                adder.accept((class_2561)class_2561.method_43470((String)("\u00a77Name: \u00a7e" + customName)));
            }
            if (villagerData.method_10545("VillagerData.profession")) {
                String profession = villagerData.method_10558("VillagerData.profession").orElse("minecraft:none");
                if (!profession.isEmpty() && !"minecraft:none".equals(profession)) {
                    adder.accept((class_2561)class_2561.method_43470((String)("\u00a77Profession: \u00a7a" + this.formatProfession(profession))));
                } else {
                    adder.accept((class_2561)class_2561.method_43470((String)"\u00a77Profession: \u00a77Unemployed"));
                }
            } else {
                adder.accept((class_2561)class_2561.method_43470((String)"\u00a77Profession: \u00a77Unemployed"));
            }
            if (villagerData.method_10545("VillagerData.level")) {
                int level = villagerData.method_10550("VillagerData.level").orElse(1);
                String levelName = this.getLevelName(level);
                String stars = this.getLevelStars(level);
                adder.accept((class_2561)class_2561.method_43470((String)("\u00a77Level: \u00a7b" + levelName + " " + stars)));
            }
            if (villagerData.method_10545("Xp")) {
                int xp = villagerData.method_10550("Xp").orElse(0);
                adder.accept((class_2561)class_2561.method_43470((String)("\u00a77Experience: \u00a73" + xp + " XP")));
                if (xp > 0) {
                    adder.accept((class_2561)class_2561.method_43470((String)"\u00a77Status: \u00a7aLocked Profession"));
                }
            }
            if (villagerData.method_10545("Offers") && (offersTagOpt = villagerData.method_10562("Offers")).isPresent()) {
                try {
                    DataResult result = class_1916.field_48850.parse((DynamicOps)class_2509.field_11560, (Object)((class_2520)offersTagOpt.get()));
                    if (result.result().isPresent()) {
                        class_1916 offers = (class_1916)result.result().get();
                        int totalOffers = offers.size();
                        int unlockedCount = villagerData.method_10550("UnlockedCount").orElse(totalOffers);
                        if (unlockedCount < totalOffers) {
                            adder.accept((class_2561)class_2561.method_43470((String)("\u00a77Trades: \u00a7e" + unlockedCount + "\u00a77/\u00a76" + totalOffers + " \u00a77unlocked")));
                        } else {
                            adder.accept((class_2561)class_2561.method_43470((String)("\u00a77Trades: \u00a7e" + totalOffers + " \u00a77available")));
                        }
                    }
                }
                catch (Exception e) {
                    adder.accept((class_2561)class_2561.method_43470((String)"\u00a77Trades: \u00a7cError loading"));
                }
            }
            adder.accept((class_2561)class_2561.method_43470((String)""));
            adder.accept((class_2561)class_2561.method_43470((String)"\u00a78Right-click to place"));
        } else {
            adder.accept((class_2561)class_2561.method_43471((String)"tooltip.pocket_villagers.pocket_cube"));
        }
    }

    private String getLevelName(int level) {
        return switch (level) {
            case 1 -> "Novice";
            case 2 -> "Apprentice";
            case 3 -> "Journeyman";
            case 4 -> "Expert";
            case 5 -> "Master";
            default -> "Unknown";
        };
    }

    private String getLevelStars(int level) {
        return switch (level) {
            case 1 -> "\u00a7e\u2605\u00a78\u2605\u2605\u2605\u2605";
            case 2 -> "\u00a7e\u2605\u2605\u00a78\u2605\u2605\u2605";
            case 3 -> "\u00a7e\u2605\u2605\u2605\u00a78\u2605\u2605";
            case 4 -> "\u00a7e\u2605\u2605\u2605\u2605\u00a78\u2605";
            case 5 -> "\u00a7e\u2605\u2605\u2605\u2605\u2605";
            default -> "\u00a78\u2605\u2605\u2605\u2605\u2605";
        };
    }

    private String formatProfession(String professionId) {
        String[] parts = professionId.split(":");
        String name = parts.length > 1 ? parts[1] : parts[0];
        String[] words = name.split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
        }
        return result.toString().trim();
    }
}

