/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.mixin.client;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.accessor.MerchantMenuAccessor;
import net.mcreator.pocketvillagers.accessor.MerchantMenuTraderAccessor;
import net.mcreator.pocketvillagers.accessor.MerchantScreenAccessor;
import net.mcreator.pocketvillagers.client.PocketCubeClient;
import net.mcreator.pocketvillagers.network.EjectWorkstationPacket;
import net.mcreator.pocketvillagers.network.RefreshTradesPacket;
import net.mcreator.pocketvillagers.network.ReleasePocketVillagerPacket;
import net.minecraft.class_11909;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1728;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_1916;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2868;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_492;
import net.minecraft.class_5348;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_492.class})
public abstract class MerchantScreenButtonMixin
extends class_465<class_1728> {
    private class_4185 pocketVillagers$refreshButton;
    @Unique
    private class_4185 pocketVillagers$releaseButton;
    @Unique
    private class_4185 pocketVillagers$ejectButton;
    @Unique
    private class_342 pocketVillagers$targetInput;
    @Unique
    private class_4185 pocketVillagers$autoStartButton;
    @Unique
    private boolean pocketVillagers$autoRefreshing = false;
    @Unique
    private int pocketVillagers$autoRefreshCooldown = 0;
    @Unique
    private String pocketVillagers$targetItem = "";
    @Unique
    private boolean pocketVillagers$inputVisible = false;
    @Shadow
    private int field_19163;
    @Unique
    private List<String> pocketVillagers$suggestions = new ArrayList<String>();
    @Unique
    private String pocketVillagers$lastSuggestionPrefix = "";
    @Unique
    private long pocketVillagers$lastAutoRefreshTimeMs = 0L;
    @Unique
    private int pocketVillagers$autoRefreshIntervalMs = 250;
    private static final class_2960 REFRESH_ICON = class_2960.method_60655((String)"pocket_villagers", (String)"textures/gui/refresh_trades.png");
    private static final class_2960 RELEASE_ICON = class_2960.method_60655((String)"pocket_villagers", (String)"textures/gui/release_villager.png");
    @Unique
    private long pocketVillagers$lastAutoRefillMs = 0L;

    protected MerchantScreenButtonMixin(class_1728 menu, class_1661 inventory, class_2561 title) {
        super((class_1703)menu, inventory, title);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void pocketVillagers$initButtons(CallbackInfo ci) {
        class_4185 refresh;
        class_492 screen = (class_492)this;
        int btnW = 56;
        int btnH = 13;
        int pad = 2;
        int left = ((MerchantScreenAccessor)screen).pocketVillagers$getLeftPos();
        int top = ((MerchantScreenAccessor)screen).pocketVillagers$getTopPos();
        int imgW = ((MerchantScreenAccessor)screen).pocketVillagers$getImageWidth();
        int imgH = ((MerchantScreenAccessor)screen).pocketVillagers$getImageHeight();
        int baseX = left + imgW - 56 - 2 - 6;
        int totalH = 43;
        int baseY = top + Math.max(2, (imgH - totalH) / 2);
        int releaseX = baseX + 3;
        int releaseY = baseY + 6 + 2;
        int ejectX = releaseX - 28 - 28;
        int ejectY = baseY + 13 + 2 - 6 - 1;
        int refreshW = 20;
        int refreshH = 22;
        int refreshX = left + 6 + 120 - 10 - 12;
        int refreshY = top + 22;
        this.pocketVillagers$releaseButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)" \u2b06 Release"), btn -> {
            try {
                class_2338 p = PocketCubeClient.getCachedPos();
                PocketVillagersMod.LOGGER.debug("PocketCube: Release clicked at {} (pressed)", (Object)(p == null ? "<unknown>" : p));
                btn.method_25350(0.7f);
                if (p != null) {
                    ClientPlayNetworking.send((class_8710)new EjectWorkstationPacket(p));
                }
                if (p != null) {
                    ClientPlayNetworking.send((class_8710)new ReleasePocketVillagerPacket(p));
                } else {
                    PocketVillagersMod.LOGGER.debug("PocketCube: Release attempted but no PocketCube pos known");
                }
                btn.method_25350(1.0f);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }).method_46434(releaseX, releaseY, 56, 13).method_46431();
        this.pocketVillagers$ejectButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u23cf Eject"), btn -> {
            try {
                class_2338 p = PocketCubeClient.getCachedPos();
                PocketVillagersMod.LOGGER.debug("PocketCube: Eject clicked at {} (pressed)", (Object)(p == null ? "<unknown>" : p));
                btn.method_25350(0.7f);
                if (p != null) {
                    ClientPlayNetworking.send((class_8710)new EjectWorkstationPacket(p));
                } else {
                    PocketVillagersMod.LOGGER.debug("PocketCube: Eject attempted but no PocketCube pos known");
                }
                btn.method_25350(1.0f);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }).method_46434(ejectX, ejectY, 56, 13).method_46431();
        try {
            this.pocketVillagers$ejectButton.field_22763 = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.pocketVillagers$refreshButton = refresh = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u27f3"), btn -> {
            try {
                class_2338 p = PocketCubeClient.getCachedPos();
                PocketVillagersMod.LOGGER.debug("PocketCube: Refresh clicked at {} (pressed)", (Object)(p == null ? "<unknown>" : p));
                btn.method_25350(0.7f);
                if (p != null) {
                    int baseOffers = 2;
                    ClientPlayNetworking.send((class_8710)new RefreshTradesPacket(p, false, baseOffers));
                } else {
                    PocketVillagersMod.LOGGER.debug("PocketCube: Refresh attempted but no PocketCube pos known");
                }
                btn.method_25350(1.0f);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }).method_46434(refreshX, refreshY, 20, 22).method_46431();
        int inputW = 120;
        int inputH = 12;
        int inputX = refreshX + 20 + 6;
        int inputY = refreshY;
        try {
            this.pocketVillagers$targetInput = new class_342(this, this.field_22793, inputX, inputY, inputW, inputH, (class_2561)class_2561.method_43470((String)"target")){

                public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                    return true;
                }

                public boolean charTyped(char codePoint, int modifiers) {
                    try {
                        return false;
                    }
                    catch (Throwable ignored) {
                        return false;
                    }
                }
            };
            this.pocketVillagers$targetInput.method_1852("");
            this.method_37063((class_364)this.pocketVillagers$targetInput);
            if (this.pocketVillagers$targetInput != null) {
                this.pocketVillagers$targetInput.field_22764 = false;
            }
        }
        catch (Throwable ignored) {
            this.pocketVillagers$targetInput = null;
        }
        try {
            this.pocketVillagers$autoStartButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Start"), btn -> {
                try {
                    if (this.pocketVillagers$targetInput == null) {
                        return;
                    }
                    String v = this.pocketVillagers$targetInput.method_1882().trim();
                    if (v.isEmpty()) {
                        return;
                    }
                    if (this.pocketVillagers$autoRefreshing) {
                        this.pocketVillagers$autoRefreshing = false;
                        btn.method_25355((class_2561)class_2561.method_43470((String)"Start"));
                    } else {
                        this.pocketVillagers$targetItem = v;
                        this.pocketVillagers$autoRefreshing = true;
                        this.pocketVillagers$lastAutoRefreshTimeMs = 0L;
                        btn.method_25355((class_2561)class_2561.method_43470((String)"Stop"));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }).method_46434(inputX + inputW + 4, inputY, 40, inputH).method_46431();
            this.method_37063((class_364)this.pocketVillagers$autoStartButton);
            if (this.pocketVillagers$autoStartButton != null) {
                this.pocketVillagers$autoStartButton.field_22764 = false;
            }
        }
        catch (Throwable ignored) {
            this.pocketVillagers$autoStartButton = null;
        }
        try {
            boolean isPocketMenu = false;
            try {
                MerchantMenuAccessor accessor;
                class_1703 class_17032 = this.field_2797;
                if (class_17032 instanceof MerchantMenuAccessor && (accessor = (MerchantMenuAccessor)class_17032).pocketVillagers$getPocketCubePos() != null) {
                    isPocketMenu = true;
                }
                try {
                    String t;
                    if (!isPocketMenu && this.field_22785 != null && ((t = this.field_22785.getString().toLowerCase(Locale.ROOT)).contains("pocket cube") || t.contains("pocket_cube") || t.contains("pocketcube"))) {
                        isPocketMenu = true;
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    class_1915 trader = ((MerchantMenuTraderAccessor)this.field_2797).pocketVillagers$getTrader();
                    if (trader != null && trader.getClass().getName().contains("ClientSideMerchantDuck")) {
                        isPocketMenu = true;
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (isPocketMenu) {
                PocketVillagersMod.LOGGER.debug("PocketCube: Adding buttons to MerchantScreen (init phase)");
                this.method_37063((class_364)this.pocketVillagers$releaseButton);
                this.method_37063((class_364)this.pocketVillagers$ejectButton);
                this.method_37063((class_364)this.pocketVillagers$refreshButton);
            } else {
                PocketVillagersMod.LOGGER.debug("PocketCube: MerchantScreen opened for non-pocket villager; skipping Pocket Cube buttons");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Inject(method={"renderContents"}, at={@At(value="TAIL")}, require=0)
    private void pocketVillagers$drawButtonTooltips(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        block22: {
            if (!(this instanceof class_492)) {
                return;
            }
            try {
                try {
                    if (this.pocketVillagers$ejectButton != null) {
                        this.pocketVillagers$ejectButton.field_22763 = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.pocketVillagers$releaseButton != null && this.pocketVillagers$releaseButton.method_49606()) {
                    this.drawButtonTooltip(guiGraphics, this.pocketVillagers$releaseButton, (class_2561)class_2561.method_43470((String)"Release Villager + Workstation"), mouseX, mouseY);
                }
                if (this.pocketVillagers$ejectButton != null && this.pocketVillagers$ejectButton.method_49606()) {
                    this.drawButtonTooltip(guiGraphics, this.pocketVillagers$ejectButton, (class_2561)class_2561.method_43470((String)"Eject Workstation"), mouseX, mouseY);
                }
                if (this.pocketVillagers$refreshButton != null && this.pocketVillagers$refreshButton.method_49606()) {
                    this.drawButtonTooltip(guiGraphics, this.pocketVillagers$refreshButton, (class_2561)class_2561.method_43470((String)"Refresh Trades"), mouseX, mouseY);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (!this.pocketVillagers$inputVisible) break block22;
                if (this.pocketVillagers$targetInput != null) {
                    this.pocketVillagers$targetInput.method_25394(guiGraphics, mouseX, mouseY, this.partialTickFloat());
                }
                if (this.pocketVillagers$autoStartButton != null) {
                    this.pocketVillagers$autoStartButton.method_25394(guiGraphics, mouseX, mouseY, this.partialTickFloat());
                }
                try {
                    this.updateSuggestionsIfNeeded();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (this.pocketVillagers$suggestions != null && !this.pocketVillagers$suggestions.isEmpty()) {
                        this.renderSuggestions(guiGraphics, mouseX, mouseY);
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            this.pocketVillagers$maybeAutoRefresh();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.pocketVillagers$maybeAutoRefill();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Unique
    private void pocketVillagers$maybeAutoRefill() {
        try {
            if (this.field_22787 == null || this.field_22787.field_1724 == null) {
                return;
            }
            if (this.field_2797 == null) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now - this.pocketVillagers$lastAutoRefillMs < 150L) {
                return;
            }
            class_1661 playerInv = this.field_22787.field_1724.method_31548();
            if (playerInv == null) {
                return;
            }
            int sel = playerInv.method_67532();
            class_1799 held = playerInv.method_7391();
            if (held != null && !held.method_7960()) {
                return;
            }
            class_1916 offers = ((class_1728)this.field_2797).method_17438();
            if (offers == null || offers.isEmpty()) {
                return;
            }
            for (int h = 0; h < 9; ++h) {
                try {
                    class_1799 stack = playerInv.method_5438(h);
                    if (stack == null || stack.method_7960()) continue;
                    boolean matchesAny = false;
                    for (int oi = 0; oi < offers.size(); ++oi) {
                        try {
                            class_1914 off = (class_1914)offers.get(oi);
                            if (off == null) continue;
                            class_1799 a = off.method_19272();
                            class_1799 b = off.method_8247();
                            if (a != null && a.method_7909() == stack.method_7909()) {
                                matchesAny = true;
                                break;
                            }
                            if (b == null || b.method_7909() != stack.method_7909()) continue;
                            matchesAny = true;
                            break;
                        }
                        catch (Throwable off) {
                            // empty catch block
                        }
                    }
                    if (!matchesAny) continue;
                    try {
                        try {
                            Field selField = playerInv.getClass().getDeclaredField("selected");
                            selField.setAccessible(true);
                            selField.setInt(playerInv, h);
                        }
                        catch (NoSuchFieldException nsf) {
                            try {
                                Field selField2 = playerInv.getClass().getDeclaredField("selectedSlot");
                                selField2.setAccessible(true);
                                selField2.setInt(playerInv, h);
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.field_22787.field_1724 != null && this.field_22787.field_1724.field_3944 != null) {
                        this.field_22787.field_1724.field_3944.method_52787((class_2596)new class_2868(h));
                    }
                    this.pocketVillagers$lastAutoRefillMs = now;
                    try {
                        PocketVillagersMod.LOGGER.debug("PocketCube: auto-refill selected hotbar {}", (Object)h);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Unique
    private void updateSuggestionsIfNeeded() {
        try {
            String prefix;
            block31: {
                if (this.pocketVillagers$targetInput == null) {
                    return;
                }
                String cur = this.pocketVillagers$targetInput.method_1882();
                if (cur == null) {
                    cur = "";
                }
                if ((prefix = cur.trim().toLowerCase(Locale.ROOT)).equals(this.pocketVillagers$lastSuggestionPrefix)) {
                    return;
                }
                this.pocketVillagers$lastSuggestionPrefix = prefix;
                this.pocketVillagers$suggestions.clear();
                try {
                    class_1916 offers = this.field_2797 == null ? null : ((class_1728)this.field_2797).method_17438();
                    int limit = 8;
                    if (offers == null || offers.isEmpty()) break block31;
                    LinkedHashSet<String> seen = new LinkedHashSet<String>();
                    for (int i = 0; i < offers.size() && seen.size() < limit; ++i) {
                        try {
                            class_1799 result;
                            class_1914 offer = (class_1914)offers.get(i);
                            if (offer == null || (result = offer.method_8250()) == null) continue;
                            try {
                                class_2960 key = class_7923.field_41178.method_10221((Object)result.method_7909());
                                if (key != null) {
                                    String full = key.toString().toLowerCase(Locale.ROOT);
                                    if (prefix.isEmpty() || full.startsWith(prefix) || key.method_12832().toLowerCase(Locale.ROOT).startsWith(prefix)) {
                                        seen.add(full);
                                    }
                                }
                            }
                            catch (Throwable key) {
                                // empty catch block
                            }
                            try {
                                int idx;
                                if (result.method_7909() != class_1802.field_8598) continue;
                                String stackStr = result.toString().toLowerCase(Locale.ROOT);
                                if (prefix.isEmpty()) {
                                    seen.add("minecraft:enchanted_book");
                                    continue;
                                }
                                if (!stackStr.contains(prefix) && !stackStr.contains("minecraft:" + prefix) || (idx = stackStr.indexOf(prefix)) < 0) continue;
                                int start = Math.max(0, idx - 10);
                                int end = Math.min(stackStr.length(), idx + 40);
                                String window = stackStr.substring(start, end);
                                Matcher m = Pattern.compile("[a-z0-9_:-]+", 2).matcher(window);
                                while (m.find()) {
                                    String token = m.group().toLowerCase(Locale.ROOT);
                                    if (!token.contains(prefix)) continue;
                                    if (token.startsWith("minecraft:")) {
                                        token = token.substring("minecraft:".length());
                                    }
                                    token = token.replace('_', ' ');
                                    seen.add(token);
                                    if (seen.size() < limit) continue;
                                }
                            }
                            catch (Throwable throwable) {}
                            continue;
                        }
                        catch (Throwable offer) {
                            // empty catch block
                        }
                    }
                    int added = 0;
                    for (String s : seen) {
                        if (added >= limit) break;
                        this.pocketVillagers$suggestions.add(s);
                        ++added;
                    }
                    if (!this.pocketVillagers$suggestions.isEmpty()) {
                        return;
                    }
                }
                catch (Throwable offers) {
                    // empty catch block
                }
            }
            try {
                if (prefix != null && !prefix.isEmpty() && this.pocketVillagers$suggestions.isEmpty()) {
                    String clean = prefix;
                    if (clean.startsWith("minecraft:")) {
                        clean = clean.substring("minecraft:".length());
                    }
                    if (clean.matches("[a-z0-9_-]+")) {
                        this.pocketVillagers$suggestions.add(clean);
                    }
                }
            }
            catch (Throwable clean) {
                // empty catch block
            }
            if (prefix.isEmpty()) {
                this.pocketVillagers$suggestions.add("minecraft:enchanted_book");
                this.pocketVillagers$suggestions.add("minecraft:book");
                this.pocketVillagers$suggestions.add("minecraft:diamond_sword");
                return;
            }
            int limit = 8;
            try {
                for (class_2960 key : class_7923.field_41178.method_10235()) {
                    if (this.pocketVillagers$suggestions.size() < limit) {
                        if (key == null) continue;
                        String s = key.toString().toLowerCase(Locale.ROOT);
                        String path = key.method_12832().toLowerCase(Locale.ROOT);
                        if (!s.startsWith(prefix) && !path.startsWith(prefix)) continue;
                        this.pocketVillagers$suggestions.add(s);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Unique
    private void renderSuggestions(class_332 guiGraphics, int mouseX, int mouseY) {
        try {
            if (this.pocketVillagers$targetInput == null) {
                return;
            }
            this.updateSuggestionsIfNeeded();
            if (this.pocketVillagers$suggestions == null || this.pocketVillagers$suggestions.isEmpty()) {
                return;
            }
            int ix = this.pocketVillagers$targetInput.method_46426();
            int ih = this.pocketVillagers$targetInput.method_25364();
            int iyBelow = this.pocketVillagers$targetInput.method_46427() + ih + 2;
            int iw = this.pocketVillagers$targetInput.method_25368();
            int pad = 4;
            Objects.requireNonNull(this.field_22793);
            int lineH = 9 + 2;
            int boxH = this.pocketVillagers$suggestions.size() * lineH + pad * 2;
            int boxW = Math.max(iw, 140);
            int iy = iyBelow;
            int bg = -871747777;
            int border = -16711681;
            int shadow = -2147467184;
            guiGraphics.method_25294(ix + 2, iy + 2, ix + boxW + 2, iy + boxH + 2, shadow);
            guiGraphics.method_25294(ix, iy, ix + boxW, iy + boxH, bg);
            guiGraphics.method_25294(ix, iy, ix + boxW, iy + 1, border);
            guiGraphics.method_25294(ix, iy + boxH - 1, ix + boxW, iy + boxH, border);
            for (int i = 0; i < this.pocketVillagers$suggestions.size(); ++i) {
                int sy = iy + pad + i * lineH;
                String s = this.pocketVillagers$suggestions.get(i);
                boolean hover = mouseX >= ix && mouseX <= ix + boxW && mouseY >= sy && mouseY <= sy + lineH;
                int textColor = hover ? -10496 : -1;
                guiGraphics.method_51433(this.field_22793, s, ix + pad, sy, textColor, false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void drawButtonTooltip(class_332 guiGraphics, class_4185 btn, class_2561 text, int mouseX, int mouseY) {
        int pad = 6;
        int lineW = this.field_22793.method_27525((class_5348)text);
        int boxW = lineW + pad * 2;
        Objects.requireNonNull(this.field_22793);
        int lineHeight = 9;
        int boxH = lineHeight + pad * 2 - 4;
        int x = mouseX + 12;
        int y = mouseY - boxH - 6;
        if (x + boxW > this.field_22789 - 4) {
            x = this.field_22789 - boxW - 4;
        }
        if (y < 4) {
            y = mouseY + 12;
        }
        int bg = -871747777;
        int border = -16711681;
        int shadow = -2147467184;
        guiGraphics.method_25294(x + 2, y + 2, x + boxW + 2, y + boxH + 2, shadow);
        guiGraphics.method_25294(x, y, x + boxW, y + boxH, bg);
        guiGraphics.method_25294(x, y, x + boxW, y + 1, border);
        guiGraphics.method_25294(x, y + boxH - 1, x + boxW, y + boxH, border);
        int textX = x + pad;
        int textY = y + pad - 2;
        guiGraphics.method_51439(this.field_22793, text, textX, textY, -1, false);
    }

    @Unique
    private void pocketVillagers$maybeAutoRefresh() {
        block25: {
            try {
                block24: {
                    if (this.field_22787 == null || this.field_22787.field_1755 != this) {
                        this.pocketVillagers$autoRefreshing = false;
                        this.pocketVillagers$inputVisible = false;
                        return;
                    }
                    if (!this.pocketVillagers$autoRefreshing) {
                        return;
                    }
                    if (this.field_2797 == null) {
                        return;
                    }
                    long now = System.currentTimeMillis();
                    if (now - this.pocketVillagers$lastAutoRefreshTimeMs < (long)this.pocketVillagers$autoRefreshIntervalMs) {
                        return;
                    }
                    try {
                        class_1916 offers;
                        if (this.pocketVillagers$targetItem == null || this.pocketVillagers$targetItem.isEmpty() || (offers = ((class_1728)this.field_2797).method_17438()) == null) break block24;
                        for (int i = 0; i < offers.size(); ++i) {
                            class_1799 result;
                            class_1914 offer = (class_1914)offers.get(i);
                            if (offer == null || (result = offer.method_8250()) == null) continue;
                            try {
                                if (!this.matchesTarget(result, this.pocketVillagers$targetItem) && !this.matchesTarget(offer.method_19272(), this.pocketVillagers$targetItem) && !this.matchesTarget(offer.method_8247(), this.pocketVillagers$targetItem)) continue;
                                this.pocketVillagers$autoRefreshing = false;
                                if (this.pocketVillagers$autoStartButton != null) {
                                    this.pocketVillagers$autoStartButton.method_25355((class_2561)class_2561.method_43470((String)"Start"));
                                }
                                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                                    this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7a\u2713 Found: " + this.pocketVillagers$targetItem)), false);
                                }
                                try {
                                    String itemKey = class_7923.field_41178.method_10221((Object)result.method_7909()).toString();
                                    PocketVillagersMod.LOGGER.debug("Auto-refresh SUCCESS: found '{}' in offer slot {} (item: {})", (Object)this.pocketVillagers$targetItem, (Object)i, (Object)itemKey);
                                }
                                catch (Throwable itemKey) {
                                    // empty catch block
                                }
                                return;
                            }
                            catch (Throwable itemKey) {
                                // empty catch block
                            }
                        }
                    }
                    catch (Throwable offers) {
                        // empty catch block
                    }
                }
                try {
                    class_2338 p = PocketCubeClient.getCachedPos();
                    if (p == null) break block25;
                    try {
                        StringBuilder sb = new StringBuilder();
                        class_1916 offers = ((class_1728)this.field_2797).method_17438();
                        if (offers != null && !offers.isEmpty()) {
                            for (int oi = 0; oi < offers.size(); ++oi) {
                                try {
                                    List<String> enchants;
                                    class_1799 res;
                                    class_1914 offer = (class_1914)offers.get(oi);
                                    if (offer == null || (res = offer.method_8250()) == null) continue;
                                    class_1792 item = res.method_7909();
                                    String key = class_7923.field_41178.method_10221((Object)item).toString();
                                    sb.append("[").append(oi).append(":").append(key);
                                    if (item == class_1802.field_8598 && !(enchants = this.getEnchantmentsFromBook(res)).isEmpty()) {
                                        sb.append("{").append(String.join((CharSequence)",", enchants)).append("}");
                                    }
                                    sb.append("] ");
                                    continue;
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                        PocketVillagersMod.LOGGER.debug("Auto-refresh: searching for '{}' | Current offers: {}", (Object)this.pocketVillagers$targetItem, (Object)sb.toString());
                    }
                    catch (Throwable sb) {
                        // empty catch block
                    }
                    int baseOffers = 2;
                    ClientPlayNetworking.send((class_8710)new RefreshTradesPacket(p, true, baseOffers));
                    this.pocketVillagers$lastAutoRefreshTimeMs = System.currentTimeMillis();
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Unique
    private List<String> getEnchantmentsFromBook(class_1799 stack) {
        String[] commonEnchants;
        String displayName;
        ArrayList<String> enchants;
        block86: {
            block85: {
                String roman;
                enchants = new ArrayList<String>();
                if (stack == null || stack.method_7909() != class_1802.field_8598) {
                    return enchants;
                }
                PocketVillagersMod.LOGGER.debug("=== DETECTING ENCHANTMENTS ===");
                try {
                    displayName = stack.method_7964().getString().toLowerCase(Locale.ROOT);
                    PocketVillagersMod.LOGGER.debug("Display name: {}", (Object)displayName);
                    for (String ench : commonEnchants = new String[]{"mending", "unbreaking", "protection", "sharpness", "efficiency", "knockback", "fire_aspect", "fire aspect", "looting", "sweeping", "fortune", "punch", "power", "flame", "infinity", "depth_strider", "depth strider", "frost_walker", "frost walker", "thorns", "aqua_affinity", "aqua affinity", "respiration", "feather_falling", "feather falling", "blast_protection", "blast protection", "projectile_protection", "projectile protection", "fire_protection", "fire protection", "binding_curse", "binding curse", "vanishing_curse", "vanishing curse", "silk_touch", "silk touch", "fortune", "impaling", "riptide", "channeling", "loyalty", "piercing", "multishot", "quick_charge", "quick charge", "sweeping_edge", "sweeping edge", "smite", "bane_of_arthropods", "bane of arthropods"}) {
                        String level;
                        String withLevel;
                        Pattern arabicPattern;
                        Matcher am;
                        String withLevel2;
                        Pattern romanPattern;
                        Matcher m;
                        if (!displayName.contains(ench)) continue;
                        String normalized = ench.replace(' ', '_');
                        if (!enchants.contains(normalized)) {
                            enchants.add(normalized);
                            PocketVillagersMod.LOGGER.debug("\u2713 Display name match: {} -> {}", (Object)ench, (Object)normalized);
                        }
                        if ((m = (romanPattern = Pattern.compile("\\b(v|iv|iii|ii|i)\\b")).matcher(displayName)).find() && !enchants.contains(withLevel2 = normalized + "_" + (roman = m.group(1)))) {
                            enchants.add(withLevel2);
                            PocketVillagersMod.LOGGER.debug("\u2713 Found roman numeral: {} -> {}", (Object)roman, (Object)withLevel2);
                        }
                        if (!(am = (arabicPattern = Pattern.compile("\\b([0-9]+)\\b")).matcher(displayName)).find() || enchants.contains(withLevel = normalized + "_" + (level = am.group(1)))) continue;
                        enchants.add(withLevel);
                        PocketVillagersMod.LOGGER.debug("\u2713 Found arabic numeral: {} -> {}", (Object)level, (Object)withLevel);
                    }
                    if (!enchants.isEmpty()) {
                        PocketVillagersMod.LOGGER.debug("Display name parsing found enchants: {}", enchants);
                        return enchants;
                    }
                }
                catch (Throwable ignored) {
                    PocketVillagersMod.LOGGER.warn("Display name parsing failed: {}", (Object)ignored.getMessage());
                }
                try {
                    class_9331 enchantmentsComponent;
                    PocketVillagersMod.LOGGER.debug("Trying direct component access...");
                    if (stack.method_7909() == class_1802.field_8598) {
                        enchantmentsComponent = class_9334.field_49643;
                        PocketVillagersMod.LOGGER.debug("Using STORED_ENCHANTMENTS for enchanted book");
                    } else {
                        enchantmentsComponent = class_9334.field_49633;
                        PocketVillagersMod.LOGGER.debug("Using ENCHANTMENTS for regular item");
                    }
                    if (stack.method_57826(enchantmentsComponent)) {
                        Object enchantmentsObj = stack.method_58694(enchantmentsComponent);
                        PocketVillagersMod.LOGGER.debug("Found enchantments component: {}", (Object)(enchantmentsObj == null ? "null" : enchantmentsObj.getClass().getName()));
                        Object mapObj = enchantmentsObj;
                        PocketVillagersMod.LOGGER.debug("Invoked method, result type: {}", (Object)(mapObj == null ? "null" : mapObj.getClass().getName()));
                        if (mapObj instanceof Map) {
                            Map emap = (Map)mapObj;
                            PocketVillagersMod.LOGGER.debug("Map has {} entries", (Object)emap.size());
                            for (Object enchantObj : emap.keySet()) {
                                try {
                                    PocketVillagersMod.LOGGER.debug("Processing enchant object: {}", (Object)(enchantObj == null ? "<null>" : enchantObj.getClass().getName()));
                                    String enchantId = null;
                                    try {
                                        Optional opt;
                                        Method unwrapKey = enchantObj.getClass().getMethod("unwrapKey", new Class[0]);
                                        String[] optKey = unwrapKey.invoke(enchantObj, new Object[0]);
                                        if (optKey instanceof Optional && (opt = (Optional)optKey).isPresent()) {
                                            Object resourceKey = opt.get();
                                            Method location = resourceKey.getClass().getMethod("location", new Class[0]);
                                            Object rl = location.invoke(resourceKey, new Object[0]);
                                            enchantId = rl.toString();
                                            PocketVillagersMod.LOGGER.debug("Got ID via unwrapKey: {}", (Object)enchantId);
                                        }
                                    }
                                    catch (Exception e) {
                                        PocketVillagersMod.LOGGER.debug("unwrapKey failed: {}", (Object)e.getMessage());
                                    }
                                    if (enchantId == null) {
                                        enchantId = enchantObj == null ? null : enchantObj.toString();
                                        PocketVillagersMod.LOGGER.debug("Got ID via toString: {}", (Object)enchantId);
                                    }
                                    if (enchantId == null) continue;
                                    if ((enchantId = enchantId.toLowerCase(Locale.ROOT)).startsWith("minecraft:")) {
                                        enchantId = enchantId.substring("minecraft:".length());
                                    }
                                    if (enchantId.contains("enchantment")) {
                                        String[] parts;
                                        for (String part : parts = enchantId.split("[\\[\\]{}]")) {
                                            String[] subparts;
                                            if (!part.contains(":") || part.contains("enchantment") || (subparts = part.split(":")).length <= 1) continue;
                                            enchantId = subparts[subparts.length - 1].trim();
                                            break;
                                        }
                                    }
                                    PocketVillagersMod.LOGGER.debug("Final enchant ID: {}", (Object)enchantId);
                                    if (enchants.contains(enchantId)) continue;
                                    enchants.add(enchantId);
                                }
                                catch (Exception e) {
                                    PocketVillagersMod.LOGGER.error("Failed to process enchant", (Throwable)e);
                                }
                            }
                            break block85;
                        }
                        if (mapObj instanceof Iterable) {
                            for (Object enchantObj : (Iterable)mapObj) {
                                try {
                                    if (enchantObj == null) continue;
                                    PocketVillagersMod.LOGGER.debug("Iterable enchant element: {}", (Object)enchantObj.getClass().getName());
                                    String enchantId = null;
                                    try {
                                        Method getString = enchantObj.getClass().getMethod("getString", String.class);
                                        Object idO = getString.invoke(enchantObj, "id");
                                        if (idO != null) {
                                            enchantId = idO.toString();
                                        }
                                    }
                                    catch (Throwable getString) {
                                        // empty catch block
                                    }
                                    if (enchantId == null) {
                                        enchantId = enchantObj.toString();
                                    }
                                    if (enchantId == null) continue;
                                    if ((enchantId = enchantId.toLowerCase(Locale.ROOT)).startsWith("minecraft:")) {
                                        enchantId = enchantId.substring("minecraft:".length());
                                    }
                                    if (enchants.contains(enchantId)) continue;
                                    enchants.add(enchantId);
                                }
                                catch (Throwable e) {
                                    PocketVillagersMod.LOGGER.error("Failed to process iterable enchant", e);
                                }
                            }
                            break block85;
                        }
                        if (mapObj == null) break block85;
                        try {
                            String dump = mapObj.toString().toLowerCase(Locale.ROOT);
                            PocketVillagersMod.LOGGER.debug("Fallback parsing of EnchantmentHelper result: {}", (Object)dump);
                            Matcher m = Pattern.compile("([a-z0-9_]+:[a-z0-9_]+)|([a-z0-9_]{3,})", 2).matcher(dump);
                            while (m.find()) {
                                String token = m.group();
                                if (token == null) continue;
                                if ((token = token.toLowerCase(Locale.ROOT)).startsWith("minecraft:")) {
                                    token = token.substring("minecraft:".length());
                                }
                                if (enchants.contains(token)) continue;
                                enchants.add(token);
                            }
                            try {
                                Matcher m2 = Pattern.compile("([a-z0-9_]+:[a-z0-9_]+|[a-z0-9_]{3,})[^\\d]{0,20}=>\\s*(\\d+)", 2).matcher(dump);
                                while (m2.find()) {
                                    String name = m2.group(1);
                                    String lvl = m2.group(2);
                                    if (name == null || lvl == null) continue;
                                    if ((name = name.toLowerCase(Locale.ROOT)).startsWith("minecraft:")) {
                                        name = name.substring("minecraft:".length());
                                    }
                                    int level = 0;
                                    try {
                                        level = Integer.parseInt(lvl);
                                    }
                                    catch (Throwable ignoredLevel) {
                                        level = -1;
                                    }
                                    if (!enchants.contains(name)) {
                                        enchants.add(name);
                                    }
                                    if (level <= 0) continue;
                                    roman = this.pocketVillagers$intToRoman(level);
                                    String withUnderscore = name + "_" + level;
                                    String withUnderscoreRoman = name + "_" + roman;
                                    String withSpace = name.replace('_', ' ') + " " + level;
                                    String withSpaceRoman = name.replace('_', ' ') + " " + roman;
                                    if (!enchants.contains(withUnderscore)) {
                                        enchants.add(withUnderscore);
                                    }
                                    if (!enchants.contains(withUnderscoreRoman)) {
                                        enchants.add(withUnderscoreRoman);
                                    }
                                    if (!enchants.contains(withSpace)) {
                                        enchants.add(withSpace);
                                    }
                                    if (enchants.contains(withSpaceRoman)) continue;
                                    enchants.add(withSpaceRoman);
                                }
                            }
                            catch (Throwable m2) {
                                // empty catch block
                            }
                            try {
                                Pattern idPattern = Pattern.compile("([a-z0-9_]+:[a-z0-9_]+)", 2);
                                Matcher idMatcher = idPattern.matcher(dump);
                                while (idMatcher.find()) {
                                    String fullId = idMatcher.group(1);
                                    if (fullId == null) continue;
                                    String idLower = fullId.toLowerCase(Locale.ROOT);
                                    String cleanId = idLower.startsWith("minecraft:") ? idLower.substring("minecraft:".length()) : idLower;
                                    int end = Math.min(dump.length(), idMatcher.end() + 80);
                                    String window = dump.substring(idMatcher.end(), end);
                                    Matcher lvlMatcher = Pattern.compile("=>\\s*(\\d+)").matcher(window);
                                    if (!lvlMatcher.find()) continue;
                                    String lvl = lvlMatcher.group(1);
                                    int level = -1;
                                    try {
                                        level = Integer.parseInt(lvl);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    if (!enchants.contains(cleanId)) {
                                        enchants.add(cleanId);
                                    }
                                    if (level <= 0) continue;
                                    String roman2 = this.pocketVillagers$intToRoman(level);
                                    String withUnderscore = cleanId + "_" + level;
                                    String withUnderscoreRoman = cleanId + "_" + roman2;
                                    String withSpace = cleanId.replace('_', ' ') + " " + level;
                                    String withSpaceRoman = cleanId.replace('_', ' ') + " " + roman2;
                                    if (!enchants.contains(withUnderscore)) {
                                        enchants.add(withUnderscore);
                                    }
                                    if (!enchants.contains(withUnderscoreRoman)) {
                                        enchants.add(withUnderscoreRoman);
                                    }
                                    if (!enchants.contains(withSpace)) {
                                        enchants.add(withSpace);
                                    }
                                    if (enchants.contains(withSpaceRoman)) continue;
                                    enchants.add(withSpaceRoman);
                                }
                                break block85;
                            }
                            catch (Throwable idPattern) {
                            }
                        }
                        catch (Throwable e) {
                            PocketVillagersMod.LOGGER.debug("Fallback parse failed: {}", (Object)e.getMessage());
                        }
                        break block85;
                    }
                    PocketVillagersMod.LOGGER.warn("Could not find getEnchantments method");
                }
                catch (Exception e) {
                    PocketVillagersMod.LOGGER.error("EnchantmentHelper failed", (Throwable)e);
                }
            }
            if (enchants.isEmpty()) {
                PocketVillagersMod.LOGGER.debug("Trying NBT method...");
                try {
                    Object components = null;
                    try {
                        Method getComponents = stack.getClass().getMethod("getComponents", new Class[0]);
                        components = getComponents.invoke((Object)stack, new Object[0]);
                        PocketVillagersMod.LOGGER.debug("Got components: {}", (Object)(components == null ? "null" : components.getClass().getName()));
                    }
                    catch (Exception e) {
                        PocketVillagersMod.LOGGER.debug("getComponents failed: {}", (Object)e.getMessage());
                    }
                    if (components != null) break block86;
                    Object tag = null;
                    try {
                        Method getTag = stack.getClass().getMethod("getTag", new Class[0]);
                        tag = getTag.invoke((Object)stack, new Object[0]);
                        PocketVillagersMod.LOGGER.debug("Got tag: {}", (Object)(tag == null ? "null" : tag.getClass().getName()));
                    }
                    catch (Exception e) {
                        PocketVillagersMod.LOGGER.debug("getTag failed: {}", (Object)e.getMessage());
                    }
                    if (tag == null) break block86;
                    Object list = null;
                    try {
                        Method getList = tag.getClass().getMethod("getList", String.class, Integer.TYPE);
                        list = getList.invoke(tag, "StoredEnchantments", 10);
                        if (list != null) {
                            Method size = list.getClass().getMethod("size", new Class[0]);
                            int count = (Integer)size.invoke(list, new Object[0]);
                            PocketVillagersMod.LOGGER.debug("StoredEnchantments has {} entries", (Object)count);
                            for (int i = 0; i < count; ++i) {
                                try {
                                    Method getCompound = list.getClass().getMethod("getCompound", Integer.TYPE);
                                    Object compound = getCompound.invoke(list, i);
                                    Method getString = compound.getClass().getMethod("getString", String.class);
                                    String id = (String)getString.invoke(compound, "id");
                                    PocketVillagersMod.LOGGER.debug("NBT enchant ID: {}", (Object)id);
                                    if (id == null || id.isEmpty()) continue;
                                    String clean = id.toLowerCase(Locale.ROOT);
                                    if (clean.startsWith("minecraft:")) {
                                        clean = clean.substring("minecraft:".length());
                                    }
                                    if (!enchants.contains(clean)) {
                                        enchants.add(clean);
                                    }
                                    try {
                                        int lvl = -1;
                                        try {
                                            Method getInt = compound.getClass().getMethod("getInt", String.class);
                                            Object lv = getInt.invoke(compound, "lvl");
                                            if (lv instanceof Number) {
                                                lvl = ((Number)lv).intValue();
                                            }
                                        }
                                        catch (Throwable ignoredLvl1) {
                                            try {
                                                Method getInt2 = compound.getClass().getMethod("getInt", String.class);
                                                Object lv2 = getInt2.invoke(compound, "level");
                                                if (lv2 instanceof Number) {
                                                    lvl = ((Number)lv2).intValue();
                                                }
                                            }
                                            catch (Throwable getInt2) {
                                                // empty catch block
                                            }
                                        }
                                        if (lvl <= 0) continue;
                                        String roman = this.pocketVillagers$intToRoman(lvl);
                                        String withUnderscore = clean + "_" + lvl;
                                        String withUnderscoreRoman = clean + "_" + roman;
                                        String withSpace = clean.replace('_', ' ') + " " + lvl;
                                        String withSpaceRoman = clean.replace('_', ' ') + " " + roman;
                                        if (!enchants.contains(withUnderscore)) {
                                            enchants.add(withUnderscore);
                                        }
                                        if (!enchants.contains(withUnderscoreRoman)) {
                                            enchants.add(withUnderscoreRoman);
                                        }
                                        if (!enchants.contains(withSpace)) {
                                            enchants.add(withSpace);
                                        }
                                        if (enchants.contains(withSpaceRoman)) continue;
                                        enchants.add(withSpaceRoman);
                                    }
                                    catch (Throwable throwable) {}
                                    continue;
                                }
                                catch (Exception e) {
                                    PocketVillagersMod.LOGGER.error("Failed to read NBT enchant", (Throwable)e);
                                }
                            }
                            break block86;
                        }
                        PocketVillagersMod.LOGGER.debug("getList returned null");
                    }
                    catch (Exception e) {
                        PocketVillagersMod.LOGGER.error("NBT reading failed", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    PocketVillagersMod.LOGGER.error("NBT method failed", (Throwable)e);
                }
            }
        }
        if (enchants.isEmpty()) {
            PocketVillagersMod.LOGGER.debug("Trying display name parsing...");
            try {
                displayName = stack.method_7964().getString().toLowerCase(Locale.ROOT);
                PocketVillagersMod.LOGGER.debug("Display name: {}", (Object)displayName);
                for (String enchant : commonEnchants = new String[]{"mending", "unbreaking", "protection", "sharpness", "efficiency", "fortune", "silk touch", "looting", "fire aspect", "flame", "infinity", "power", "punch", "knockback", "thorns", "respiration", "aqua affinity", "depth strider", "frost walker", "feather falling", "blast protection", "projectile protection", "fire protection", "smite", "bane of arthropods"}) {
                    if (!displayName.contains(enchant)) continue;
                    String normalized = enchant.replace(" ", "_");
                    PocketVillagersMod.LOGGER.debug("Found via display name: {}", (Object)normalized);
                    if (enchants.contains(normalized)) continue;
                    enchants.add(normalized);
                }
            }
            catch (Exception e) {
                PocketVillagersMod.LOGGER.error("Display name parsing failed", (Throwable)e);
            }
        }
        PocketVillagersMod.LOGGER.debug("Final enchantments list: {}", enchants);
        PocketVillagersMod.LOGGER.debug("=== END DETECTION ===");
        return enchants;
    }

    @Unique
    private boolean matchesTarget(class_1799 result, String target) {
        block46: {
            String baseTarget;
            int targetLevel;
            String t;
            block45: {
                if (result == null || target == null) {
                    PocketVillagersMod.LOGGER.debug("matchesTarget: null input - result={}, target={}", (Object)result, (Object)target);
                    return false;
                }
                t = target.trim().toLowerCase(Locale.ROOT);
                if (t.isEmpty()) {
                    PocketVillagersMod.LOGGER.debug("matchesTarget: empty target after trim");
                    return false;
                }
                try {
                    String itemName = class_7923.field_41178.method_10221((Object)result.method_7909()).toString();
                    String displayName = result.method_7964().getString();
                    PocketVillagersMod.LOGGER.debug("=== matchesTarget START === Item: {} | Display: {} | Target: '{}'", (Object)itemName, (Object)displayName, (Object)target);
                }
                catch (Throwable ignored) {
                    PocketVillagersMod.LOGGER.debug("=== matchesTarget START === Target: '{}'", (Object)target);
                }
                if (t.startsWith("enchant:") || t.startsWith("ench:") || t.startsWith("book:")) {
                    t = t.substring(t.indexOf(58) + 1).trim();
                }
                if (t.startsWith("minecraft:")) {
                    t = t.substring("minecraft:".length());
                }
                if (t.isEmpty()) {
                    return false;
                }
                targetLevel = -1;
                baseTarget = t;
                try {
                    Matcher lm = Pattern.compile("(.+?)[ _-]+(\\d+|[ivxlcdm]+)$", 2).matcher(t);
                    if (!lm.find()) break block45;
                    baseTarget = lm.group(1).trim();
                    String lvl = lm.group(2).toLowerCase(Locale.ROOT);
                    try {
                        targetLevel = Integer.parseInt(lvl);
                    }
                    catch (Throwable ignoredParse) {
                        try {
                            targetLevel = this.pocketVillagers$romanToInt(lvl);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable lm) {
                    // empty catch block
                }
            }
            String tUnderscore = baseTarget.replace(' ', '_');
            String tSpace = baseTarget.replace('_', ' ');
            class_1792 item = result.method_7909();
            if (item == class_1802.field_8598) {
                PocketVillagersMod.LOGGER.debug(">>> ENCHANTED BOOK DETECTED - Checking enchantments for target: '{}'", (Object)target);
                try {
                    String displayName = result.method_7964().getString().toLowerCase(Locale.ROOT);
                    PocketVillagersMod.LOGGER.debug("Enchanted book display name: '{}'", (Object)displayName);
                    if (displayName.contains(baseTarget) || displayName.contains(tUnderscore) || displayName.contains(tSpace) || displayName.matches(".*\\b" + Pattern.quote(baseTarget) + "\\b.*") || displayName.matches(".*\\b" + Pattern.quote(tUnderscore) + "\\b.*")) {
                        PocketVillagersMod.LOGGER.debug("\u2713\u2713\u2713 DIRECT TEXT MATCH \u2713\u2713\u2713 Found '{}' in display name: {}", (Object)baseTarget, (Object)displayName);
                        return true;
                    }
                    Object[] words = displayName.split("[\\s\\-_]+");
                    PocketVillagersMod.LOGGER.debug("Display name words: {}", (Object)Arrays.toString(words));
                    for (Object word : words) {
                        if (!((String)word).equals(baseTarget) && !((String)word).equals(tUnderscore) && !((String)word).equals(tSpace)) continue;
                        PocketVillagersMod.LOGGER.debug("\u2713\u2713\u2713 DIRECT WORD MATCH \u2713\u2713\u2713 Found '{}' as word in display name: {}", (Object)baseTarget, (Object)displayName);
                        return true;
                    }
                }
                catch (Throwable ignoredDirect) {
                    PocketVillagersMod.LOGGER.warn("Direct text matching failed: {}", (Object)ignoredDirect.getMessage());
                }
                try {
                    if (this.pocketVillagers$matchesEnchantedBookNbt(result, baseTarget, tUnderscore, tSpace, targetLevel)) {
                        PocketVillagersMod.LOGGER.debug("\u2713\u2713\u2713 NBT MATCH \u2713\u2713\u2713 Matched enchanted book via direct NBT for target='{}'", (Object)target);
                        return true;
                    }
                }
                catch (Throwable ignoredFast) {
                    PocketVillagersMod.LOGGER.warn("NBT matching failed: {}", (Object)ignoredFast.getMessage());
                }
                List<String> enchants = this.getEnchantmentsFromBook(result);
                PocketVillagersMod.LOGGER.debug("Target: '{}' | Enchants found: {}", (Object)target, enchants);
                for (String enchant : enchants) {
                    try {
                        String enchantNormalized = enchant.toLowerCase(Locale.ROOT).trim();
                        String enchantSpace = enchantNormalized.replace('_', ' ').trim();
                        String enchantUnderscore = enchantNormalized.replace(' ', '_').trim();
                        if (targetLevel > 0) {
                            String roman = this.pocketVillagers$intToRoman(targetLevel);
                            String userCand1 = tUnderscore + "_" + targetLevel;
                            String userCand2 = tUnderscore + "_" + roman;
                            String userCand3 = tSpace + " " + targetLevel;
                            String userCand4 = tSpace + " " + roman;
                            if (enchants.contains(userCand1) || enchants.contains(userCand2) || enchants.contains(userCand3) || enchants.contains(userCand4) || userCand1.equalsIgnoreCase(baseTarget) || userCand2.equalsIgnoreCase(baseTarget) || userCand3.equalsIgnoreCase(baseTarget) || userCand4.equalsIgnoreCase(baseTarget)) {
                                PocketVillagersMod.LOGGER.debug("\u2713\u2713\u2713 LEVEL MATCH (user-candidate) \u2713\u2713\u2713 target='{}' matched via user token level={}", (Object)target, (Object)targetLevel);
                                return true;
                            }
                            boolean plausible = false;
                            try {
                                if (enchantNormalized.equals(baseTarget) || enchantSpace.equals(baseTarget) || enchantUnderscore.equals(baseTarget)) {
                                    plausible = true;
                                }
                                if (!plausible && (enchantNormalized.contains(baseTarget) || baseTarget.contains(enchantNormalized))) {
                                    plausible = true;
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (plausible) {
                                String cand1 = enchantUnderscore + "_" + targetLevel;
                                String cand2 = enchantUnderscore + "_" + roman;
                                String cand3 = enchantSpace + " " + targetLevel;
                                String cand4 = enchantSpace + " " + roman;
                                if (cand1.equalsIgnoreCase(baseTarget) || cand2.equalsIgnoreCase(baseTarget) || cand3.equalsIgnoreCase(baseTarget) || cand4.equalsIgnoreCase(baseTarget) || enchants.contains(cand1) || enchants.contains(cand2) || enchants.contains(cand3) || enchants.contains(cand4)) {
                                    PocketVillagersMod.LOGGER.debug("\u2713\u2713\u2713 LEVEL MATCH \u2713\u2713\u2713 target='{}' matched enchant='{}' level={}", (Object)target, (Object)enchant, (Object)targetLevel);
                                    return true;
                                }
                            }
                        }
                        if (targetLevel > 0) continue;
                        if (baseTarget.contains(" ")) {
                            if (!enchantNormalized.equals(baseTarget) && !enchantSpace.equals(baseTarget) && !enchantUnderscore.equals(baseTarget)) continue;
                            PocketVillagersMod.LOGGER.debug("\u2713\u2713\u2713 PHRASE MATCH \u2713\u2713\u2713 target='{}' matched enchant='{}'", (Object)target, (Object)enchant);
                            return true;
                        }
                        if (!enchantNormalized.contains(baseTarget) && !enchantUnderscore.contains(baseTarget) && !enchantSpace.contains(baseTarget) && !baseTarget.contains(enchantNormalized) && !tUnderscore.contains(enchantNormalized) && !tSpace.contains(enchantNormalized)) continue;
                        PocketVillagersMod.LOGGER.debug("\u2713\u2713\u2713 MATCH FOUND \u2713\u2713\u2713 target='{}' matched enchant='{}'", (Object)target, (Object)enchant);
                        return true;
                    }
                    catch (Throwable ignoredInner) {
                        PocketVillagersMod.LOGGER.warn("Error checking enchant: {}", (Object)ignoredInner.getMessage());
                    }
                }
                PocketVillagersMod.LOGGER.warn("NO MATCH - target='{}' not found in enchants: {}", (Object)target, enchants);
                PocketVillagersMod.LOGGER.debug("=== matchesTarget END === Returning false for enchanted book target: '{}'", (Object)target);
                return false;
            }
            try {
                class_2960 key = class_7923.field_41178.method_10221((Object)item);
                if (key == null) break block46;
                String full = key.toString().toLowerCase(Locale.ROOT);
                String path = key.method_12832().toLowerCase(Locale.ROOT);
                if (full.equals(t) || path.equals(t) || full.equals(tUnderscore) || path.equals(tUnderscore) || full.equals(tSpace) || path.equals(tSpace) || full.contains(t) || path.contains(t) || full.contains(tUnderscore) || path.contains(tUnderscore) || full.contains(tSpace) || path.contains(tSpace)) {
                    PocketVillagersMod.LOGGER.debug("MATCH via item name: {}", (Object)path);
                    return true;
                }
                try {
                    String disp = result.method_7964().getString().toLowerCase(Locale.ROOT);
                    if (disp.contains(t) || disp.contains(tUnderscore) || disp.contains(tSpace)) {
                        PocketVillagersMod.LOGGER.debug("MATCH via display name: {}", (Object)disp);
                        return true;
                    }
                    if (baseTarget.contains(" ")) {
                        String[] toks;
                        String[] stringArray = toks = baseTarget.split("\\s+");
                        int n = stringArray.length;
                        for (int userCand1 = 0; userCand1 < n; ++userCand1) {
                            String tok = stringArray[userCand1];
                            if (tok == null || (tok = tok.trim()).length() < 2) continue;
                            String tokUnd = tok.replace(' ', '_');
                            if (!disp.contains(tok) && !disp.contains(tokUnd)) continue;
                            PocketVillagersMod.LOGGER.debug("MATCH via display token '{}' in '{}'", (Object)tok, (Object)disp);
                            return true;
                        }
                    }
                }
                catch (Throwable disp) {
                    // empty catch block
                }
                try {
                    if (baseTarget.contains(" ")) {
                        String[] toks;
                        for (String tok : toks = baseTarget.split("\\s+")) {
                            if (tok == null || (tok = tok.trim()).length() < 2) continue;
                            String tokUnd = tok.replace(' ', '_');
                            String tokSpace = tok.replace('_', ' ');
                            if (!full.contains(tok) && !path.contains(tok) && !full.contains(tokUnd) && !path.contains(tokUnd) && !full.contains(tokSpace) && !path.contains(tokSpace)) continue;
                            PocketVillagersMod.LOGGER.debug("MATCH via token '{}' in item name: {}", (Object)tok, (Object)path);
                            return true;
                        }
                    }
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        PocketVillagersMod.LOGGER.debug("=== matchesTarget END === Returning false for target: '{}'", (Object)target);
        return false;
    }

    @Unique
    private boolean pocketVillagers$matchesEnchantedBookNbt(class_1799 stack, String baseTarget, String tUnderscore, String tSpace, int targetLevel) {
        if (stack == null || stack.method_7909() != class_1802.field_8598) {
            return false;
        }
        try {
            String[] tryMethods;
            Object tag = null;
            for (String mname : tryMethods = new String[]{"getTag", "getNbt", "getOrCreateTag", "save", "toTag"}) {
                try {
                    Method m = stack.getClass().getMethod(mname, new Class[0]);
                    Object r = m.invoke((Object)stack, new Object[0]);
                    if (r == null) continue;
                    tag = r;
                    break;
                }
                catch (Throwable m) {
                    // empty catch block
                }
            }
            if (tag == null) {
                return false;
            }
            Object list = null;
            try {
                Method gl = tag.getClass().getMethod("getList", String.class);
                try {
                    list = gl.invoke(tag, "StoredEnchantments");
                }
                catch (Throwable ignoredL) {
                    try {
                        list = gl.invoke(tag, "Enchantments");
                    }
                    catch (Throwable ignoredL2) {
                        list = null;
                    }
                }
            }
            catch (Throwable ignoredGetList) {
                try {
                    Method gl2 = tag.getClass().getMethod("getList", String.class, Integer.TYPE);
                    try {
                        list = gl2.invoke(tag, "StoredEnchantments", 10);
                    }
                    catch (Throwable ignoredL) {
                        try {
                            list = gl2.invoke(tag, "Enchantments", 10);
                        }
                        catch (Throwable ignoredL2) {
                            list = null;
                        }
                    }
                }
                catch (Throwable ignoredGetList2) {
                    list = null;
                }
            }
            if (list == null) {
                return false;
            }
            int size = 0;
            try {
                Method sizeM = list.getClass().getMethod("size", new Class[0]);
                Object so = sizeM.invoke(list, new Object[0]);
                if (so instanceof Integer) {
                    size = (Integer)so;
                } else if (so instanceof Number) {
                    size = ((Number)so).intValue();
                }
            }
            catch (Throwable sizeM) {
                // empty catch block
            }
            if (size <= 0) {
                return false;
            }
            for (int ei = 0; ei < size; ++ei) {
                try {
                    int lvl;
                    String id;
                    block51: {
                        Object et = null;
                        try {
                            Method getCompound = list.getClass().getMethod("getCompound", Integer.TYPE);
                            et = getCompound.invoke(list, ei);
                        }
                        catch (Throwable ignoredGC) {
                            try {
                                Method get = list.getClass().getMethod("get", Integer.TYPE);
                                et = get.invoke(list, ei);
                            }
                            catch (Throwable ignoredG) {
                                et = null;
                            }
                        }
                        if (et == null) continue;
                        id = null;
                        try {
                            Method getString = et.getClass().getMethod("getString", String.class);
                            Object idO = getString.invoke(et, "id");
                            if (idO != null) {
                                id = idO.toString();
                            }
                        }
                        catch (Throwable ignoredId) {
                            try {
                                Method getString2 = et.getClass().getMethod("getString", String.class);
                                Object idO2 = getString2.invoke(et, "Name");
                                if (idO2 != null) {
                                    id = idO2.toString();
                                }
                            }
                            catch (Throwable getString2) {
                                // empty catch block
                            }
                        }
                        if (id == null) {
                            id = "";
                        }
                        if ((id = id.toLowerCase(Locale.ROOT)).startsWith("minecraft:")) {
                            id = id.substring("minecraft:".length());
                        }
                        lvl = -1;
                        try {
                            Method hasM = et.getClass().getMethod("contains", String.class);
                            boolean hasLvl = (Boolean)hasM.invoke(et, "lvl");
                            if (hasLvl) {
                                try {
                                    Method getShort = et.getClass().getMethod("getShort", String.class);
                                    Object lv = getShort.invoke(et, "lvl");
                                    if (lv instanceof Number) {
                                        lvl = ((Number)lv).intValue();
                                    }
                                    break block51;
                                }
                                catch (Throwable getShort) {}
                                break block51;
                            }
                            boolean hasLevel = (Boolean)hasM.invoke(et, "level");
                            if (!hasLevel) break block51;
                            try {
                                Method getShort2 = et.getClass().getMethod("getShort", String.class);
                                Object lv2 = getShort2.invoke(et, "level");
                                if (lv2 instanceof Number) {
                                    lvl = ((Number)lv2).intValue();
                                }
                            }
                            catch (Throwable throwable) {}
                        }
                        catch (Throwable hasM) {
                            // empty catch block
                        }
                    }
                    String enchantNormalized = id;
                    String enchantSpace = enchantNormalized.replace('_', ' ');
                    String enchantUnderscore = enchantNormalized.replace(' ', '_');
                    if (!(targetLevel > 0 ? lvl == targetLevel && (enchantNormalized.equals(baseTarget) || enchantSpace.equals(baseTarget) || enchantUnderscore.equals(baseTarget) || enchantNormalized.contains(baseTarget) || baseTarget.contains(enchantNormalized)) : (baseTarget.contains(" ") ? enchantNormalized.equals(baseTarget) || enchantSpace.equals(baseTarget) || enchantUnderscore.equals(baseTarget) : enchantNormalized.contains(baseTarget) || enchantUnderscore.contains(baseTarget) || enchantSpace.contains(baseTarget) || baseTarget.contains(enchantNormalized) || tUnderscore.contains(enchantNormalized) || tSpace.contains(enchantNormalized)))) continue;
                    return true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Unique
    private List<String> pocketVillagers$collectEnchantmentTokens(class_1799 stack) {
        ArrayList<String> out = new ArrayList<String>();
        if (stack == null) {
            return out;
        }
        boolean verbose = false;
        ArrayList<Object> helperFound = new ArrayList<Object>();
        ArrayList<String> ebFound = new ArrayList<String>();
        ArrayList<Object> nbtFound = new ArrayList<Object>();
        ArrayList<String> tokenFound = new ArrayList<String>();
        try {
            block80: {
                class_9331 enchantmentsComponent2;
                block79: {
                    try {
                        Object mapObj;
                        enchantmentsComponent2 = class_9334.field_49633;
                        if (!stack.method_57826(enchantmentsComponent2) || (mapObj = stack.method_58694(enchantmentsComponent2)) == null) break block79;
                        String[] mapStr = mapObj.toString().toLowerCase(Locale.ROOT);
                        helperFound.add(mapStr);
                        if (!out.contains(mapStr)) {
                            out.add((String)mapStr);
                        }
                        try {
                            Method keySet = mapObj.getClass().getMethod("keySet", new Class[0]);
                            Object keysObj = keySet.invoke(mapObj, new Object[0]);
                            if (keysObj instanceof Set) {
                                for (Object k : (Set)keysObj) {
                                    if (k == null) continue;
                                    String kn = k.toString().toLowerCase(Locale.ROOT);
                                    helperFound.add(kn);
                                    if (!out.contains(kn)) {
                                        out.add(kn);
                                    }
                                    try {
                                        Method desc = k.getClass().getMethod("getDescriptionId", new Class[0]);
                                        Object did = desc.invoke(k, new Object[0]);
                                        if (did == null) continue;
                                        String dd = did.toString().toLowerCase(Locale.ROOT);
                                        helperFound.add(dd);
                                        if (out.contains(dd)) continue;
                                        out.add(dd);
                                    }
                                    catch (Throwable desc) {}
                                }
                            }
                        }
                        catch (Throwable keySet) {
                        }
                    }
                    catch (Throwable enchantmentsComponent2) {
                        // empty catch block
                    }
                }
                try {
                    Object enchList;
                    if (stack.method_7909() == class_1802.field_8598 && stack.method_57826(enchantmentsComponent2 = class_9334.field_49643) && (enchList = stack.method_58694(enchantmentsComponent2)) != null) {
                        ebFound.add(enchList.toString().toLowerCase(Locale.ROOT));
                        if (!out.contains(enchList.toString().toLowerCase(Locale.ROOT))) {
                            out.add(enchList.toString().toLowerCase(Locale.ROOT));
                        }
                        if (enchList instanceof Iterable) {
                            for (Object e : (Iterable)enchList) {
                                if (e == null) continue;
                                String es = e.toString().toLowerCase(Locale.ROOT);
                                if (!tokenFound.contains(es)) {
                                    tokenFound.add(es);
                                }
                                if (out.contains(es)) continue;
                                out.add(es);
                            }
                        }
                    }
                }
                catch (Throwable enchantmentsComponent3) {
                    // empty catch block
                }
                try {
                    Object tag = null;
                    String[] tryMethods = new String[]{"getTag", "getNbt", "getOrCreateTag", "save", "toTag"};
                    for (String mname : tryMethods) {
                        try {
                            Method m = stack.getClass().getMethod(mname, new Class[0]);
                            Object r = m.invoke((Object)stack, new Object[0]);
                            if (r == null) continue;
                            tag = r;
                            break;
                        }
                        catch (Throwable m) {
                            // empty catch block
                        }
                    }
                    if (tag == null) break block80;
                    Object list = null;
                    try {
                        Method gl = tag.getClass().getMethod("getList", String.class);
                        try {
                            list = gl.invoke(tag, "StoredEnchantments");
                        }
                        catch (Throwable ignoredL) {
                            try {
                                list = gl.invoke(tag, "Enchantments");
                            }
                            catch (Throwable ignoredL2) {
                                list = null;
                            }
                        }
                    }
                    catch (Throwable ignoredGetList) {
                        try {
                            Method gl2 = tag.getClass().getMethod("getList", String.class, Integer.TYPE);
                            try {
                                list = gl2.invoke(tag, "StoredEnchantments", 10);
                            }
                            catch (Throwable ignoredL) {
                                try {
                                    list = gl2.invoke(tag, "Enchantments", 10);
                                }
                                catch (Throwable ignoredL2) {
                                    list = null;
                                }
                            }
                        }
                        catch (Throwable ignoredGetList2) {
                            list = null;
                        }
                    }
                    if (list == null) break block80;
                    int size = 0;
                    try {
                        Method sizeM = list.getClass().getMethod("size", new Class[0]);
                        Object so = sizeM.invoke(list, new Object[0]);
                        if (so instanceof Integer) {
                            size = (Integer)so;
                        } else if (so instanceof Number) {
                            size = ((Number)so).intValue();
                        }
                    }
                    catch (Throwable sizeM) {
                        // empty catch block
                    }
                    for (int ei = 0; ei < size; ++ei) {
                        try {
                            Object et;
                            block82: {
                                et = null;
                                try {
                                    Method getCompound = list.getClass().getMethod("getCompound", Integer.TYPE);
                                    et = getCompound.invoke(list, ei);
                                }
                                catch (Throwable ignoredGC) {
                                    try {
                                        Method get = list.getClass().getMethod("get", Integer.TYPE);
                                        et = get.invoke(list, ei);
                                    }
                                    catch (Throwable ignoredG) {
                                        et = null;
                                    }
                                }
                                if (et == null) continue;
                                try {
                                    Method getString = et.getClass().getMethod("getString", String.class);
                                    Object idO = getString.invoke(et, "id");
                                    if (idO == null) break block82;
                                    String idl = idO.toString().toLowerCase(Locale.ROOT);
                                    nbtFound.add(idl);
                                    if (!out.contains(idl)) {
                                        out.add(idl);
                                    }
                                    try {
                                        int lvl = -1;
                                        try {
                                            Method getInt = et.getClass().getMethod("getInt", String.class);
                                            Object lv = getInt.invoke(et, "lvl");
                                            if (lv instanceof Number) {
                                                lvl = ((Number)lv).intValue();
                                            }
                                        }
                                        catch (Throwable ignoredLvl1) {
                                            try {
                                                Method getInt2 = et.getClass().getMethod("getInt", String.class);
                                                Object lv2 = getInt2.invoke(et, "level");
                                                if (lv2 instanceof Number) {
                                                    lvl = ((Number)lv2).intValue();
                                                }
                                            }
                                            catch (Throwable getInt2) {
                                                // empty catch block
                                            }
                                        }
                                        if (lvl > 0) {
                                            String clean = idl;
                                            if (clean.startsWith("minecraft:")) {
                                                clean = clean.substring("minecraft:".length());
                                            }
                                            String roman = this.pocketVillagers$intToRoman(lvl);
                                            String withUnderscore = clean + "_" + lvl;
                                            String withUnderscoreRoman = clean + "_" + roman;
                                            String withSpace = clean.replace('_', ' ') + " " + lvl;
                                            String withSpaceRoman = clean.replace('_', ' ') + " " + roman;
                                            if (!out.contains(withUnderscore)) {
                                                out.add(withUnderscore);
                                            }
                                            if (!out.contains(withUnderscoreRoman)) {
                                                out.add(withUnderscoreRoman);
                                            }
                                            if (!out.contains(withSpace)) {
                                                out.add(withSpace);
                                            }
                                            if (!out.contains(withSpaceRoman)) {
                                                out.add(withSpaceRoman);
                                            }
                                            if (!nbtFound.contains(withUnderscore)) {
                                                nbtFound.add(withUnderscore);
                                            }
                                        }
                                    }
                                    catch (Throwable throwable) {}
                                }
                                catch (Throwable getString) {
                                    // empty catch block
                                }
                            }
                            try {
                                String etStr = et.toString().toLowerCase(Locale.ROOT);
                                if (!nbtFound.contains(etStr)) {
                                    nbtFound.add(etStr);
                                }
                                if (out.contains(etStr)) continue;
                                out.add(etStr);
                            }
                            catch (Throwable throwable) {}
                            continue;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable tag) {
                    // empty catch block
                }
            }
            try {
                String stackStr = stack.toString().toLowerCase(Locale.ROOT);
                Matcher m = Pattern.compile("[a-z0-9_:-]+", 2).matcher(stackStr);
                while (m.find()) {
                    String token = m.group().toLowerCase(Locale.ROOT);
                    if (!tokenFound.contains(token)) {
                        tokenFound.add(token);
                    }
                    if (out.contains(token)) continue;
                    out.add(token);
                }
            }
            catch (Throwable stackStr) {
            }
        }
        catch (Throwable stackStr) {
            // empty catch block
        }
        try {
            if (verbose && stack.method_7909() == class_1802.field_8598) {
                PocketVillagersMod.LOGGER.debug("PocketCube: enchant debug - EnchantmentHelper tokens: {}", helperFound);
                PocketVillagersMod.LOGGER.debug("PocketCube: enchant debug - EnchantedBookItem tokens: {}", ebFound);
                PocketVillagersMod.LOGGER.debug("PocketCube: enchant debug - NBT tokens: {}", nbtFound);
                PocketVillagersMod.LOGGER.debug("PocketCube: enchant debug - toString tokens: {}", tokenFound);
            }
        }
        catch (Throwable stackStr) {
            // empty catch block
        }
        ArrayList<String> finalOut = new ArrayList<String>();
        for (String s : out) {
            if (s == null) continue;
            String clean = s.toLowerCase(Locale.ROOT);
            if (clean.startsWith("minecraft:")) {
                clean = clean.substring("minecraft:".length());
            }
            if (finalOut.contains(clean)) continue;
            finalOut.add(clean);
        }
        return finalOut;
    }

    @Unique
    private List<String> pocketVillagers$collectEnchantmentMatchedTokens(class_1799 stack) {
        List<String> raw = this.pocketVillagers$collectEnchantmentTokens(stack);
        ArrayList<String> matched = new ArrayList<String>();
        if (raw == null || raw.isEmpty()) {
            return matched;
        }
        try {
            LinkedHashSet<String> found = new LinkedHashSet<String>();
            for (String token : raw) {
                if (token == null) continue;
                String t = token.toLowerCase(Locale.ROOT).trim();
                if (t.startsWith("minecraft:")) {
                    t = t.substring("minecraft:".length());
                }
                if (t.length() < 3 || t.matches("^\\d+$") || t.contains("book") || t.contains("enchanted") || t.contains("ench") || t.contains("lvl") || t.contains("level")) continue;
                String underscored = t.replace(' ', '_');
                String spaced = t.replace('_', ' ');
                String canon = underscored;
                if (canon.length() >= 3 && canon.matches("[a-z0-9_:-]+")) {
                    if (found.contains(canon)) continue;
                    found.add(canon);
                    continue;
                }
                if (spaced.length() < 3 || found.contains(spaced)) continue;
                found.add(spaced);
            }
            matched.addAll(found);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return matched;
    }

    @Unique
    private float partialTickFloat() {
        return 0.0f;
    }

    @Unique
    private String pocketVillagers$intToRoman(int num) {
        int n = Math.max(1, Math.min(10, num));
        return switch (n) {
            case 1 -> "i";
            case 2 -> "ii";
            case 3 -> "iii";
            case 4 -> "iv";
            case 5 -> "v";
            case 6 -> "vi";
            case 7 -> "vii";
            case 8 -> "viii";
            case 9 -> "ix";
            default -> "x";
        };
    }

    @Unique
    private int pocketVillagers$romanToInt(String roman) {
        String r;
        if (roman == null) {
            return -1;
        }
        return switch (r = roman.toLowerCase(Locale.ROOT).trim()) {
            case "i" -> 1;
            case "ii" -> 2;
            case "iii" -> 3;
            case "iv" -> 4;
            case "v" -> 5;
            case "vi" -> 6;
            case "vii" -> 7;
            case "viii" -> 8;
            case "ix" -> 9;
            case "x" -> 10;
            default -> -1;
        };
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    private void pocketVillagers$onMouseClicked(class_11909 event, boolean alreadyHandled, CallbackInfoReturnable<Boolean> cir) {
        try {
            double mouseX = event.comp_4798();
            double mouseY = event.comp_4799();
            int n = event.method_74245();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="TAIL")}, cancellable=true, require=0)
    private void pocketVillagers$onMouseClickedForward(class_11909 event, boolean alreadyHandled, CallbackInfoReturnable<Boolean> cir) {
        block13: {
            try {
                double mouseX = event.comp_4798();
                double mouseY = event.comp_4799();
                int button = event.method_74245();
                if (!this.pocketVillagers$inputVisible) {
                    return;
                }
                if (this.pocketVillagers$targetInput == null) {
                    return;
                }
                int ix = this.pocketVillagers$targetInput.method_46426();
                int iy = this.pocketVillagers$targetInput.method_46427();
                int iw = this.pocketVillagers$targetInput.method_25368();
                int ih = this.pocketVillagers$targetInput.method_25364();
                if (mouseX >= (double)ix && mouseX <= (double)(ix + iw) && mouseY >= (double)iy && mouseY <= (double)(iy + ih)) {
                    try {
                        boolean handled = this.pocketVillagers$targetInput.method_37303();
                        if (handled) {
                            cir.setReturnValue((Object)true);
                        }
                    }
                    catch (Throwable handled) {
                        // empty catch block
                    }
                }
                try {
                    int relY;
                    int idx;
                    if (this.pocketVillagers$suggestions == null || this.pocketVillagers$suggestions.isEmpty()) break block13;
                    int pad = 4;
                    Objects.requireNonNull(this.field_22793);
                    int lineH = 9 + 2;
                    int sx = this.pocketVillagers$targetInput.method_46426();
                    int inputH = this.pocketVillagers$targetInput.method_25364();
                    int syBelow = this.pocketVillagers$targetInput.method_46427() + inputH + 2;
                    int boxW = Math.max(this.pocketVillagers$targetInput.method_25368(), 140);
                    int boxH = this.pocketVillagers$suggestions.size() * lineH + pad * 2;
                    int sy = syBelow;
                    int hitPad = 2;
                    if (!(mouseX >= (double)(sx - hitPad)) || !(mouseX <= (double)(sx + boxW + hitPad)) || !(mouseY >= (double)(sy - hitPad)) || !(mouseY <= (double)(sy + boxH + hitPad)) || (idx = (relY = (int)mouseY - (sy + pad)) / lineH) < 0 || idx >= this.pocketVillagers$suggestions.size()) break block13;
                    String pick = this.pocketVillagers$suggestions.get(idx);
                    try {
                        if (this.pocketVillagers$targetInput != null) {
                            this.pocketVillagers$targetInput.method_1852(pick);
                        }
                        this.pocketVillagers$lastSuggestionPrefix = pick;
                        this.pocketVillagers$suggestions.clear();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    cir.setReturnValue((Object)true);
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

