/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.network;

import java.lang.reflect.Method;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.entity.BreederPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.ConverterPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.FarmingPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.FishingPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.IronFarmPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.MiningPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.StoragePocketCubeBlockEntity;
import net.mcreator.pocketvillagers.network.ClearIronFarmPreviewPayload;
import net.mcreator.pocketvillagers.network.SyncBreederMenuPayload;
import net.mcreator.pocketvillagers.util.VillagerDataHandler;
import net.mcreator.pocketvillagers.world.inventory.BreederPocketCubeGUIMenu;
import net.mcreator.pocketvillagers.world.inventory.IronFarmPocketCubeGUIMenu;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public record ReleaseStorageVillagerPacket(class_2338 pos, int villagerIndex) implements class_8710
{
    public static final class_8710.class_9154<ReleaseStorageVillagerPacket> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"pocket_villagers", (String)"release_storage_villager"));
    public static final class_2960 ID = class_2960.method_60655((String)"pocket_villagers", (String)"release_storage_villager");
    public static final class_9139<class_2540, ReleaseStorageVillagerPacket> CODEC = new class_9139<class_2540, ReleaseStorageVillagerPacket>(){

        public ReleaseStorageVillagerPacket decode(class_2540 buf) {
            class_2338 pos = (class_2338)class_2338.field_48404.decode((Object)buf);
            int villagerIndex = buf.readInt();
            return new ReleaseStorageVillagerPacket(pos, villagerIndex);
        }

        public void encode(class_2540 buf, ReleaseStorageVillagerPacket packet) {
            class_2338.field_48404.encode((Object)buf, (Object)packet.pos);
            buf.method_53002(packet.villagerIndex);
        }
    };

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver(TYPE, (packet, context) -> {
            class_3222 player = context.player();
            class_2338 pos = packet.pos();
            int villagerIndex = packet.villagerIndex();
            context.server().execute(() -> ReleaseStorageVillagerPacket.performRelease(player, pos, villagerIndex));
        });
    }

    private static void performRelease(class_3222 player, class_2338 pos, int villagerIndex) {
        block153: {
            try {
                PocketVillagersMod.LOGGER.debug("ReleaseStorageVillagerPacket: Received from {} at {} for villager index {}", (Object)(player == null ? "<null>" : player.method_5477().getString()), (Object)pos, (Object)villagerIndex);
                if (player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) > 64.0) {
                    return;
                }
                class_2586 blockEntity = player.method_51469().method_8321(pos);
                if (blockEntity instanceof ConverterPocketCubeBlockEntity) {
                    ConverterPocketCubeBlockEntity converter;
                    block147: {
                        block146: {
                            converter = (ConverterPocketCubeBlockEntity)blockEntity;
                            try {
                                ConverterPocketCubeBlockEntity.ConversionStage stage = converter.getConversionStage();
                                if (stage != ConverterPocketCubeBlockEntity.ConversionStage.CURING) break block146;
                                try {
                                    player.method_7353((class_2561)class_2561.method_43470((String)"Cannot release while curing in progress"), true);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: Attempted release during CURING at {}", (Object)pos);
                                return;
                            }
                            catch (Throwable stage) {
                                // empty catch block
                            }
                        }
                        if (!converter.hasVillager()) {
                            PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: No villager present in converter at {}", (Object)pos);
                            return;
                        }
                        class_2487 villagerData = converter.getVillagerData();
                        if (villagerData == null || villagerData.method_33133()) {
                            PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: Empty villager data for converter");
                            return;
                        }
                        class_2487 releaseData = villagerData.method_10553();
                        class_1646 spawned = VillagerDataHandler.spawnVillagerFromData((class_1937)player.method_51469(), pos.method_10084(), releaseData, (class_1657)player);
                        try {
                            VillagerDataHandler.restoreEntityBehavior((class_1297)spawned);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            VillagerDataHandler.restoreEntityBehavior((class_1297)spawned);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            if (spawned == null) break block147;
                            boolean hasOffers = releaseData.method_10545("Offers");
                            if (!hasOffers) {
                                try {
                                    Method updateTradesMethod = class_1646.class.getDeclaredMethod("m_35463_", new Class[0]);
                                    updateTradesMethod.setAccessible(true);
                                    updateTradesMethod.invoke((Object)spawned, new Object[0]);
                                    PocketVillagersMod.LOGGER.debug("ReleaseStorageVillagerPacket: Generated fresh offers for converter villager");
                                }
                                catch (NoSuchMethodException nsm) {
                                    try {
                                        Method updateTradesMethod = class_1646.class.getDeclaredMethod("updateTrades", new Class[0]);
                                        updateTradesMethod.setAccessible(true);
                                        updateTradesMethod.invoke((Object)spawned, new Object[0]);
                                        break block147;
                                    }
                                    catch (Throwable e2) {
                                        PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: Could not call updateTrades for converter villager: {}", (Object)e2.getMessage());
                                    }
                                }
                                break block147;
                            }
                            PocketVillagersMod.LOGGER.debug("ReleaseStorageVillagerPacket: Preserved saved offers for converter villager");
                        }
                        catch (Throwable hasOffers) {
                            // empty catch block
                        }
                    }
                    converter.setVillagerData(new class_2487());
                    try {
                        converter.method_5431();
                    }
                    catch (Throwable hasOffers) {
                        // empty catch block
                    }
                    try {
                        player.method_51469().method_8413(pos, player.method_51469().method_8320(pos), player.method_51469().method_8320(pos), 3);
                    }
                    catch (Throwable hasOffers) {
                        // empty catch block
                    }
                    player.method_7346();
                    return;
                }
                if (blockEntity instanceof StoragePocketCubeBlockEntity) {
                    StoragePocketCubeBlockEntity cubeEntity;
                    block148: {
                        cubeEntity = (StoragePocketCubeBlockEntity)blockEntity;
                        if (villagerIndex < 0 || villagerIndex >= cubeEntity.getVillagerCount()) {
                            PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: Invalid villager index {} for cube with {} villagers", (Object)villagerIndex, (Object)cubeEntity.getVillagerCount());
                            return;
                        }
                        class_2487 villagerData = cubeEntity.getVillager(villagerIndex);
                        if (villagerData == null) {
                            PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: No villager data at index {}", (Object)villagerIndex);
                            return;
                        }
                        try {
                            String prof = villagerData.method_10545("VillagerData.profession") ? villagerData.method_10558("VillagerData.profession").orElse("unknown") : "no_data";
                            int xp = villagerData.method_10545("Xp") ? villagerData.method_10550("Xp").orElse(0) : 0;
                            int lvl = villagerData.method_10545("VillagerData.level") ? villagerData.method_10550("VillagerData.level").orElse(1) : 1;
                            PocketVillagersMod.LOGGER.debug("=== RELEASING VILLAGER FROM STORAGE ===");
                            PocketVillagersMod.LOGGER.debug("Index={} profession={} level={} xp={}", (Object)villagerIndex, (Object)prof, (Object)lvl, (Object)xp);
                            PocketVillagersMod.LOGGER.debug("=== END RELEASE INFO ===");
                        }
                        catch (Throwable prof) {
                            // empty catch block
                        }
                        class_2487 releaseData = villagerData.method_10553();
                        try {
                            class_2487 stored;
                            if (!releaseData.method_10545("VillagerData.type") && cubeEntity != null && (stored = cubeEntity.getVillager(villagerIndex)) != null && stored.method_10545("VillagerData.type")) {
                                releaseData.method_10582("VillagerData.type", stored.method_10558("VillagerData.type").orElse("minecraft:plains"));
                                PocketVillagersMod.LOGGER.debug("ReleaseStorageVillagerPacket: Recovered VillagerData.type from storage cube stored data for index {}", (Object)villagerIndex);
                            }
                        }
                        catch (Throwable stored) {
                            // empty catch block
                        }
                        try {
                            String type = releaseData.method_10545("VillagerData.type") ? releaseData.method_10558("VillagerData.type").orElse("<none>") : "<none>";
                            String prof = releaseData.method_10545("VillagerData.profession") ? releaseData.method_10558("VillagerData.profession").orElse("<none>") : "<none>";
                            PocketVillagersMod.LOGGER.debug("ReleaseStorageVillagerPacket: releaseData type={} profession={} fullTag={}", (Object)type, (Object)prof, (Object)releaseData.toString());
                        }
                        catch (Throwable type) {
                            // empty catch block
                        }
                        class_1646 spawned = VillagerDataHandler.spawnVillagerFromData((class_1937)player.method_51469(), pos.method_10084(), releaseData, (class_1657)player);
                        try {
                            VillagerDataHandler.restoreEntityBehavior((class_1297)spawned);
                        }
                        catch (Throwable prof) {
                            // empty catch block
                        }
                        try {
                            VillagerDataHandler.restoreEntityBehavior((class_1297)spawned);
                        }
                        catch (Throwable prof) {
                            // empty catch block
                        }
                        try {
                            if (spawned == null) break block148;
                            boolean hasOffers = releaseData.method_10545("Offers");
                            if (!hasOffers) {
                                try {
                                    Method updateTradesMethod = class_1646.class.getDeclaredMethod("m_35463_", new Class[0]);
                                    updateTradesMethod.setAccessible(true);
                                    updateTradesMethod.invoke((Object)spawned, new Object[0]);
                                    PocketVillagersMod.LOGGER.debug("ReleaseStorageVillagerPacket: Generated fresh offers");
                                }
                                catch (NoSuchMethodException nsm) {
                                    try {
                                        Method updateTradesMethod = class_1646.class.getDeclaredMethod("updateTrades", new Class[0]);
                                        updateTradesMethod.setAccessible(true);
                                        updateTradesMethod.invoke((Object)spawned, new Object[0]);
                                        break block148;
                                    }
                                    catch (Throwable e2) {
                                        PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: Could not call updateTrades: {}", (Object)e2.getMessage());
                                    }
                                }
                                break block148;
                            }
                            PocketVillagersMod.LOGGER.debug("ReleaseStorageVillagerPacket: Preserved saved offers");
                        }
                        catch (Throwable hasOffers) {
                            // empty catch block
                        }
                    }
                    cubeEntity.removeVillager(villagerIndex);
                    try {
                        cubeEntity.method_5431();
                    }
                    catch (Throwable hasOffers) {
                        // empty catch block
                    }
                    try {
                        player.method_51469().method_8413(pos, player.method_51469().method_8320(pos), player.method_51469().method_8320(pos), 3);
                    }
                    catch (Throwable hasOffers) {
                        // empty catch block
                    }
                    player.method_7346();
                    return;
                }
                if (blockEntity instanceof IronFarmPocketCubeBlockEntity) {
                    block150: {
                        IronFarmPocketCubeBlockEntity ironFarm;
                        block149: {
                            ironFarm = (IronFarmPocketCubeBlockEntity)blockEntity;
                            if (villagerIndex < 1 || villagerIndex > 3) {
                                PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: Invalid villager index {} for iron farm", (Object)villagerIndex);
                                return;
                            }
                            if (!ironFarm.hasVillager(villagerIndex)) {
                                PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: No villager present at iron farm index {}", (Object)villagerIndex);
                                return;
                            }
                            class_2487 villagerData = ironFarm.getVillagerData(villagerIndex);
                            if (villagerData == null || villagerData.method_33133()) {
                                PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: Empty villager data at iron farm index {}", (Object)villagerIndex);
                                return;
                            }
                            class_2487 releaseData = villagerData.method_10553();
                            class_1646 spawned = VillagerDataHandler.spawnVillagerFromData((class_1937)player.method_51469(), pos.method_10084(), releaseData, (class_1657)player);
                            try {
                                VillagerDataHandler.restoreEntityBehavior((class_1297)spawned);
                            }
                            catch (Throwable hasOffers) {
                                // empty catch block
                            }
                            try {
                                if (spawned == null) break block149;
                                boolean hasOffers = releaseData.method_10545("Offers");
                                if (!hasOffers) {
                                    try {
                                        Method updateTradesMethod = class_1646.class.getDeclaredMethod("m_35463_", new Class[0]);
                                        updateTradesMethod.setAccessible(true);
                                        updateTradesMethod.invoke((Object)spawned, new Object[0]);
                                        PocketVillagersMod.LOGGER.debug("ReleaseStorageVillagerPacket: Generated fresh offers for iron farm villager");
                                    }
                                    catch (NoSuchMethodException nsm) {
                                        try {
                                            Method updateTradesMethod = class_1646.class.getDeclaredMethod("updateTrades", new Class[0]);
                                            updateTradesMethod.setAccessible(true);
                                            updateTradesMethod.invoke((Object)spawned, new Object[0]);
                                            break block149;
                                        }
                                        catch (Throwable e2) {
                                            PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: Could not call updateTrades for iron farm villager: {}", (Object)e2.getMessage());
                                        }
                                    }
                                    break block149;
                                }
                                PocketVillagersMod.LOGGER.debug("ReleaseStorageVillagerPacket: Preserved saved offers for iron farm villager");
                            }
                            catch (Throwable hasOffers) {
                                // empty catch block
                            }
                        }
                        ironFarm.setVillagerData(villagerIndex, new class_2487());
                        try {
                            ironFarm.method_5431();
                        }
                        catch (Throwable hasOffers) {
                            // empty catch block
                        }
                        try {
                            ironFarm.sendMenuStateUpdateToViewers();
                        }
                        catch (Throwable hasOffers) {
                            // empty catch block
                        }
                        try {
                            player.method_51469().method_8413(pos, player.method_51469().method_8320(pos), player.method_51469().method_8320(pos), 3);
                        }
                        catch (Throwable hasOffers) {
                            // empty catch block
                        }
                        try {
                            class_3218 nsm = player.method_51469();
                            if (!(nsm instanceof class_3218)) break block150;
                            class_3218 serverLevel = nsm;
                            int mask = 0;
                            try {
                                if (ironFarm.hasVillager(1)) {
                                    mask |= 1;
                                }
                            }
                            catch (Throwable e2) {
                                // empty catch block
                            }
                            try {
                                if (ironFarm.hasVillager(2)) {
                                    mask |= 2;
                                }
                            }
                            catch (Throwable e2) {
                                // empty catch block
                            }
                            try {
                                if (ironFarm.hasVillager(3)) {
                                    mask |= 4;
                                }
                            }
                            catch (Throwable e2) {
                                // empty catch block
                            }
                            if (mask == 0) {
                                for (class_3222 p : serverLevel.method_8503().method_3760().method_14571()) {
                                    try {
                                        if (p.method_51469() != serverLevel || !(p.field_7512 instanceof IronFarmPocketCubeGUIMenu)) continue;
                                        IronFarmPocketCubeGUIMenu menu = (IronFarmPocketCubeGUIMenu)p.field_7512;
                                        if (menu.x != pos.method_10263() || menu.y != pos.method_10264() || menu.z != pos.method_10260()) continue;
                                        try {
                                            ClearIronFarmPreviewPayload.send(p, pos);
                                        }
                                        catch (Throwable throwable) {
                                        }
                                    }
                                    catch (Throwable menu) {}
                                }
                            }
                        }
                        catch (Throwable serverLevel) {
                            // empty catch block
                        }
                    }
                    player.method_7346();
                    return;
                }
                if (blockEntity instanceof BreederPocketCubeBlockEntity) {
                    block152: {
                        BreederPocketCubeBlockEntity breeder;
                        block151: {
                            breeder = (BreederPocketCubeBlockEntity)blockEntity;
                            if (villagerIndex >= 100 && villagerIndex <= 102) {
                                int babyIdx = villagerIndex - 100;
                                if (!breeder.hasBaby(babyIdx) || breeder.getBabyGrowthPercent(babyIdx) < 100) {
                                    PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: Baby at index {} not present or not fully grown", (Object)babyIdx);
                                    return;
                                }
                                boolean ok = breeder.releaseGrownBabyToWorld((class_1937)player.method_51469(), pos.method_10084(), babyIdx);
                                if (ok) {
                                    try {
                                        breeder.method_5431();
                                    }
                                    catch (Throwable spawned) {
                                        // empty catch block
                                    }
                                    try {
                                        player.method_51469().method_8413(pos, player.method_51469().method_8320(pos), player.method_51469().method_8320(pos), 3);
                                    }
                                    catch (Throwable spawned) {
                                        // empty catch block
                                    }
                                    player.method_7346();
                                } else {
                                    PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: Failed to release baby at index {}", (Object)babyIdx);
                                }
                                return;
                            }
                            if (villagerIndex != 1 && villagerIndex != 2) {
                                PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: Invalid villager index {} for breeder", (Object)villagerIndex);
                                return;
                            }
                            if (!breeder.hasVillager(villagerIndex)) {
                                PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: No villager present at breeder index {}", (Object)villagerIndex);
                                return;
                            }
                            class_2487 villagerData = breeder.getVillagerData(villagerIndex);
                            if (villagerData == null || villagerData.method_33133()) {
                                PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: Empty villager data at breeder index {}", (Object)villagerIndex);
                                return;
                            }
                            class_2487 releaseData = villagerData.method_10553();
                            class_1646 spawned = VillagerDataHandler.spawnVillagerFromData((class_1937)player.method_51469(), pos.method_10084(), releaseData, (class_1657)player);
                            try {
                                VillagerDataHandler.restoreEntityBehavior((class_1297)spawned);
                            }
                            catch (Throwable serverLevel) {
                                // empty catch block
                            }
                            try {
                                if (spawned == null) break block151;
                                boolean hasOffers = releaseData.method_10545("Offers");
                                if (!hasOffers) {
                                    try {
                                        Method updateTradesMethod = class_1646.class.getDeclaredMethod("m_35463_", new Class[0]);
                                        updateTradesMethod.setAccessible(true);
                                        updateTradesMethod.invoke((Object)spawned, new Object[0]);
                                        PocketVillagersMod.LOGGER.debug("ReleaseStorageVillagerPacket: Generated fresh offers for breeder villager");
                                    }
                                    catch (NoSuchMethodException nsm) {
                                        try {
                                            Method updateTradesMethod = class_1646.class.getDeclaredMethod("updateTrades", new Class[0]);
                                            updateTradesMethod.setAccessible(true);
                                            updateTradesMethod.invoke((Object)spawned, new Object[0]);
                                            break block151;
                                        }
                                        catch (Throwable e2) {
                                            PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: Could not call updateTrades for breeder villager: {}", (Object)e2.getMessage());
                                        }
                                    }
                                    break block151;
                                }
                                PocketVillagersMod.LOGGER.debug("ReleaseStorageVillagerPacket: Preserved saved offers for breeder villager");
                            }
                            catch (Throwable hasOffers) {
                                // empty catch block
                            }
                        }
                        breeder.setVillagerData(villagerIndex, new class_2487());
                        try {
                            breeder.method_5431();
                        }
                        catch (Throwable hasOffers) {
                            // empty catch block
                        }
                        try {
                            player.method_51469().method_8413(pos, player.method_51469().method_8320(pos), player.method_51469().method_8320(pos), 3);
                        }
                        catch (Throwable hasOffers) {
                            // empty catch block
                        }
                        try {
                            class_3218 nsm = player.method_51469();
                            if (!(nsm instanceof class_3218)) break block152;
                            class_3218 serverLevel = nsm;
                            int fp = 0;
                            int bedCount = 0;
                            try {
                                bedCount = breeder.getBedCount();
                            }
                            catch (Throwable p) {
                                // empty catch block
                            }
                            int bt = 0;
                            try {
                                bt = breeder.getBreedTimer();
                            }
                            catch (Throwable menu) {
                                // empty catch block
                            }
                            int bi = 0;
                            try {
                                bi = breeder.getBreedIntervalTicks();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            for (class_3222 p : serverLevel.method_8503().method_3760().method_14571()) {
                                try {
                                    if (p.method_51469() != serverLevel || !(p.field_7512 instanceof BreederPocketCubeGUIMenu)) continue;
                                    BreederPocketCubeGUIMenu menu = (BreederPocketCubeGUIMenu)p.field_7512;
                                    if (menu.x != pos.method_10263() || menu.y != pos.method_10264() || menu.z != pos.method_10260()) continue;
                                    try {
                                        int remaining = Math.max(0, bi - bt);
                                        SyncBreederMenuPayload.send(p, pos, fp, bedCount, remaining, bi, breeder.hasVillager(1), breeder.hasVillager(2), breeder.hasBaby(0), breeder.hasBaby(1), breeder.hasBaby(2), breeder.getBabyGrowthPercent(0), breeder.getBabyGrowthPercent(1), breeder.getBabyGrowthPercent(2));
                                    }
                                    catch (Throwable throwable) {
                                    }
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    player.method_7346();
                    break block153;
                }
                if (blockEntity instanceof MiningPocketCubeBlockEntity) {
                    MiningPocketCubeBlockEntity miningCube = (MiningPocketCubeBlockEntity)blockEntity;
                    if (!miningCube.hasVillager()) {
                        PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: No villager in mining cube at {}", (Object)pos);
                        return;
                    }
                    class_2487 villagerData = miningCube.getVillagerData();
                    if (villagerData == null || villagerData.method_33133()) {
                        PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: Empty villager data in mining cube");
                        return;
                    }
                    class_2487 releaseData = villagerData.method_10553();
                    class_1646 spawned = VillagerDataHandler.spawnVillagerFromData((class_1937)player.method_51469(), pos.method_10084(), releaseData, (class_1657)player);
                    try {
                        VillagerDataHandler.restoreEntityBehavior((class_1297)spawned);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    miningCube.setVillagerData(new class_2487());
                    try {
                        miningCube.method_5431();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        player.method_51469().method_8413(pos, player.method_51469().method_8320(pos), player.method_51469().method_8320(pos), 3);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    player.method_7346();
                    break block153;
                }
                if (blockEntity instanceof FarmingPocketCubeBlockEntity) {
                    FarmingPocketCubeBlockEntity farmingCube = (FarmingPocketCubeBlockEntity)blockEntity;
                    if (!farmingCube.hasVillager()) {
                        PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: No villager in farming cube at {}", (Object)pos);
                        return;
                    }
                    class_2487 villagerData = farmingCube.getVillagerData();
                    if (villagerData == null || villagerData.method_33133()) {
                        PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: Empty villager data in farming cube");
                        return;
                    }
                    class_2487 releaseData = villagerData.method_10553();
                    class_1646 spawned = VillagerDataHandler.spawnVillagerFromData((class_1937)player.method_51469(), pos.method_10084(), releaseData, (class_1657)player);
                    farmingCube.setVillagerData(new class_2487());
                    try {
                        farmingCube.method_5431();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        player.method_51469().method_8413(pos, player.method_51469().method_8320(pos), player.method_51469().method_8320(pos), 3);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    player.method_7346();
                    break block153;
                }
                if (!(blockEntity instanceof FishingPocketCubeBlockEntity)) break block153;
                FishingPocketCubeBlockEntity fishingCube = (FishingPocketCubeBlockEntity)blockEntity;
                if (!fishingCube.hasVillager()) {
                    PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: No villager in fishing cube at {}", (Object)pos);
                    return;
                }
                class_2487 villagerData = fishingCube.getVillagerData();
                if (villagerData == null || villagerData.method_33133()) {
                    PocketVillagersMod.LOGGER.warn("ReleaseStorageVillagerPacket: Empty villager data in fishing cube");
                    return;
                }
                class_2487 releaseData = villagerData.method_10553();
                class_1646 spawned = VillagerDataHandler.spawnVillagerFromData((class_1937)player.method_51469(), pos.method_10084(), releaseData, (class_1657)player);
                fishingCube.setVillagerData(new class_2487());
                try {
                    fishingCube.method_5431();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    player.method_51469().method_8413(pos, player.method_51469().method_8320(pos), player.method_51469().method_8320(pos), 3);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                player.method_7346();
            }
            catch (Throwable e) {
                PocketVillagersMod.LOGGER.error("ReleaseStorageVillagerPacket: Error releasing villager", e);
            }
        }
    }
}

