/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.util;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.entity.PocketCubeBlockEntity;
import net.mcreator.pocketvillagers.entity.CubeVillager;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3850;
import net.minecraft.class_3853;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class VillagerDataHandler {
    private static final String VILLAGER_DATA_KEY = "VillagerData";
    private static final String HAS_VILLAGER_KEY = "HasVillager";

    private static class_1916 generateBaseOffers(class_1937 level, class_2487 villagerData) {
        return VillagerDataHandler.generateBaseOffers(level, villagerData, -1);
    }

    private static class_1916 generateBaseOffers(class_1937 level, class_2487 villagerData, int desiredCount) {
        String professionStr2;
        class_1646 temp;
        class_1916 empty;
        block69: {
            empty = new class_1916();
            if (level == null || level.method_8608() || villagerData == null) {
                return empty;
            }
            temp = new class_1646(class_1299.field_6077, level);
            try {
                temp.method_5814(0.0, 64.0, 0.0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (villagerData.method_10545("VillagerData.profession")) {
                    professionStr2 = villagerData.method_10558("VillagerData.profession").orElse("minecraft:none");
                    String typeStr = villagerData.method_10558("VillagerData.type").orElse("minecraft:plains");
                    int villagerLevel = villagerData.method_10550("VillagerData.level").orElse(1);
                    class_2960 professionLocation = class_2960.method_60654((String)professionStr2);
                    class_2960 typeLocation = class_2960.method_60654((String)typeStr);
                    Optional professionOpt = class_7923.field_41195.method_10223(professionLocation);
                    Optional typeOpt = class_7923.field_41194.method_10223(typeLocation);
                    if (professionOpt.isPresent() && typeOpt.isPresent()) {
                        temp.method_7195(temp.method_7231().method_16921((class_6880)professionOpt.get()).method_16922((class_6880)typeOpt.get()).method_16920(villagerLevel));
                    }
                }
            }
            catch (Throwable professionStr2) {
                // empty catch block
            }
            try {
                temp.method_19625(villagerData.method_10550("Xp").orElse(0).intValue());
            }
            catch (Throwable professionStr2) {
                // empty catch block
            }
            try {
                temp.method_16917(new class_1916());
            }
            catch (Throwable professionStr2) {
                // empty catch block
            }
            try {
                int desired;
                Method m = class_1646.class.getDeclaredMethod("updateTrades", new Class[0]);
                m.setAccessible(true);
                m.invoke((Object)temp, new Object[0]);
                class_1916 generated = temp.method_8264();
                int n = desired = desiredCount > 0 ? desiredCount : Math.max(2, 2 + 2 * (temp.method_7231().comp_3522() - 1));
                if (generated == null) {
                    generated = new class_1916();
                }
                try {
                    int extraAttempts = 4;
                    for (int a = 0; a < extraAttempts && generated.size() < desired; ++a) {
                        try {
                            m.invoke((Object)temp, new Object[0]);
                            class_1916 now = temp.method_8264();
                            if (now == null || now.isEmpty()) continue;
                            for (int oi = 0; oi < now.size(); ++oi) {
                                try {
                                    class_1914 o = (class_1914)now.get(oi);
                                    boolean exists = false;
                                    for (int ej = 0; ej < generated.size(); ++ej) {
                                        try {
                                            if (!((class_1914)generated.get(ej)).toString().equals(o.toString())) continue;
                                            exists = true;
                                            break;
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                    }
                                    if (exists) continue;
                                    generated.add((Object)o);
                                    continue;
                                }
                                catch (Throwable o) {
                                    // empty catch block
                                }
                            }
                            continue;
                        }
                        catch (Throwable now) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (generated == null || generated.isEmpty()) break block69;
                try {
                    PocketVillagersMod.LOGGER.debug("[generateBaseOffers] Generated {} offers for profession: {}", (Object)generated.size(), (Object)((class_5321)temp.method_7231().comp_3521().method_40230().orElseThrow()).method_29177());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return generated;
            }
            catch (Throwable reflectFail) {
                try {
                    PocketVillagersMod.LOGGER.warn("[generateBaseOffers] reflection updateTrades() failed: {}", (Object)reflectFail.toString());
                }
                catch (Throwable generated) {
                    // empty catch block
                }
            }
        }
        try {
            professionStr2 = villagerData.method_10558("VillagerData.profession").orElse("minecraft:none");
            int villagerLevel = villagerData.method_10550("VillagerData.level").orElse(1);
            if (professionStr2 == null || "minecraft:none".equals(professionStr2) || professionStr2.isEmpty()) {
                return empty;
            }
            class_2960 professionLocation = class_2960.method_60654((String)professionStr2);
            for (Map.Entry entry : class_3853.field_17067.entrySet()) {
                try {
                    int i;
                    class_5321 key = (class_5321)entry.getKey();
                    if (key == null || key.method_29177() == null || !key.method_29177().equals((Object)professionLocation)) continue;
                    Int2ObjectMap levelMap = (Int2ObjectMap)entry.getValue();
                    ArrayList<class_3853.class_1652> combined = new ArrayList<class_3853.class_1652>();
                    for (int lv = 1; lv <= villagerLevel; ++lv) {
                        try {
                            class_3853.class_1652[] arr = (class_3853.class_1652[])levelMap.get(lv);
                            if (arr == null || arr.length <= 0) continue;
                            for (int ai = 0; ai < arr.length; ++ai) {
                                combined.add(arr[ai]);
                            }
                            continue;
                        }
                        catch (Throwable arr) {
                            // empty catch block
                        }
                    }
                    if (combined.isEmpty()) {
                        return empty;
                    }
                    class_5819 random = level != null ? level.method_8409() : class_5819.method_43047();
                    class_1916 offers = new class_1916();
                    int desired = 2;
                    try {
                        desired = Math.max(2, 2 + 2 * (villagerLevel - 1));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    int toGenerate = Math.min(combined.size(), Math.min(desired, 10));
                    ArrayList<Integer> indices = new ArrayList<Integer>();
                    for (i = 0; i < combined.size(); ++i) {
                        indices.add(i);
                    }
                    for (i = 0; i < toGenerate && !indices.isEmpty(); ++i) {
                        try {
                            int pickIndex = (Integer)indices.remove(random.method_43048(indices.size()));
                            Object factory = combined.get(pickIndex);
                            try {
                                Method m = factory.getClass().getMethod("getOffer", class_1646.class, class_5819.class);
                                Object offerObj = m.invoke(factory, temp, random);
                                if (!(offerObj instanceof class_1914)) continue;
                                class_1914 mo = (class_1914)offerObj;
                                offers.add((Object)mo);
                            }
                            catch (NoSuchMethodException nsme) {
                                try {
                                    class_3853.class_1652 f = (class_3853.class_1652)factory;
                                    class_1914 offer = f.method_7246((class_1297)temp, random);
                                    if (offer == null) continue;
                                    offers.add((Object)offer);
                                }
                                catch (Throwable f) {
                                }
                            }
                            catch (Throwable nsme) {}
                            continue;
                        }
                        catch (Throwable pickIndex) {
                            // empty catch block
                        }
                    }
                    if (offers.size() < desired && !combined.isEmpty()) {
                        int need = desired - offers.size();
                        int attempts = Math.max(need * 3, 8);
                        for (int a = 0; a < attempts && offers.size() < desired; ++a) {
                            try {
                                int pick = random.method_43048(combined.size());
                                Object factory = combined.get(pick);
                                try {
                                    Method m = factory.getClass().getMethod("getOffer", class_1646.class, class_5819.class);
                                    Object offerObj = m.invoke(factory, temp, random);
                                    if (!(offerObj instanceof class_1914)) continue;
                                    class_1914 mo = (class_1914)offerObj;
                                    offers.add((Object)mo);
                                }
                                catch (NoSuchMethodException nsme) {
                                    try {
                                        class_3853.class_1652 f = (class_3853.class_1652)factory;
                                        class_1914 offer = f.method_7246((class_1297)temp, random);
                                        if (offer == null) continue;
                                        offers.add((Object)offer);
                                    }
                                    catch (Throwable throwable) {
                                    }
                                }
                                catch (Throwable throwable) {}
                                continue;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    try {
                        PocketVillagersMod.LOGGER.debug("[generateBaseOffers] Fallback generated {} offers for profession: {} (desired={})", (Object)offers.size(), (Object)professionStr2, (Object)desired);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return offers;
                }
                catch (Throwable throwable) {
                }
            }
            return empty;
        }
        catch (Throwable fallbackFail) {
            try {
                try {
                    PocketVillagersMod.LOGGER.error("[generateBaseOffers] fallback generation failed", fallbackFail);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return empty;
            }
            catch (Throwable t) {
                try {
                    PocketVillagersMod.LOGGER.error("[generateBaseOffers] unexpected failure", t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return empty;
            }
        }
    }

    public static class_1916 generateOffers(class_1937 level, class_2487 villagerData) {
        return VillagerDataHandler.generateBaseOffers(level, villagerData);
    }

    public static void storeVillagerInItem(class_1799 stack, class_1646 villager, class_1937 level) {
        class_9279 customData = (class_9279)stack.method_58694(class_9334.field_49628);
        class_2487 tag = customData != null ? customData.method_57461() : new class_2487();
        class_2487 villagerData = new class_2487();
        villagerData.method_10582("id", "minecraft:villager");
        class_3850 villagerDataObj = villager.method_7231();
        String professionStr = ((class_5321)villagerDataObj.comp_3521().method_40230().orElseThrow()).method_29177().toString();
        String typeStr = ((class_5321)villagerDataObj.comp_3520().method_40230().orElseThrow()).method_29177().toString();
        int villagerLevel = villagerDataObj.comp_3522();
        villagerData.method_10582("VillagerData.profession", professionStr);
        villagerData.method_10582("VillagerData.type", typeStr);
        villagerData.method_10569("VillagerData.level", villagerLevel);
        villagerData.method_10569("Xp", villager.method_19269());
        try {
            Set tags = villager.method_5752();
            if (tags != null) {
                for (String t : tags) {
                    if (t == null || !t.startsWith("PocketVillagers.Conversions=")) continue;
                    try {
                        int conversions = Integer.parseInt(t.substring(t.indexOf(61) + 1));
                        villagerData.method_10569("PocketVillagers.Conversions", conversions);
                        PocketVillagersMod.LOGGER.debug("storeVillagerInItem: Preserved PocketVillagers.Conversions={} from entity tag", (Object)conversions);
                    }
                    catch (Throwable conversions) {}
                    break;
                }
            }
            try {
                for (Field field : class_1646.class.getDeclaredFields()) {
                    String name;
                    if (field.getType() != Integer.TYPE || !(name = field.getName().toLowerCase()).contains("onversion") && !name.contains("time")) continue;
                    field.setAccessible(true);
                    int value = field.getInt(villager);
                    if (value <= 0) continue;
                    villagerData.method_10569("ConversionTime", value);
                    PocketVillagersMod.LOGGER.debug("storeVillagerInItem: Preserved ConversionTime={} from field {}", (Object)value, (Object)field.getName());
                    break;
                }
            }
            catch (Throwable throwable) {
            }
        }
        catch (Throwable t) {
            PocketVillagersMod.LOGGER.warn("storeVillagerInItem: Failed to preserve conversion data: {}", (Object)t.getMessage());
        }
        class_1916 offers = villager.method_8264();
        if (offers != null && !offers.isEmpty()) {
            try {
                class_1916 sanitized = new class_1916();
                for (int i = 0; i < offers.size(); ++i) {
                    try {
                        class_1914 o = (class_1914)offers.get(i);
                        if (o == null) continue;
                        try {
                            Field usesField = class_1914.class.getDeclaredField("uses");
                            usesField.setAccessible(true);
                            usesField.setInt(o, 0);
                            Field maxUsesField = class_1914.class.getDeclaredField("maxUses");
                            maxUsesField.setAccessible(true);
                            maxUsesField.setInt(o, Integer.MAX_VALUE);
                        }
                        catch (Throwable usesField) {
                            // empty catch block
                        }
                        sanitized.add((Object)o);
                        continue;
                    }
                    catch (Throwable o) {
                        // empty catch block
                    }
                }
                class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)level.method_30349());
                DataResult result = class_1916.field_48850.encodeStart((DynamicOps)registryOps, (Object)sanitized);
                if (result.result().isPresent()) {
                    class_2520 encodedTag = (class_2520)result.result().get();
                    villagerData.method_10566("Offers", encodedTag);
                    try {
                        PocketVillagersMod.LOGGER.debug("storeVillagerInItem: encoded {} offers for villager (item)", (Object)sanitized.size());
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            tag.method_10551("WorkstationItemId");
            tag.method_10551("WorkstationCount");
            tag.method_10551("FacingYaw");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        tag.method_10566(VILLAGER_DATA_KEY, (class_2520)villagerData);
        tag.method_10556(HAS_VILLAGER_KEY, true);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
    }

    public static void storeVillagerInBlockEntity(class_2487 blockEntityTag, class_1646 villager, class_1937 level) {
        if (villager != null) {
            class_2487 villagerData = new class_2487();
            villagerData.method_10582("id", "minecraft:villager");
            class_3850 villagerDataObj = villager.method_7231();
            String professionStr = ((class_5321)villagerDataObj.comp_3521().method_40230().orElseThrow()).method_29177().toString();
            String typeStr = ((class_5321)villagerDataObj.comp_3520().method_40230().orElseThrow()).method_29177().toString();
            int villagerLevel = villagerDataObj.comp_3522();
            villagerData.method_10582("VillagerData.profession", professionStr);
            villagerData.method_10582("VillagerData.type", typeStr);
            villagerData.method_10569("VillagerData.level", villagerLevel);
            villagerData.method_10569("Xp", villager.method_19269());
            try {
                Set tags = villager.method_5752();
                if (tags != null) {
                    for (String t : tags) {
                        if (t == null || !t.startsWith("PocketVillagers.Conversions=")) continue;
                        try {
                            int conversions = Integer.parseInt(t.substring(t.indexOf(61) + 1));
                            villagerData.method_10569("PocketVillagers.Conversions", conversions);
                            PocketVillagersMod.LOGGER.debug("storeVillagerInBlockEntity: Preserved PocketVillagers.Conversions={} from entity tag", (Object)conversions);
                        }
                        catch (Throwable conversions) {}
                        break;
                    }
                }
                try {
                    for (Field field : class_1646.class.getDeclaredFields()) {
                        String name;
                        if (field.getType() != Integer.TYPE || !(name = field.getName().toLowerCase()).contains("onversion") && !name.contains("time")) continue;
                        field.setAccessible(true);
                        int value = field.getInt(villager);
                        if (value <= 0) continue;
                        villagerData.method_10569("ConversionTime", value);
                        PocketVillagersMod.LOGGER.debug("storeVillagerInBlockEntity: Preserved ConversionTime={} from field {}", (Object)value, (Object)field.getName());
                        break;
                    }
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable t) {
                PocketVillagersMod.LOGGER.warn("storeVillagerInBlockEntity: Failed to preserve conversion data: {}", (Object)t.getMessage());
            }
            class_1916 offers = villager.method_8264();
            if (offers != null && !offers.isEmpty()) {
                try {
                    class_1916 sanitized = new class_1916();
                    for (int i = 0; i < offers.size(); ++i) {
                        try {
                            class_1914 o = (class_1914)offers.get(i);
                            if (o == null) continue;
                            try {
                                Field usesField = class_1914.class.getDeclaredField("uses");
                                usesField.setAccessible(true);
                                usesField.setInt(o, 0);
                                Field maxUsesField = class_1914.class.getDeclaredField("maxUses");
                                maxUsesField.setAccessible(true);
                                maxUsesField.setInt(o, Integer.MAX_VALUE);
                            }
                            catch (Throwable usesField) {
                                // empty catch block
                            }
                            sanitized.add((Object)o);
                            continue;
                        }
                        catch (Throwable o) {
                            // empty catch block
                        }
                    }
                    if (level instanceof class_3218) {
                        class_3218 serverLevel = (class_3218)level;
                        class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)serverLevel.method_30349());
                        DataResult result = class_1916.field_48850.encodeStart((DynamicOps)registryOps, (Object)sanitized);
                        if (result.result().isPresent()) {
                            class_2520 encodedTag = (class_2520)result.result().get();
                            villagerData.method_10566("Offers", encodedTag);
                            try {
                                PocketVillagersMod.LOGGER.debug("storeVillagerInBlockEntity: encoded {} offers using server registry ops", (Object)sanitized.size());
                            }
                            catch (Throwable throwable) {}
                        }
                    } else {
                        DataResult result = class_1916.field_48850.encodeStart((DynamicOps)class_2509.field_11560, (Object)sanitized);
                        if (result.result().isPresent()) {
                            class_2520 encodedTag = (class_2520)result.result().get();
                            villagerData.method_10566("Offers", encodedTag);
                            try {
                                PocketVillagersMod.LOGGER.debug("storeVillagerInBlockEntity: encoded {} offers using fallback NbtOps", (Object)sanitized.size());
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            blockEntityTag.method_10566(VILLAGER_DATA_KEY, (class_2520)villagerData);
            blockEntityTag.method_10556(HAS_VILLAGER_KEY, true);
        }
    }

    public static boolean hasVillager(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_58694(class_9334.field_49628);
        if (customData != null) {
            class_2487 tag = customData.method_57461();
            return tag.method_10577(HAS_VILLAGER_KEY).orElse(false) != false || tag.method_10545("Villager0");
        }
        return false;
    }

    public static boolean hasVillager(class_2487 blockEntityTag) {
        return blockEntityTag.method_10577(HAS_VILLAGER_KEY).orElse(false);
    }

    public static class_2487 getVillagerData(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_58694(class_9334.field_49628);
        if (customData != null) {
            class_2487 tag = customData.method_57461();
            Optional data = tag.method_10562(VILLAGER_DATA_KEY);
            if (data.isPresent()) {
                class_2487 out = (class_2487)data.get();
                try {
                    if (tag.method_10577(HAS_VILLAGER_KEY).orElse(false).booleanValue()) {
                        out.method_10556("PocketVillagers.Captured", true);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return out;
            }
            if (tag.method_10545("Villager0")) {
                class_2487 out = tag.method_10562("Villager0").orElse(new class_2487());
                try {
                    out.method_10556("PocketVillagers.Captured", true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return out;
            }
            return new class_2487();
        }
        return new class_2487();
    }

    public static class_2487 getVillagerData(class_2487 blockEntityTag) {
        return blockEntityTag.method_10562(VILLAGER_DATA_KEY).orElse(new class_2487());
    }

    private static CubeVillager buildCubeVillager(class_1937 level, class_2338 pos, class_2487 villagerData) {
        return VillagerDataHandler.buildCubeVillager(level, pos, villagerData, -1);
    }

    private static CubeVillager buildCubeVillager(class_1937 level, class_2338 pos, class_2487 villagerData, int desiredCount) {
        CubeVillager cubeVillager = new CubeVillager(level);
        cubeVillager.setPocketCubePos(pos);
        cubeVillager.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        if (level != null && level.method_8608()) {
            if (villagerData != null && villagerData.method_10545("VillagerData.profession")) {
                String professionStr = villagerData.method_10558("VillagerData.profession").orElse("minecraft:none");
                String typeStr = villagerData.method_10558("VillagerData.type").orElse("minecraft:plains");
                int villagerLevel = villagerData.method_10550("VillagerData.level").orElse(1);
                class_2960 professionLocation = class_2960.method_60654((String)professionStr);
                class_2960 typeLocation = class_2960.method_60654((String)typeStr);
                Optional professionOpt = class_7923.field_41195.method_10223(professionLocation);
                Optional typeOpt = class_7923.field_41194.method_10223(typeLocation);
                if (professionOpt.isPresent() && typeOpt.isPresent()) {
                    cubeVillager.method_7195(cubeVillager.method_7231().method_16921((class_6880)professionOpt.get()).method_16922((class_6880)typeOpt.get()).method_16920(villagerLevel));
                    cubeVillager.method_19625(villagerData.method_10550("Xp").orElse(0));
                }
                cubeVillager.method_5614(villagerData.method_10550("Age").orElse(0));
            }
            return cubeVillager;
        }
        if (villagerData != null && villagerData.method_10545("VillagerData.profession")) {
            String professionStr = villagerData.method_10558("VillagerData.profession").orElse("minecraft:none");
            String typeStr = villagerData.method_10558("VillagerData.type").orElse("minecraft:plains");
            int villagerLevel = villagerData.method_10550("VillagerData.level").orElse(1);
            class_2960 professionLocation = class_2960.method_60654((String)professionStr);
            class_2960 typeLocation = class_2960.method_60654((String)typeStr);
            Optional professionOpt = class_7923.field_41195.method_10223(professionLocation);
            Optional typeOpt = class_7923.field_41194.method_10223(typeLocation);
            if (professionOpt.isPresent() && typeOpt.isPresent()) {
                cubeVillager.method_7195(cubeVillager.method_7231().method_16921((class_6880)professionOpt.get()).method_16922((class_6880)typeOpt.get()).method_16920(villagerLevel));
            }
        }
        cubeVillager.method_19625(villagerData.method_10550("Xp").orElse(0));
        cubeVillager.method_5614(villagerData.method_10550("Age").orElse(0));
        if (villagerData.method_10545("PocketVillagers.Conversions")) {
            int conversions = villagerData.method_10550("PocketVillagers.Conversions").orElse(0);
            cubeVillager.setConversionCount(conversions);
            PocketVillagersMod.LOGGER.debug("[buildCubeVillager] Set conversion count to {} for discount application", (Object)conversions);
        }
        if (villagerData.method_10545("ConversionTime")) {
            int conversionTime = villagerData.method_10550("ConversionTime").orElse(0);
            cubeVillager.setConversionTime(conversionTime);
            PocketVillagersMod.LOGGER.debug("[buildCubeVillager] Set ConversionTime to {} for cured villager", (Object)conversionTime);
        }
        PocketVillagersMod.LOGGER.debug("[buildCubeVillager] villagerData contains Offers? {}", (Object)villagerData.method_10545("Offers"));
        if (villagerData != null && villagerData.method_10545("Offers")) {
            class_2520 offersTag = villagerData.method_10580("Offers");
            PocketVillagersMod.LOGGER.debug("[buildCubeVillager] offersTag is null? {} | offersTag type: {}", (Object)(offersTag == null ? 1 : 0), (Object)(offersTag == null ? "null" : offersTag.getClass().getSimpleName()));
            if (offersTag != null) {
                class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)level.method_30349());
                DataResult result = class_1916.field_48850.parse((DynamicOps)registryOps, (Object)offersTag);
                if (result.result().isPresent()) {
                    class_1916 restored = (class_1916)result.result().get();
                    cubeVillager.method_8261(restored);
                    PocketVillagersMod.LOGGER.debug("[buildCubeVillager] Restored {} offers from NBT", (Object)restored.size());
                } else {
                    VillagerDataHandler.generateTradesInWorld(cubeVillager, level, pos, desiredCount);
                }
            }
        } else {
            VillagerDataHandler.generateTradesInWorld(cubeVillager, level, pos, desiredCount);
        }
        try {
            cubeVillager.field_5960 = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            cubeVillager.method_5684(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            cubeVillager.method_5977(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            cubeVillager.method_5803(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return cubeVillager;
    }

    private static void generateTradesInWorld(CubeVillager cubeVillager, class_1937 level, class_2338 pos) {
        VillagerDataHandler.generateTradesInWorld(cubeVillager, level, pos, -1);
    }

    private static void generateTradesInWorld(CubeVillager cubeVillager, class_1937 level, class_2338 pos, int desiredCount) {
        block68: {
            if (level == null || cubeVillager == null) {
                return;
            }
            if (level.method_8608()) {
                try {
                    PocketVillagersMod.LOGGER.debug("[generateTradesInWorld] Skipping client-side generation (level is client).");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            try {
                block66: {
                    class_5321 profKey;
                    try {
                        class_3850 vd = cubeVillager.method_7231();
                        profKey = vd.comp_3521().method_40230().orElse(null);
                        class_5321 typeKey = vd.comp_3520().method_40230().orElse(null);
                        PocketVillagersMod.LOGGER.debug("[generateTradesInWorld] server-side generation invoked for profession={} type={} level={}", (Object)(profKey == null ? "<null>" : profKey.method_29177()), (Object)(typeKey == null ? "<null>" : typeKey.method_29177()), (Object)vd.comp_3522());
                    }
                    catch (Throwable vd) {
                        // empty catch block
                    }
                    try {
                        Optional profKeyOpt = cubeVillager.method_7231().comp_3521().method_40230();
                        if (!profKeyOpt.isPresent()) break block66;
                        profKey = (class_5321)profKeyOpt.get();
                        boolean found = false;
                        for (Map.Entry entry : class_3853.field_17067.entrySet()) {
                            try {
                                class_5321 k = (class_5321)entry.getKey();
                                if (k == null || k.method_29177() == null || !k.method_29177().equals((Object)profKey.method_29177())) continue;
                                found = true;
                                break;
                            }
                            catch (Throwable k) {
                            }
                        }
                        if (!found) {
                            try {
                                PocketVillagersMod.LOGGER.warn("[generateTradesInWorld] No VillagerTrades.TRADES entry found for profession {} (mod trades may be data-driven)", (Object)profKey.method_29177());
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                StringBuilder sb = new StringBuilder();
                                int c = 0;
                                for (Map.Entry entry : class_3853.field_17067.entrySet()) {
                                    if (c++ >= 10) break;
                                    try {
                                        sb.append(((class_5321)entry.getKey()).method_29177()).append(',');
                                    }
                                    catch (Throwable throwable) {}
                                }
                                PocketVillagersMod.LOGGER.debug("[generateTradesInWorld] sample VillagerTrades.TRADES keys: {}", (Object)sb.toString());
                            }
                            catch (Throwable sb) {}
                            break block66;
                        }
                        try {
                            PocketVillagersMod.LOGGER.debug("[generateTradesInWorld] Found VillagerTrades.TRADES entry for profession {}", (Object)profKey.method_29177());
                        }
                        catch (Throwable sb) {}
                    }
                    catch (Throwable profKeyOpt) {
                        // empty catch block
                    }
                }
                if (!(level instanceof class_3218)) {
                    try {
                        PocketVillagersMod.LOGGER.warn("[generateTradesInWorld] Level is not a ServerLevel, cannot generate trades");
                    }
                    catch (Throwable profKey) {
                        // empty catch block
                    }
                    return;
                }
                class_3218 serverLevel = (class_3218)level;
                class_1646 temp = new class_1646(class_1299.field_6077, (class_1937)serverLevel);
                try {
                    temp.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
                }
                catch (Throwable found) {
                    // empty catch block
                }
                try {
                    temp.method_7195(cubeVillager.method_7231());
                }
                catch (Throwable found) {
                    // empty catch block
                }
                try {
                    temp.method_19625(cubeVillager.method_19269());
                }
                catch (Throwable found) {
                    // empty catch block
                }
                try {
                    temp.method_5684(true);
                }
                catch (Throwable found) {
                    // empty catch block
                }
                try {
                    temp.method_5977(true);
                }
                catch (Throwable found) {
                    // empty catch block
                }
                try {
                    temp.method_5803(true);
                }
                catch (Throwable found) {
                    // empty catch block
                }
                try {
                    try {
                        temp.method_16917(new class_1916());
                    }
                    catch (Throwable found) {
                        // empty catch block
                    }
                    Method m = class_1646.class.getDeclaredMethod("updateTrades", new Class[0]);
                    m.setAccessible(true);
                    try {
                        m.invoke((Object)temp, new Object[0]);
                    }
                    catch (Throwable reflectInvoke) {
                        try {
                            PocketVillagersMod.LOGGER.warn("[generateTradesInWorld] reflection updateTrades() invocation failed: {}", (Object)reflectInvoke.toString());
                        }
                        catch (Throwable c) {}
                    }
                }
                catch (Throwable reflectFail) {
                    try {
                        PocketVillagersMod.LOGGER.warn("[generateTradesInWorld] reflection updateTrades() failed: {}", (Object)reflectFail.toString());
                    }
                    catch (Throwable reflectInvoke) {
                        // empty catch block
                    }
                }
                class_1916 generated = null;
                try {
                    generated = temp.method_8264();
                }
                catch (Throwable reflectInvoke) {
                    // empty catch block
                }
                int genSize = generated == null ? 0 : generated.size();
                try {
                    PocketVillagersMod.LOGGER.debug("[generateTradesInWorld] Temp vanilla villager generated {} offers", (Object)genSize);
                }
                catch (Throwable c) {
                    // empty catch block
                }
                if (generated == null || generated.isEmpty()) break block68;
                try {
                    cubeVillager.method_16917(generated);
                }
                catch (Throwable t) {
                    try {
                        PocketVillagersMod.LOGGER.warn("[generateTradesInWorld] Failed to set offers on CubeVillager: {}", (Object)t.toString());
                    }
                    catch (Throwable k) {
                        // empty catch block
                    }
                }
                try {
                    VillagerDataHandler.saveVillagerDataToCube((class_1937)serverLevel, pos, cubeVillager);
                    try {
                        PocketCubeBlockEntity cubeEntity;
                        class_2586 be = serverLevel.method_8321(pos);
                        if (!(be instanceof PocketCubeBlockEntity) || !(cubeEntity = (PocketCubeBlockEntity)be).hasWorkstation()) break block68;
                        try {
                            class_1792 class_17922;
                            class_1799 throwable = cubeEntity.getWorkstation();
                            if (throwable == null || !((class_17922 = throwable.method_7909()) instanceof class_1747)) break block68;
                            class_1747 bi = (class_1747)class_17922;
                            class_2960 key = class_7923.field_41175.method_10221((Object)bi.method_7711());
                            Optional profKeyOpt = cubeVillager.method_7231().comp_3521().method_40230();
                            if (key == null || !profKeyOpt.isPresent()) break block68;
                            String blockId = key.toString();
                            String profId = ((class_5321)profKeyOpt.get()).method_29177().toString();
                            try {
                                PocketVillagersMod.saveCompatMapping(blockId, profId);
                            }
                            catch (Throwable throwable2) {
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                    catch (Throwable throwable) {
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable t) {
                try {
                    PocketVillagersMod.LOGGER.error("[generateTradesInWorld] Failed to generate trades", t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static CubeVillager createTradingVillager(class_1937 level, class_2338 pos, class_2487 villagerData) {
        return VillagerDataHandler.createTradingVillager(level, pos, villagerData, -1);
    }

    public static CubeVillager createTradingVillager(class_1937 level, class_2338 pos, class_2487 villagerData, int desiredCount) {
        return VillagerDataHandler.buildCubeVillager(level, pos, villagerData, desiredCount);
    }

    public static class_2487 toEntityNbt(class_2487 villagerData) {
        class_2487 out = new class_2487();
        if (villagerData == null || villagerData.method_33133()) {
            return out;
        }
        try {
            block24: {
                try {
                    Optional maybe = villagerData.method_10562(VILLAGER_DATA_KEY);
                    if (maybe.isPresent()) {
                        out.method_10566(VILLAGER_DATA_KEY, (class_2520)((class_2487)maybe.get()).method_10553());
                    }
                }
                catch (Throwable maybe) {
                    // empty catch block
                }
                try {
                    if (out.method_10545(VILLAGER_DATA_KEY)) break block24;
                    class_2487 inner = new class_2487();
                    boolean hasInner = false;
                    try {
                        Optional mp = villagerData.method_10558("VillagerData.profession");
                        if (mp.isPresent()) {
                            inner.method_10582("profession", mp.orElse("minecraft:none"));
                            hasInner = true;
                        }
                    }
                    catch (Throwable mp) {
                        // empty catch block
                    }
                    try {
                        Optional mt = villagerData.method_10558("VillagerData.type");
                        if (mt.isPresent()) {
                            inner.method_10582("type", mt.orElse("minecraft:plains"));
                            hasInner = true;
                        }
                    }
                    catch (Throwable mt) {
                        // empty catch block
                    }
                    try {
                        Optional ml = villagerData.method_10550("VillagerData.level");
                        if (ml.isPresent()) {
                            inner.method_10569("level", ml.orElse(1).intValue());
                            hasInner = true;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (hasInner) {
                        out.method_10566(VILLAGER_DATA_KEY, (class_2520)inner);
                    }
                }
                catch (Throwable inner) {
                    // empty catch block
                }
            }
            try {
                Optional maybeXp = villagerData.method_10550("Xp");
                if (maybeXp.isPresent()) {
                    out.method_10569("Xp", maybeXp.orElse(0).intValue());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (villagerData.method_10545("Offers")) {
                    out.method_10566("Offers", villagerData.method_10580("Offers"));
                }
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return out;
    }

    public static class_1646 spawnVillagerFromData(class_1937 level, class_2338 pos, class_2487 villagerData) {
        return VillagerDataHandler.spawnVillagerFromData(level, pos, villagerData, null);
    }

    /*
     * WARNING - void declaration
     */
    public static class_1646 spawnVillagerFromData(class_1937 level, class_2338 pos, class_2487 villagerData, class_1657 player) {
        if (level == null || pos == null || villagerData == null) {
            return null;
        }
        try {
            int xp;
            class_1646 villager;
            block41: {
                PocketVillagersMod.LOGGER.debug("spawnVillagerFromData: Received villagerData with conversions={} conversionTime={}", (Object)(villagerData.method_10545("PocketVillagers.Conversions") ? villagerData.method_10550("PocketVillagers.Conversions").orElse(0) : 0), (Object)(villagerData.method_10545("ConversionTime") ? villagerData.method_10550("ConversionTime").orElse(0) : 0));
                villager = new class_1646(class_1299.field_6077, level);
                villager.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
                if (villagerData.method_10545("VillagerData.profession")) {
                    String professionStr = villagerData.method_10558("VillagerData.profession").orElse("minecraft:none");
                    String typeStr = villagerData.method_10558("VillagerData.type").orElse("minecraft:plains");
                    int villagerLevel = villagerData.method_10550("VillagerData.level").orElse(1);
                    PocketVillagersMod.LOGGER.debug("spawnVillagerFromData: Restoring profession={} type={} level={}", (Object)professionStr, (Object)typeStr, (Object)villagerLevel);
                    class_2960 professionLocation = class_2960.method_60654((String)professionStr);
                    Object[] typeLocation = class_2960.method_60654((String)typeStr);
                    Optional professionOpt = class_7923.field_41195.method_10223(professionLocation);
                    Optional typeOpt = class_7923.field_41194.method_10223((class_2960)typeLocation);
                    if (professionOpt.isPresent() && typeOpt.isPresent()) {
                        villager.method_7195(villager.method_7231().method_16921((class_6880)professionOpt.get()).method_16922((class_6880)typeOpt.get()).method_16920(villagerLevel));
                        PocketVillagersMod.LOGGER.debug("spawnVillagerFromData: Successfully set profession to {}", (Object)professionStr);
                    }
                }
                xp = villagerData.method_10550("Xp").orElse(0);
                villager.method_19625(xp);
                PocketVillagersMod.LOGGER.debug("spawnVillagerFromData: Setting XP to {}", (Object)xp);
                if (villagerData.method_10545("ConversionTime")) {
                    int conversionTime = villagerData.method_10550("ConversionTime").orElse(0);
                    PocketVillagersMod.LOGGER.debug("spawnVillagerFromData: Setting ConversionTime to {} (cured villager)", (Object)conversionTime);
                    try {
                        Object conversionTimeField = null;
                        String[] possibleNames = new String[]{"ConversionTime", "conversionTime", "bQ", "bR", "bS", "bT", "bU", "bV", "bW", "bX", "bY", "bZ", "ca", "cb", "cc", "cd", "ce", "cf", "cg", "ch", "ci", "cj", "ck", "cl", "cm", "cn", "co", "cp", "cq", "cr", "cs", "ct", "cu", "cv", "cw", "cx", "cy", "cz"};
                        for (String string : possibleNames) {
                            try {
                                conversionTimeField = class_1646.class.getDeclaredField(string);
                                PocketVillagersMod.LOGGER.debug("spawnVillagerFromData: Found ConversionTime field: {}", (Object)string);
                                break;
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                            }
                        }
                        if (conversionTimeField == null) {
                            for (Field field : class_1646.class.getDeclaredFields()) {
                                String name = field.getName().toLowerCase();
                                if (!name.contains("onversion") && !name.contains("ime") || field.getType() != Integer.TYPE) continue;
                                conversionTimeField = field;
                                PocketVillagersMod.LOGGER.debug("spawnVillagerFromData: Found potential conversion/time field: {}", (Object)field.getName());
                                break;
                            }
                        }
                        if (conversionTimeField == null) {
                            PocketVillagersMod.LOGGER.debug("spawnVillagerFromData: Available int fields in Villager:");
                            for (Field field : class_1646.class.getDeclaredFields()) {
                                if (field.getType() != Integer.TYPE) continue;
                                PocketVillagersMod.LOGGER.debug("spawnVillagerFromData: int field: {}", (Object)field.getName());
                            }
                        }
                        if (conversionTimeField != null) {
                            ((Field)conversionTimeField).setAccessible(true);
                            ((Field)conversionTimeField).setInt(villager, conversionTime);
                            PocketVillagersMod.LOGGER.debug("spawnVillagerFromData: Successfully set ConversionTime field");
                        } else {
                            PocketVillagersMod.LOGGER.warn("spawnVillagerFromData: Could not find ConversionTime field on Villager");
                        }
                    }
                    catch (Throwable t) {
                        PocketVillagersMod.LOGGER.warn("spawnVillagerFromData: Failed to set ConversionTime: {}", (Object)t.getMessage());
                    }
                }
                if (villagerData.method_10545("PocketVillagers.Conversions")) {
                    int conversions = villagerData.method_10550("PocketVillagers.Conversions").orElse(0);
                    villager.method_5780("PocketVillagers.Conversions=" + conversions);
                    PocketVillagersMod.LOGGER.debug("spawnVillagerFromData: Added entity tag 'PocketVillagers.Conversions={}' to villager", (Object)conversions);
                }
                try {
                    if (villagerData.method_10545("Offers")) {
                        class_6903 registryOps;
                        DataResult result;
                        class_2520 offersTag = villagerData.method_10580("Offers");
                        if (offersTag != null && (result = class_1916.field_48850.parse((DynamicOps)(registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)level.method_30349())), (Object)offersTag)).result().isPresent()) {
                            void var12_40;
                            class_1916 restored = (class_1916)result.result().get();
                            int unlockedCount = villagerData.method_10550("UnlockedCount").orElse(restored.size());
                            class_1916 limited = new class_1916();
                            boolean bl = false;
                            while (var12_40 < Math.min(unlockedCount, restored.size())) {
                                limited.add((Object)((class_1914)restored.get((int)var12_40)));
                                ++var12_40;
                            }
                            villager.method_16917(limited);
                            PocketVillagersMod.LOGGER.debug("spawnVillagerFromData: Set {} unlocked offers out of {} total", (Object)unlockedCount, (Object)restored.size());
                        }
                        break block41;
                    }
                    try {
                        Method updateTradesMethod = class_1646.class.getDeclaredMethod("m_35463_", new Class[0]);
                        updateTradesMethod.setAccessible(true);
                        updateTradesMethod.invoke((Object)villager, new Object[0]);
                        PocketVillagersMod.LOGGER.debug("spawnVillagerFromData: Generated fresh offers via updateTrades");
                    }
                    catch (NoSuchMethodException nsm) {
                        try {
                            Method updateTradesMethod = class_1646.class.getDeclaredMethod("updateTrades", new Class[0]);
                            updateTradesMethod.setAccessible(true);
                            updateTradesMethod.invoke((Object)villager, new Object[0]);
                            PocketVillagersMod.LOGGER.debug("spawnVillagerFromData: Generated fresh offers via updateTrades (alt)");
                        }
                        catch (Throwable e2) {
                            PocketVillagersMod.LOGGER.warn("spawnVillagerFromData: Could not call updateTrades: {}", (Object)e2.getMessage());
                        }
                    }
                }
                catch (Throwable t) {
                    PocketVillagersMod.LOGGER.warn("spawnVillagerFromData: Failed to restore/generate offers: {}", (Object)t.getMessage());
                }
            }
            try {
                villager.field_5960 = true;
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                villager.method_5684(true);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                villager.method_5977(true);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                villager.method_5803(true);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                if (level instanceof class_3218) {
                    class_3218 sv2 = (class_3218)level;
                    class_238 aabb2 = new class_238((double)pos.method_10263() - 1.0, (double)pos.method_10264() - 1.0, (double)pos.method_10260() - 1.0, (double)pos.method_10263() + 2.0, (double)pos.method_10264() + 3.0, (double)pos.method_10260() + 2.0);
                    List nearby2 = sv2.method_8390(class_1297.class, aabb2, e -> true);
                    for (class_1297 ent : nearby2) {
                        try {
                            PocketVillagersMod.LOGGER.debug("spawnVillagerFromData: nearby entity at {} -> class={}, id={}, bbox={}, noPhysics={}, removed={}", (Object)pos, (Object)ent.getClass().getName(), (Object)ent.method_5628(), (Object)ent.method_5829(), (Object)ent.field_5960, (Object)ent.method_31481());
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            level.method_8649((class_1297)villager);
            PocketVillagersMod.LOGGER.debug("spawnVillagerFromData: Villager added to world at {}", (Object)pos);
            PocketVillagersMod.LOGGER.debug("spawnVillagerFromData: Successfully spawned villager with profession={} xp={}", (Object)(villagerData.method_10545("VillagerData.profession") ? villagerData.method_10558("VillagerData.profession").orElse("unknown") : "unknown"), (Object)xp);
            return villager;
        }
        catch (Throwable t) {
            PocketVillagersMod.LOGGER.error("spawnVillagerFromData: Failed to spawn villager", t);
            return null;
        }
    }

    public static void clearVillagerData(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_58694(class_9334.field_49628);
        if (customData != null) {
            class_2487 tag = customData.method_57461();
            tag.method_10551(VILLAGER_DATA_KEY);
            tag.method_10551(HAS_VILLAGER_KEY);
            stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        }
    }

    public static void restoreEntityBehavior(class_1297 ent) {
        if (ent == null) {
            return;
        }
        try {
            ent.field_5960 = false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ent.method_5684(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ent.method_5803(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ent.method_5875(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (ent instanceof class_1308) {
                class_1308 m = (class_1308)ent;
                try {
                    m.method_5977(false);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean isConvertedEntity(class_1646 villager) {
        for (String tag : villager.method_5752()) {
            if (tag == null || !tag.startsWith("PocketVillagers.Conversions=")) continue;
            try {
                String numPart = tag.substring("PocketVillagers.Conversions=".length());
                int conversions = Integer.parseInt(numPart);
                return conversions > 0;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return false;
    }

    public static CubeVillager regenerateBaseOffers(class_3218 level, class_2338 pos, class_2487 villagerData) {
        return VillagerDataHandler.createTradingVillager((class_1937)level, pos, villagerData);
    }

    public static CubeVillager regenerateBaseOffers(class_3218 level, class_2338 pos, class_2487 villagerData, int desiredCount) {
        return VillagerDataHandler.createTradingVillager((class_1937)level, pos, villagerData, desiredCount);
    }

    public static void saveVillagerDataToCube(class_1937 level, class_2338 pos, CubeVillager villager) {
        if (level == null || pos == null || villager == null) {
            return;
        }
        class_2586 be = level.method_8321(pos);
        if (!(be instanceof PocketCubeBlockEntity)) {
            return;
        }
        PocketCubeBlockEntity cubeEntity = (PocketCubeBlockEntity)be;
        class_2487 villagerData = new class_2487();
        villagerData.method_10582("id", "minecraft:villager");
        class_3850 vd = villager.method_7231();
        String profession = "minecraft:none";
        String type = "minecraft:plains";
        int level_val = 1;
        try {
            String storedProf;
            class_2487 storedData;
            profession = ((class_5321)vd.comp_3521().method_40230().orElseThrow()).method_29177().toString();
            type = ((class_5321)vd.comp_3520().method_40230().orElseThrow()).method_29177().toString();
            level_val = vd.comp_3522();
            if ("minecraft:none".equals(profession) && (storedData = cubeEntity.getVillagerData()) != null && storedData.method_10545("VillagerData.profession") && !"minecraft:none".equals(storedProf = storedData.method_10558("VillagerData.profession").orElse("minecraft:none"))) {
                PocketVillagersMod.LOGGER.debug("saveVillagerDataToCube: profession was reset to none! Restoring stored profession={}", (Object)storedProf);
                profession = storedProf;
                try {
                    class_2960 profRl = class_2960.method_60654((String)storedProf);
                    Optional profOpt = class_7923.field_41195.method_10223(profRl);
                    if (profOpt.isPresent()) {
                        villager.method_7195(vd.method_16921((class_6880)profOpt.get()));
                        PocketVillagersMod.LOGGER.debug("saveVillagerDataToCube: restored profession on entity to {}", (Object)storedProf);
                    }
                }
                catch (Throwable t) {
                    PocketVillagersMod.LOGGER.warn("saveVillagerDataToCube: failed to restore profession on entity: {}", (Object)t.getMessage());
                }
            }
            villagerData.method_10582("VillagerData.profession", profession);
            villagerData.method_10582("VillagerData.type", type);
            villagerData.method_10569("VillagerData.level", level_val);
            PocketVillagersMod.LOGGER.debug("saveVillagerDataToCube: SAVED profession={} type={} level={}", (Object)profession, (Object)type, (Object)level_val);
            if ("minecraft:none".equals(profession)) {
                PocketVillagersMod.LOGGER.warn("saveVillagerDataToCube: PROFESSION IS NONE! Stack trace:", (Throwable)new RuntimeException());
            }
        }
        catch (Throwable e) {
            PocketVillagersMod.LOGGER.warn("saveVillagerDataToCube: ERROR saving profession: {}", (Object)e.getMessage(), (Object)e);
        }
        villagerData.method_10569("Xp", villager.method_19269());
        boolean professionLocked = villager.method_19269() > 0;
        villagerData.method_10556("ProfessionLocked", professionLocked);
        try {
            int conversions = villager.getConversionCount();
            int conversionTime = villager.getConversionTime();
            if (conversions > 0) {
                villagerData.method_10569("PocketVillagers.Conversions", conversions);
                PocketVillagersMod.LOGGER.debug("[POCKET VILLAGERS DEBUG] saveVillagerDataToCube: saved conversion count={}", (Object)conversions);
            }
            if (conversionTime > 0) {
                villagerData.method_10569("ConversionTime", conversionTime);
                PocketVillagersMod.LOGGER.debug("[POCKET VILLAGERS DEBUG] saveVillagerDataToCube: saved ConversionTime={}", (Object)conversionTime);
            }
        }
        catch (Throwable t) {
            PocketVillagersMod.LOGGER.warn("saveVillagerDataToCube: Failed to save conversion data: {}", (Object)t.getMessage());
        }
        class_1916 offers = villager.method_8264();
        if (offers != null && !offers.isEmpty()) {
            try {
                class_3218 serverLevel;
                class_6903 registryOps;
                DataResult result;
                class_1916 sanitized = new class_1916();
                for (int i = 0; i < offers.size(); ++i) {
                    try {
                        class_1914 o = (class_1914)offers.get(i);
                        if (o == null) continue;
                        try {
                            Field usesField = class_1914.class.getDeclaredField("uses");
                            usesField.setAccessible(true);
                            usesField.setInt(o, 0);
                            Field maxUsesField = class_1914.class.getDeclaredField("maxUses");
                            maxUsesField.setAccessible(true);
                            maxUsesField.setInt(o, Integer.MAX_VALUE);
                        }
                        catch (Throwable usesField) {
                            // empty catch block
                        }
                        sanitized.add((Object)o);
                        continue;
                    }
                    catch (Throwable o) {
                        // empty catch block
                    }
                }
                if (level instanceof class_3218 && (result = class_1916.field_48850.encodeStart((DynamicOps)(registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)(serverLevel = (class_3218)level).method_30349())), (Object)sanitized)).result().isPresent()) {
                    villagerData.method_10566("Offers", (class_2520)result.result().get());
                    PocketVillagersMod.LOGGER.debug("saveVillagerDataToCube: Saved {} offers", (Object)sanitized.size());
                }
            }
            catch (Throwable sanitized) {
                // empty catch block
            }
        }
        try {
            PocketVillagersMod.LOGGER.debug("saveVillagerDataToCube: pos={} xp={} offers={} profession={} level={}", (Object)pos, (Object)villager.method_19269(), (Object)(offers == null ? 0 : offers.size()), (Object)profession, (Object)level_val);
        }
        catch (Throwable sanitized) {
            // empty catch block
        }
        cubeEntity.setVillagerData(villagerData);
        cubeEntity.method_5431();
        try {
            level.method_8413(pos, level.method_8320(pos), level.method_8320(pos), 3);
        }
        catch (Throwable sanitized) {
            // empty catch block
        }
        try {
            class_3218 serverLevel;
            class_2818 chunk;
            if (level instanceof class_3218 && (chunk = (serverLevel = (class_3218)level).method_8500(pos)) != null) {
                chunk.method_65063();
                serverLevel.method_14178().method_14128(pos);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

