/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.burial_backups.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import net.minecraft.class_11560;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3144;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.orifu.burial_backups.Death;
import net.orifu.burial_backups.Either;
import net.orifu.burial_backups.Util;
import net.orifu.burial_backups.command.CommandUtils;
import net.orifu.burial_backups.storage.ServerStorage;
import org.jetbrains.annotations.Nullable;

public class DeathCommand {
    public static final String COMMAND_NAME = "death";
    public static final int SHOW = 10;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final List<class_1304> EQUIPMENT_SLOTS = class_1661.field_56551.int2ObjectEntrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getValue).toList().reversed();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_NAME).requires(s -> s.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(ctx -> DeathCommand.list((CommandContext<class_2168>)ctx, null, 1))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2191.method_9329()).executes(ctx -> DeathCommand.list((CommandContext<class_2168>)ctx, CommandUtils.profiles((CommandContext<class_2168>)ctx, "target"), 1))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> DeathCommand.list((CommandContext<class_2168>)ctx, CommandUtils.profiles((CommandContext<class_2168>)ctx, "target"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))))).then(CommandUtils.deathAndProfile("view", DeathCommand::view))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"restore").executes(DeathCommand::restoreAll)).then(CommandUtils.deathAndPlayer("all", DeathCommand::restoreAll))).then(CommandUtils.deathAndPlayer("inventory", DeathCommand::restoreInventory))).then(CommandUtils.deathAndPlayer("position", DeathCommand::restorePosition))).then(CommandUtils.deathAndPlayer("safeposition", DeathCommand::restoreSafePosition))));
    }

    @Nullable
    private static class_11560 profile(CommandContext<class_2168> ctx, @Nullable Collection<class_11560> inPlayer) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        return inPlayer != null ? (inPlayer.size() == 1 ? inPlayer.stream().findAny().get() : null) : (player != null ? Util.nameAndId(player) : null);
    }

    public static int list(CommandContext<class_2168> ctx, @Nullable Collection<class_11560> inPlayer, int page) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        class_11560 profile = DeathCommand.profile(ctx, inPlayer);
        if (profile == null) {
            return 1;
        }
        boolean isPlayer = player != null && Util.nameAndId(player).equals((Object)profile);
        int startI = 10 * (page - 1);
        List<Death> deaths = ServerStorage.getDeaths(((class_2168)ctx.getSource()).method_9211(), profile.comp_4422());
        int pageCount = Math.ceilDiv(deaths.size(), 10);
        if (startI >= deaths.size()) {
            ((class_2168)ctx.getSource()).method_9226(() -> isPlayer ? class_2561.method_43471((String)"burial_backups.list.empty") : class_2561.method_43469((String)"burial_backups.list.empty.name", (Object[])new Object[]{profile.comp_4423()}), false);
            return 1;
        }
        class_5250 component = isPlayer ? class_2561.method_43471((String)"burial_backups.list.header") : class_2561.method_43469((String)"burial_backups.list.header.name", (Object[])new Object[]{profile.comp_4423()});
        for (int i = startI; i < Math.min(deaths.size(), startI + 10); ++i) {
            Death death = deaths.get(i);
            class_5250 hover = class_2561.method_43469((String)"burial_backups.death_time", (Object[])new Object[]{Util.relativeTime(death.deathTime())}).method_10852(class_5244.field_33849).method_10852((class_2561)class_2561.method_43469((String)"burial_backups.xp_levels", (Object[])new Object[]{death.experience().xpLevel()}).method_27696(class_2583.field_24360.method_36139(8453920)));
            component.method_10852(class_5244.field_33849).method_10852((class_2561)class_2561.method_43471((String)"burial_backups.list.prefix"));
            component.method_10852((class_2561)Util.clearHoverAndClickEvents(death.deathMessage()).method_10862(class_2583.field_24360.method_10949((class_2568)new class_2568.class_10613((class_2561)hover)).method_10958((class_2558)new class_2558.class_10610("/death view " + i + (String)(isPlayer ? "" : " " + profile.comp_4423())))));
        }
        component.method_10852(class_5244.field_33849);
        component.method_10852((class_2561)class_2561.method_43469((String)"burial_backups.list.page", (Object[])new Object[]{page, pageCount}));
        if (deaths.size() > startI + 10) {
            component.method_10852(class_5244.field_33849);
            component.method_10852((class_2561)class_2561.method_43471((String)"burial_backups.list.next_page").method_10862(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10610("/death list " + profile.comp_4423() + " " + (page + 1)))));
        }
        ((class_2168)ctx.getSource()).method_9226(() -> component, false);
        return 0;
    }

    public static int view(CommandContext<class_2168> ctx, Death death, class_11560 profile, int id) {
        SimpleGui gui = new SimpleGui(class_3917.field_18667, ((class_2168)ctx.getSource()).method_44023(), false);
        gui.setTitle((class_2561)class_2561.method_43469((String)"burial_backups.view.title", (Object[])new Object[]{profile.comp_4423()}));
        if (death.inventory().items().size() == 36) {
            int i;
            for (i = 9; i < 36; ++i) {
                gui.addSlot(death.inventory().items().get(i));
            }
            for (i = 0; i < 9; ++i) {
                gui.addSlot(death.inventory().items().get(i));
            }
        } else {
            for (class_1799 stack : death.inventory().items()) {
                gui.addSlot(stack);
            }
        }
        for (class_1304 slot : EQUIPMENT_SLOTS) {
            if (death.inventory().equipment().containsKey(slot)) {
                gui.addSlot(death.inventory().equipment().get(slot));
                continue;
            }
            gui.addSlot((GuiElementInterface)GuiElement.EMPTY);
        }
        gui.setSlot(44, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)new class_1799((class_1935)class_1802.field_8575)).setProfile(profile.comp_4422()).setName(death.deathMessage()).addLoreLine((class_2561)class_2561.method_43469((String)"burial_backups.info.time", (Object[])new Object[]{DATE_FORMAT.format(death.deathTime()), TIME_FORMAT.format(death.deathTime()), Util.relativeTime(death.deathTime())})).addLoreLine((class_2561)class_2561.method_43469((String)"burial_backups.position", (Object[])new Object[]{(int)death.position().field_1352, (int)death.position().field_1351, (int)death.position().field_1350, death.dimension().toString()})).addLoreLine((class_2561)class_2561.method_43469((String)"burial_backups.xp_levels", (Object[])new Object[]{death.experience().xpLevel()})));
        gui.open();
        return 0;
    }

    public static int restoreInventory(CommandContext<class_2168> ctx, Death death, class_3222 restoreTo, int id) {
        death.inventory().restore(restoreTo.method_31548());
        death.experience().restore(restoreTo);
        ((class_2168)ctx.getSource()).method_9226(() -> restoreTo.equals((Object)((class_2168)ctx.getSource()).method_44023()) ? class_2561.method_43471((String)"burial_backups.restore.inventory") : class_2561.method_43469((String)"burial_backups.restore.inventory.name", (Object[])new Object[]{restoreTo.method_5476()}), true);
        return 0;
    }

    public static int restorePosition(CommandContext<class_2168> ctx, Death death, class_3222 restoreTo, int id) {
        Optional<class_3218> deathLevel = death.level(((class_2168)ctx.getSource()).method_9211());
        if (deathLevel.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43469((String)"burial_backups.restore.position.missing_dimension", (Object[])new Object[]{death.dimension().toString()}));
            return 1;
        }
        class_243 vec = death.position();
        restoreTo.method_48105(deathLevel.get(), vec.field_1352, vec.field_1351, vec.field_1350, Set.of(), 0.0f, 0.0f, true);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"burial_backups.restore.position"), true);
        return 0;
    }

    public static int restoreSafePosition(CommandContext<class_2168> ctx, Death death, class_3222 restoreTo, int id) {
        Optional<class_3545<class_2338, class_3218>> maybePosAndLevel = DeathCommand.findSafePosition(ctx, death, restoreTo);
        if (maybePosAndLevel.isEmpty()) {
            return 1;
        }
        DeathCommand.teleportToPosition(ctx, death, restoreTo, maybePosAndLevel.get(), "burial_backups.restore.position", "burial_backups.restore.position.distance");
        return 0;
    }

    private static Optional<class_3545<class_2338, class_3218>> findSafePosition(CommandContext<class_2168> ctx, Death death, class_3222 restoreTo) {
        Optional<class_3218> deathLevel = death.level(((class_2168)ctx.getSource()).method_9211());
        if (deathLevel.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43469((String)"burial_backups.restore.position.missing_dimension", (Object[])new Object[]{death.dimension().toString()}));
            return Optional.empty();
        }
        class_2338 blockPos = class_2338.method_49638((class_2374)death.position());
        if (!deathLevel.get().method_8477(blockPos)) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43469((String)"burial_backups.restore.position.unloaded", (Object[])new Object[]{blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), death.dimension().toString()}));
            return Optional.empty();
        }
        Optional<class_2338> safePos = Util.findSafeBlock((class_1297)restoreTo, ((class_2168)ctx.getSource()).method_9225(), blockPos);
        if (safePos.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43469((String)"burial_backups.restore.position.unsafe", (Object[])new Object[]{blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()}));
        }
        return safePos.map(pos -> new class_3545(pos, (Object)((class_3218)deathLevel.get())));
    }

    private static void teleportToPosition(CommandContext<class_2168> ctx, Death death, class_3222 restoreTo, class_3545<class_2338, class_3218> posAndLevel, String success, String successDistance) {
        class_2338 deathPos = class_2338.method_49638((class_2374)death.position());
        class_2338 safePos = (class_2338)posAndLevel.method_15442();
        class_3218 deathLevel = (class_3218)posAndLevel.method_15441();
        if (safePos.equals((Object)deathPos)) {
            class_243 vec = death.position();
            restoreTo.method_48105(deathLevel, vec.field_1352, vec.field_1351, vec.field_1350, Set.of(), 0.0f, 0.0f, true);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)success), true);
        } else {
            class_243 safeVec = safePos.method_61082();
            if (restoreTo.method_48105(deathLevel, safeVec.field_1352, safeVec.field_1351, safeVec.field_1350, Set.of(), 0.0f, 0.0f, true)) {
                new class_3144.class_9252(death.position()).method_13772((class_2168)ctx.getSource(), (class_1297)restoreTo);
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)successDistance, (Object[])new Object[]{String.format("%.2f", death.position().method_1022(safeVec)), deathPos.method_10263(), deathPos.method_10264(), deathPos.method_10260()}), true);
        }
    }

    public static int restoreAll(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            return 1;
        }
        Either<Death, Integer> death = CommandUtils.tryLoadDeath(ctx, player.method_5667(), 0);
        return death.flattenToRight(d -> DeathCommand.restoreAll(ctx, d, player, 0));
    }

    public static int restoreAll(CommandContext<class_2168> ctx, Death death, class_3222 restoreTo, int id) {
        death.inventory().restore(restoreTo.method_31548());
        death.experience().restore(restoreTo);
        Optional<class_3545<class_2338, class_3218>> maybePosAndLevel = DeathCommand.findSafePosition(ctx, death, restoreTo);
        if (maybePosAndLevel.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"burial_backups.restore.all.no_position"), true);
            return 1;
        }
        DeathCommand.teleportToPosition(ctx, death, restoreTo, maybePosAndLevel.get(), "burial_backups.restore.all", "burial_backups.restore.all.distance");
        return 0;
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        TIME_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

