/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.burial_backups;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_3545;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Either<L, R> {
    @Nullable
    private final L left;
    @Nullable
    private final R right;

    private Either(@Nullable L left, @Nullable R right) {
        this.left = left;
        this.right = right;
    }

    public static <L, R> Either<L, R> left(@NotNull L left) {
        return new Either<L, Object>(left, null);
    }

    public static <L, R> Either<L, R> right(@NotNull R right) {
        return new Either<Object, R>(null, right);
    }

    public <NEW> Either<NEW, R> mapLeft(Function<L, NEW> fn) {
        return this.left != null ? Either.left(fn.apply(this.left)) : Either.right(Objects.requireNonNull(this.right));
    }

    public <NEW> Either<NEW, R> flatMapLeft(Function<L, Either<NEW, R>> fn) {
        return this.left != null ? fn.apply(this.left) : Either.right(Objects.requireNonNull(this.right));
    }

    public <NEW> Either<class_3545<L, NEW>, R> flatMapLeftAndKeep(Function<L, Either<NEW, R>> fn) {
        return this.flatMapLeft(fn).mapLeft(value -> new class_3545(this.left, value));
    }

    public <OUT> OUT flatten(Function<L, OUT> reduceLeft, Function<R, OUT> reduceRight) {
        return this.left != null ? reduceLeft.apply(this.left) : reduceRight.apply(this.right);
    }

    public L flattenToLeft(Function<R, L> reduceRight) {
        return this.left != null ? this.left : reduceRight.apply(this.right);
    }

    public R flattenToRight(Function<L, R> reduceLeft) {
        return this.left != null ? reduceLeft.apply(this.left) : this.right;
    }
}

