/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.burial_backups.storage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_7225;
import net.orifu.burial_backups.BurialBackups;
import net.orifu.burial_backups.Death;
import net.orifu.burial_backups.storage.StorageUtils;

@Environment(value=EnvType.CLIENT)
public class ClientStorage {
    public static final Codec<ClientDeathData> CODEC = StorageUtils.versionedCodec(RecordCodecBuilder.create(instance -> instance.group((App)Death.CODEC.listOf().fieldOf("deaths").forGetter(ClientDeathData::deaths)).apply((Applicative)instance, ClientDeathData::new)), 1);
    private final List<Death> deaths = new ArrayList<Death>();
    private final Path path;

    public ClientStorage(Path path) {
        this.path = path;
    }

    private ClientStorage(ClientDeathData data, Path path) {
        this(path);
        this.deaths.addAll(data.deaths);
    }

    public static CompletableFuture<ClientStorage> get(class_642 serverData) {
        CompletableFuture<ClientStorage> fut = new CompletableFuture<ClientStorage>();
        class_156.method_27958().execute(() -> fut.complete(ClientStorage.load(serverData)));
        return fut;
    }

    public static void add(class_642 serverData, Death death) {
        class_156.method_27958().execute(() -> {
            ClientStorage storage = ClientStorage.load(serverData);
            storage.addAndSave(death);
        });
    }

    private static ClientStorage load(class_642 serverData) {
        File deathsPath = new File(class_310.method_1551().field_1697, "deaths_remote");
        Path storagePath = new File(deathsPath, serverData.field_3761 + ".dat").toPath();
        deathsPath.mkdirs();
        return StorageUtils.loadFromPath(storagePath, CODEC, ClientStorage::new, ClientStorage::new);
    }

    private void addAndSave(Death death) {
        this.deaths.add(death);
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            BurialBackups.LOGGER.error("can't save when not in level");
            return;
        }
        StorageUtils.saveToPath(new ClientDeathData(this.deaths), this.path, CODEC, (class_7225.class_7874)level.method_30349());
    }

    public record ClientDeathData(List<Death> deaths) {
    }
}

