/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.burial_backups.storage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_156;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import net.orifu.burial_backups.BurialBackups;
import net.orifu.burial_backups.Death;
import net.orifu.burial_backups.storage.StorageUtils;
import org.jetbrains.annotations.Nullable;

public class ServerStorage {
    public static final Codec<ServerDeathData> CODEC = StorageUtils.versionedCodec(RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_4844.field_41525, (Codec)Death.CODEC.listOf()).fieldOf("deaths").forGetter(ServerDeathData::deaths)).apply((Applicative)instance, ServerDeathData::new)), 1);
    @Nullable
    private static CompletableFuture<ServerStorage> INSTANCE;
    private final Map<UUID, List<Death>> deaths = new HashMap<UUID, List<Death>>();
    private final Path path;

    private ServerStorage(Path path) {
        this.path = path;
    }

    private ServerStorage(ServerDeathData data, Path path) {
        this(path);
        for (Map.Entry<UUID, List<Death>> entry : data.deaths().entrySet()) {
            entry.getValue().reversed().forEach(d -> this.addWithoutSave((UUID)entry.getKey(), (Death)d));
        }
    }

    public static CompletableFuture<ServerStorage> get(MinecraftServer server) {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = new CompletableFuture();
        class_156.method_27958().execute(() -> {
            Path storagePath = server.field_23784.method_54543().comp_732().resolve("burial_backups.dat");
            INSTANCE.complete(StorageUtils.loadFromPath(storagePath, CODEC, ServerStorage::new, ServerStorage::new));
        });
        return INSTANCE;
    }

    public static ServerStorage getSync(MinecraftServer server) {
        try {
            return ServerStorage.get(server).get();
        }
        catch (InterruptedException | ExecutionException e) {
            BurialBackups.LOGGER.error("failed to load server storage", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static List<Death> getDeaths(MinecraftServer server, UUID uuid) {
        return ServerStorage.getSync(server).get(uuid);
    }

    public static Optional<Death> getDeath(MinecraftServer server, UUID uuid, int id) {
        List<Death> deaths = ServerStorage.getDeaths(server, uuid);
        if (id >= deaths.size()) {
            return Optional.empty();
        }
        return Optional.of(deaths.get(id));
    }

    public void save(MinecraftServer server) {
        class_156.method_27958().execute(() -> {
            BurialBackups.LOGGER.info("saving death data!");
            StorageUtils.saveToPath(new ServerDeathData(this.deaths), this.path, CODEC, (class_7225.class_7874)server.method_30611());
        });
    }

    public void add(UUID uuid, Death death, MinecraftServer server) {
        this.addAndSave(uuid, death, server);
    }

    protected void addAndSave(UUID uuid, Death death, MinecraftServer server) {
        this.addWithoutSave(uuid, death);
        this.save(server);
    }

    protected void addWithoutSave(UUID uuid, Death death) {
        if (!this.deaths.containsKey(uuid)) {
            this.deaths.put(uuid, new ArrayList());
        }
        this.deaths.get(uuid).addFirst(death);
    }

    public List<Death> get(UUID uuid) {
        return this.deaths.getOrDefault(uuid, List.of());
    }

    public record ServerDeathData(Map<UUID, List<Death>> deaths) {
    }
}

