/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.burial_backups.storage;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.orifu.burial_backups.BurialBackups;

class StorageUtils {
    private StorageUtils() {
    }

    public static <A> Codec<A> versionedCodec(final Codec<A> codec, final int version) {
        return new Codec<A>(){

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
                DataResult versionObj = ops.get(input, "version");
                Objects.requireNonNull(versionObj);
                int decodedVersion = versionObj.flatMap(arg_0 -> ops.getNumberValue(arg_0)).map(Number::intValue).result().orElse(0);
                if (version != decodedVersion) {
                    return DataResult.error(() -> "bad version: " + decodedVersion);
                }
                Dynamic withoutVersion = new Dynamic(ops, ops.remove(input, "version"));
                return codec.decode(withoutVersion);
            }

            public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
                return codec.encode(input, ops, prefix).flatMap(obj -> ops.mergeToMap(obj, ops.createString("version"), ops.createInt(version)));
            }
        };
    }

    public static <T, A> T loadFromPath(Path storagePath, Codec<A> codec, class_7225.class_7874 registryProvider, BiFunction<A, Path, T> onSuccess, Function<Path, T> onFail) {
        class_2487 tag;
        try {
            tag = class_2507.method_30613((Path)storagePath, (class_2505)class_2505.method_53899((long)0x6400000L));
        }
        catch (IOException e) {
            StorageUtils.createBackup(storagePath);
            return onFail.apply(storagePath);
        }
        class_6903 ops = registryProvider.method_57093((DynamicOps)class_2509.field_11560);
        DataResult output = codec.parse((DynamicOps)ops, (Object)tag);
        if (output.isError()) {
            BurialBackups.LOGGER.error("failed to read burial backups data at {}\n{}", (Object)storagePath, output.error().orElseThrow());
            StorageUtils.createBackup(storagePath);
            return onFail.apply(storagePath);
        }
        return onSuccess.apply(output.getOrThrow(), storagePath);
    }

    private static void createBackup(Path path) {
        if (!path.toFile().exists()) {
            return;
        }
        String fileName = path.toFile().getName();
        Path parent = path.getParent();
        for (int i = 0; i < 999; ++i) {
            Path backupPath = parent.resolve(fileName + "." + i);
            if (backupPath.toFile().exists()) continue;
            try {
                Files.copy(path, backupPath, new CopyOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            BurialBackups.LOGGER.warn("failed to load backups data; old version has been copied to {}", (Object)backupPath);
            return;
        }
        BurialBackups.LOGGER.error("failed to create backup for old data. it may be lost!");
    }

    public static <A> void saveToPath(A data, Path storagePath, Codec<A> codec, class_7225.class_7874 registryProvider) {
        class_6903 ops = registryProvider.method_57093((DynamicOps)class_2509.field_11560);
        DataResult nbt = codec.encodeStart((DynamicOps)ops, data);
        if (nbt.isError()) {
            BurialBackups.LOGGER.error("failed to write burial backups data\n{}", nbt.error().orElseThrow());
            return;
        }
        try {
            class_2507.method_30614((class_2487)((class_2487)nbt.getOrThrow()), (Path)storagePath);
        }
        catch (IOException e) {
            BurialBackups.LOGGER.error("failed to write burial backups data to {}", (Object)storagePath, (Object)e);
        }
    }
}

