/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.burial_backups;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_8824;
import net.minecraft.server.MinecraftServer;

public record Death(class_243 position, class_2960 dimension, Inventory inventory, Experience experience, class_2561 deathMessage, Date deathTime) {
    public static final Codec<Death> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_243.field_38277.fieldOf("position").forGetter(Death::position), (App)class_2960.field_25139.fieldOf("dimension").forGetter(Death::dimension), (App)Inventory.MAP_CODEC.forGetter(Death::inventory), (App)Experience.MAP_CODEC.forGetter(Death::experience), (App)class_8824.field_46597.fieldOf("death_message").forGetter(Death::deathMessage), (App)Codec.LONG.xmap(Date::new, Date::getTime).fieldOf("deathTime").forGetter(Death::deathTime)).apply((Applicative)instance, Death::new));

    public static Death fromPlayer(class_1657 player, class_2561 deathMessage) {
        return new Death(player.method_19538(), player.method_37908().method_27983().method_29177(), new Inventory(player.method_31548().method_67533().stream().map(class_1799::method_7972).toList(), class_1661.field_56551.int2ObjectEntrySet().stream().map(entry -> Map.entry((class_1304)entry.getValue(), player.method_31548().method_5438(entry.getIntKey()).method_7972())).filter(entry -> !((class_1799)entry.getValue()).method_7960()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))), new Experience(player.field_7520, player.field_7510, player.field_7495, player.method_7272()), deathMessage, new Date());
    }

    public Optional<class_3218> level(MinecraftServer server) {
        Optional<class_5321> deathLevelKey = server.method_29435().stream().filter(key -> key.method_29177().equals((Object)this.dimension)).findAny();
        return deathLevelKey.map(arg_0 -> ((MinecraftServer)server).method_3847(arg_0));
    }

    public record Inventory(List<class_1799> items, Map<class_1304, class_1799> equipment) {
        public static final MapCodec<Inventory> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1799.field_49266.listOf().fieldOf("items").forGetter(Inventory::items), (App)Codec.unboundedMap((Codec)class_1304.field_45739, (Codec)class_1799.field_49266).fieldOf("equipment").forGetter(Inventory::equipment)).apply((Applicative)instance, Inventory::new));
        private static final Map<class_1304, Integer> EQUIPMENT_SLOT_MAPPING = class_1661.field_56551.int2ObjectEntrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Int2ObjectMap.Entry::getIntKey));

        public void restore(class_1661 inventory) {
            inventory.method_5448();
            for (int i = 0; i < this.items.size(); ++i) {
                inventory.method_5447(i, this.items.get(i));
            }
            for (Map.Entry<class_1304, class_1799> e : this.equipment.entrySet()) {
                inventory.method_5447(EQUIPMENT_SLOT_MAPPING.get(e.getKey()).intValue(), e.getValue());
            }
        }
    }

    public record Experience(int xpLevel, float xpProgress, int totalXp, int score) {
        public static final MapCodec<Experience> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("xp_level").forGetter(Experience::xpLevel), (App)Codec.FLOAT.fieldOf("xp_progress").forGetter(Experience::xpProgress), (App)Codec.INT.fieldOf("total_xp").forGetter(Experience::totalXp), (App)Codec.INT.fieldOf("score").forGetter(Experience::score)).apply((Applicative)instance, Experience::new));

        public void restore(class_3222 player) {
            player.field_7495 = this.totalXp;
            player.field_7510 = this.xpProgress;
            player.method_14252(this.xpLevel);
            player.method_7320(this.score);
        }
    }
}

