/*
 * Decompiled with CFR 0.152.
 */
package net.orifu.burial_backups.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.orifu.burial_backups.Death;
import net.orifu.burial_backups.Either;
import net.orifu.burial_backups.NameAndId;
import net.orifu.burial_backups.Util;
import net.orifu.burial_backups.storage.ServerStorage;

public class CommandUtils {
    private CommandUtils() {
    }

    public static LiteralArgumentBuilder<class_2168> deathAndProfile(String name, DeathCommand<NameAndId> command) {
        return CommandUtils.deathAndProfileOrPlayer(name, Either.left(command));
    }

    public static LiteralArgumentBuilder<class_2168> deathAndPlayer(String name, DeathCommand<class_3222> command) {
        return CommandUtils.deathAndProfileOrPlayer(name, Either.right(command));
    }

    public static Collection<NameAndId> profiles(CommandContext<class_2168> ctx, String name) throws CommandSyntaxException {
        return class_2191.method_9330(ctx, (String)name).stream().map(NameAndId::new).toList();
    }

    private static Either<NameAndId, Integer> tryLoadProfile(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        Optional<NameAndId> maybeProfile = class_2191.method_9330(ctx, (String)"target").stream().findAny().map(NameAndId::new);
        Optional<class_3222> maybePlayer = Optional.ofNullable(((class_2168)ctx.getSource()).method_44023());
        Optional<NameAndId> profile = maybeProfile.or(() -> maybePlayer.map(Util::nameAndId));
        return profile.map(Either::left).orElseGet(() -> Either.right(1));
    }

    public static Either<Death, Integer> tryLoadDeath(CommandContext<class_2168> ctx, UUID uuid, int id) {
        Optional<Death> maybeDeath = ServerStorage.getDeath(((class_2168)ctx.getSource()).method_9211(), uuid, id);
        if (maybeDeath.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"burial_backups.info.no_death"));
            return Either.right(1);
        }
        return Either.left(maybeDeath.get());
    }

    private static LiteralArgumentBuilder<class_2168> deathAndProfileOrPlayer(String name, Either<DeathCommand<NameAndId>, DeathCommand<class_3222>> command) {
        RequiredArgumentBuilder targetedCommand = command.flatten(profileFn -> (RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2191.method_9329()).executes(ctx -> {
            int id = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id");
            return CommandUtils.tryLoadProfile((CommandContext<class_2168>)ctx).flatMapLeftAndKeep(profile -> CommandUtils.tryLoadDeath((CommandContext<class_2168>)ctx, profile.id(), id)).flattenToRight(data -> profileFn.run((CommandContext<class_2168>)ctx, (Death)data.method_15441(), (NameAndId)((Object)((Object)((Object)((Object)data.method_15442())))), id));
        }), playerFn -> (RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(ctx -> {
            class_3222 player = class_2186.method_9315((CommandContext)ctx, (String)"target");
            int id = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id");
            return CommandUtils.tryLoadDeath((CommandContext<class_2168>)ctx, player.method_5667(), id).flattenToRight(death -> playerFn.run((CommandContext<class_2168>)ctx, (Death)death, player, id));
        }));
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            if (player == null) {
                return 1;
            }
            return CommandUtils.tryLoadDeath((CommandContext<class_2168>)ctx, player.method_5667(), 0).flattenToRight(death -> command.flatten(fn -> fn.run((CommandContext<class_2168>)ctx, (Death)death, Util.nameAndId(player), 0), fn -> fn.run((CommandContext<class_2168>)ctx, (Death)death, player, 0)));
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            if (player == null) {
                return 1;
            }
            int id = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id");
            return CommandUtils.tryLoadDeath((CommandContext<class_2168>)ctx, player.method_5667(), id).flattenToRight(death -> command.flatten(fn -> fn.run((CommandContext<class_2168>)ctx, (Death)death, Util.nameAndId(player), id), fn -> fn.run((CommandContext<class_2168>)ctx, (Death)death, player, id)));
        })).then((ArgumentBuilder)targetedCommand));
    }

    @FunctionalInterface
    public static interface DeathCommand<T> {
        public int run(CommandContext<class_2168> var1, Death var2, T var3, int var4);
    }
}

