/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeCountLimitConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;

public abstract class UpgradeItemBase<T extends IUpgradeWrapper>
extends ItemBase
implements IUpgradeItem<T> {
    private final IUpgradeCountLimitConfig upgradeTypeLimitConfig;

    protected UpgradeItemBase(IUpgradeCountLimitConfig upgradeTypeLimitConfig, Item.Properties properties) {
        super(properties);
        this.upgradeTypeLimitConfig = upgradeTypeLimitConfig;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.addAll(TranslationHelper.INSTANCE.getTranslatedLines(stack.getItem().getDescriptionId() + ".tooltip", null, ChatFormatting.DARK_GRAY));
    }

    @Override
    public int getUpgradesPerStorage(String storageType) {
        return this.upgradeTypeLimitConfig.getMaxUpgradesPerStorage(storageType, BuiltInRegistries.ITEM.getKey((Object)this));
    }

    @Override
    public int getUpgradesInGroupPerStorage(String storageType) {
        if (this.getUpgradeGroup().isSolo()) {
            return Integer.MAX_VALUE;
        }
        return this.upgradeTypeLimitConfig.getMaxUpgradesInGroupPerStorage(storageType, this.getUpgradeGroup());
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)this.getDescriptionId());
    }
}

