/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.voiding;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogicContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class VoidUpgradeContainer
extends UpgradeContainerBase<VoidUpgradeWrapper, VoidUpgradeContainer> {
    private static final String DATA_SHOULD_WORKD_IN_GUI = "shouldWorkdInGUI";
    private static final String DATA_SHOULD_VOID_OVERFLOW = "shouldVoidOverflow";
    private final FilterLogicContainer<FilterLogic> filterLogicContainer = new FilterLogicContainer<FilterLogic>(((VoidUpgradeWrapper)this.upgradeWrapper)::getFilterLogic, this, this.slots::add);

    public VoidUpgradeContainer(Player player, int containerId, VoidUpgradeWrapper wrapper, UpgradeContainerType<VoidUpgradeWrapper, VoidUpgradeContainer> type) {
        super(player, containerId, wrapper, type);
    }

    @Override
    public void handlePacket(CompoundTag data) {
        data.getBoolean(DATA_SHOULD_WORKD_IN_GUI).ifPresent(this::setShouldWorkdInGUI);
        data.getBoolean(DATA_SHOULD_VOID_OVERFLOW).ifPresent(this::setShouldVoidOverflow);
        this.filterLogicContainer.handlePacket(data);
    }

    public FilterLogicContainer<FilterLogic> getFilterLogicContainer() {
        return this.filterLogicContainer;
    }

    public void setShouldWorkdInGUI(boolean shouldWorkdInGUI) {
        ((VoidUpgradeWrapper)this.upgradeWrapper).setShouldWorkdInGUI(shouldWorkdInGUI);
        this.sendDataToServer(() -> NBTHelper.putBoolean(new CompoundTag(), DATA_SHOULD_WORKD_IN_GUI, shouldWorkdInGUI));
    }

    public void setShouldVoidOverflow(boolean shouldVoidOverflow) {
        ((VoidUpgradeWrapper)this.upgradeWrapper).setShouldVoidOverflow(shouldVoidOverflow);
        this.sendDataToServer(() -> NBTHelper.putBoolean(new CompoundTag(), DATA_SHOULD_VOID_OVERFLOW, shouldVoidOverflow));
    }

    public boolean shouldWorkInGUI() {
        return ((VoidUpgradeWrapper)this.upgradeWrapper).shouldWorkInGUI();
    }

    public boolean shouldVoidOverflow() {
        return ((VoidUpgradeWrapper)this.upgradeWrapper).shouldVoidOverflow();
    }
}

