/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.neoforged.bus.api.IEventBus;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.compat.CompatInfo;
import net.p3pp3rf1y.sophisticatedcore.compat.ICompat;

public class CompatRegistry {
    private static final Map<CompatInfo, List<Supplier<Function<IEventBus, ICompat>>>> compatFactories = new ConcurrentHashMap<CompatInfo, List<Supplier<Function<IEventBus, ICompat>>>>();
    private static final Map<CompatInfo, List<ICompat>> loadedCompats = new ConcurrentHashMap<CompatInfo, List<ICompat>>();

    public static void registerCompat(CompatInfo info, Supplier<Function<IEventBus, ICompat>> factory) {
        compatFactories.computeIfAbsent(info, k -> new ArrayList()).add(factory);
    }

    public static void setupCompats() {
        loadedCompats.values().forEach(compats -> compats.forEach(ICompat::setup));
    }

    public static void initCompats(IEventBus modBus) {
        compatFactories.forEach((compatInfo, factories) -> {
            if (compatInfo.isLoaded()) {
                factories.forEach(factory -> {
                    try {
                        loadedCompats.computeIfAbsent((CompatInfo)compatInfo, k -> new ArrayList()).add((ICompat)((Function)factory.get()).apply(modBus));
                    }
                    catch (Exception e) {
                        SophisticatedCore.LOGGER.error("Error instantiating compatibility ", (Throwable)e);
                    }
                });
            }
        });
        loadedCompats.values().forEach(compats -> compats.forEach(compat -> compat.init(modBus)));
    }
}

