/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.IRecipeDisplayGenerator;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.ShapedRecipeDisplayBuilder;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.ShapelessRecipeDisplayBuilder;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.subtypes.PropertyBasedSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedcore.crafting.CustomShapelessRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.ICustomSmithingRecipe;
import net.p3pp3rf1y.sophisticatedcore.util.ICreativeTabSupplier;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class ClientRecipeHelper {
    private ClientRecipeHelper() {
    }

    public static <I extends RecipeInput, R extends Recipe<I>, U extends Recipe<?>> void runOnAllRecipesOfType(RecipeType<R> recipeType, Class<U> filterRecipeClass, Consumer<RecipeHolder<R>> run) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return;
        }
        RecipeHelper.getRecipesOfType(recipeType).stream().filter(r -> filterRecipeClass.isInstance(r.value())).forEach(run);
    }

    public static <I extends RecipeInput> ItemStack assemble(Recipe<I> recipe, I container) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.registryAccess();
        return recipe.assemble(container, (HolderLookup.Provider)registryAccess);
    }

    private static ItemStack getVariantResult(CraftingRecipe recipe, ItemStack variantItem) {
        Collection<Optional<Ingredient>> ingredients = RecipeHelper.getIngredients(recipe);
        TransientCraftingContainer craftingInventory = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

            public ItemStack quickMoveStack(Player player, int index) {
                return ItemStack.EMPTY;
            }

            public boolean stillValid(Player playerIn) {
                return false;
            }
        }, 3, 3);
        int slot = 0;
        for (Optional<Ingredient> ingredient : ingredients) {
            int fSlot = slot++;
            ingredient.ifPresentOrElse(arg_0 -> ClientRecipeHelper.lambda$getVariantResult$1(variantItem, (CraftingContainer)craftingInventory, fSlot, arg_0), () -> ClientRecipeHelper.lambda$getVariantResult$2((CraftingContainer)craftingInventory, fSlot));
        }
        return ClientRecipeHelper.assemble(recipe, craftingInventory.asCraftInput());
    }

    private static ItemStack getStackFromIngredient(Ingredient i) {
        if (i.getCustomIngredient() != null) {
            return i.getCustomIngredient().items().findFirst().map(holder -> new ItemStack((ItemLike)holder.value())).orElse(ItemStack.EMPTY);
        }
        return i.getValues().size() > 0 ? new ItemStack((ItemLike)i.getValues().get(0).value()) : ItemStack.EMPTY;
    }

    private static boolean ingredientMatchesVariantItem(ItemStack variantItem, Ingredient ingredient) {
        if (ingredient.getCustomIngredient() != null) {
            return ingredient.getCustomIngredient().items().anyMatch(item -> item == variantItem.getItem());
        }
        return ingredient.getValues().stream().anyMatch(holder -> holder.value() == variantItem.getItem());
    }

    public static <U extends CraftingRecipe> void addVariantRecipes(IRecipeDisplayGenerator<?> generator, Class<U> originalRecipeClass, Function<CraftingRecipe, List<ItemStack>> getVariantItems, Function<ItemStack, Optional<PropertyBasedSubtypeInterpreter>> getSubtypeInterpreter, String modId, String idPrefix) {
        ClientRecipeHelper.runOnAllRecipesOfType(RecipeType.CRAFTING, originalRecipeClass, recipe -> ((List)getVariantItems.apply((CraftingRecipe)recipe.value())).forEach(variantItem -> {
            ItemStack result = ClientRecipeHelper.getVariantResult((CraftingRecipe)recipe.value(), variantItem.copy());
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)modId, (String)(idPrefix + ClientRecipeHelper.getItemString(getSubtypeInterpreter, variantItem) + "_to_" + ClientRecipeHelper.getItemString(getSubtypeInterpreter, result)));
            ClientRecipeHelper.addVariantIngredientRecipe(generator, recipe.value(), variantItem, result, id);
        }));
    }

    private static <U extends PropertyBasedSubtypeInterpreter> String getItemString(Function<ItemStack, Optional<U>> getSubtypeInterpreter, ItemStack storageItem) {
        return getSubtypeInterpreter.apply(storageItem).map(interpreter -> interpreter.getRegistrySanitizedItemString(storageItem)).orElse("");
    }

    public static <I extends RecipeInput, R extends Recipe<I>> void addAllRecipesOfType(IRecipeDisplayGenerator<?> generator, RecipeType<R> recipeType, Class<? extends Recipe<?>> filterRecipeClass) {
        ClientRecipeHelper.runOnAllRecipesOfType(recipeType, filterRecipeClass, recipe -> ClientRecipeHelper.addRecipe(generator, recipe));
    }

    private static <I extends RecipeInput, R extends Recipe<I>> void addRecipe(IRecipeDisplayGenerator<?> generator, RecipeHolder<R> recipe) {
        Recipe recipe2 = recipe.value();
        if (recipe2 instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe2;
            generator.shaped(shapedRecipe.result).setDimensions(shapedRecipe.pattern.width(), shapedRecipe.pattern.height()).defineIngredients(shapedRecipe.getIngredients()).save(recipe.id());
        } else {
            recipe2 = recipe.value();
            if (recipe2 instanceof CustomShapelessRecipe) {
                CustomShapelessRecipe shapelessRecipe = (CustomShapelessRecipe)recipe2;
                generator.shapeless(shapelessRecipe.result()).requires(shapelessRecipe.placementInfo().ingredients()).save(recipe.id());
            } else {
                recipe2 = recipe.value();
                if (recipe2 instanceof ICustomSmithingRecipe) {
                    ICustomSmithingRecipe smithingRecipe = (ICustomSmithingRecipe)recipe2;
                    generator.smithing(smithingRecipe.templateIngredient(), smithingRecipe.baseIngredient(), smithingRecipe.additionIngredient(), smithingRecipe.result()).save(recipe.id());
                }
            }
        }
    }

    private static void addVariantIngredientRecipe(IRecipeDisplayGenerator<?> generator, Recipe<?> recipe, ItemStack variantItem, ItemStack result, ResourceLocation id) {
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            ShapedRecipeDisplayBuilder<?> shaped = generator.shaped(result).setDimensions(shapedRecipe.pattern.width(), shapedRecipe.pattern.height());
            for (Optional ingredient : shapedRecipe.getIngredients()) {
                ingredient.ifPresentOrElse(i -> {
                    if (ClientRecipeHelper.ingredientMatchesVariantItem(variantItem, i)) {
                        shaped.define(variantItem);
                    } else {
                        shaped.define((Ingredient)i);
                    }
                }, () -> shaped.define((HolderSet<Item>)HolderSet.empty()));
            }
            shaped.save(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)id));
        } else if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
            ClientRecipeHelper.addShapelessRecipe(generator, variantItem, result, id, shapelessRecipe.ingredients);
        } else if (recipe instanceof CustomShapelessRecipe) {
            CustomShapelessRecipe customShapelessRecipe = (CustomShapelessRecipe)recipe;
            ClientRecipeHelper.addShapelessRecipe(generator, variantItem, result, id, customShapelessRecipe.placementInfo().ingredients());
        }
    }

    private static void addShapelessRecipe(IRecipeDisplayGenerator<?> generator, ItemStack variantItem, ItemStack result, ResourceLocation id, List<Ingredient> ingredients) {
        ShapelessRecipeDisplayBuilder<?> shapeless = generator.shapeless(result);
        for (Ingredient ingredient : ingredients) {
            if (ClientRecipeHelper.ingredientMatchesVariantItem(variantItem, ingredient)) {
                shapeless.requires(variantItem);
                continue;
            }
            shapeless.requires(ingredient);
        }
        shapeless.save(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)id));
    }

    public static List<ItemStack> getIngredientCreativeTabVariants(Recipe<?> recipe, Class<? extends ICreativeTabSupplier> itemClass) {
        return ClientRecipeHelper.getIngredientCreativeTabVariants(recipe, itemClass, stack -> {});
    }

    public static List<ItemStack> getIngredientCreativeTabVariants(Recipe<?> recipe, Class<? extends ICreativeTabSupplier> itemClass, Consumer<ItemStack> updateStack) {
        ArrayList<ItemStack> ingredientItems = new ArrayList<ItemStack>();
        for (Optional<Ingredient> ingredient : RecipeHelper.getIngredients(recipe)) {
            ingredient.ifPresent(i -> ClientRecipeHelper.getIngredientValues(i).map(Holder::value).filter(itemClass::isInstance).map(itemClass::cast).forEach(item -> item.addCreativeTabItems(stack -> {
                updateStack.accept((ItemStack)stack);
                ingredientItems.add((ItemStack)stack);
            })));
            if (ingredientItems.isEmpty()) continue;
            break;
        }
        return ingredientItems;
    }

    private static Stream<Holder<Item>> getIngredientValues(Ingredient i) {
        if (i.getCustomIngredient() != null) {
            return i.getCustomIngredient().items();
        }
        return i.getValues().stream();
    }

    public static List<ItemStack> getCustomIngredientVariants(Recipe<?> recipe, Class<? extends ICustomIngredient> customIngredientClass) {
        for (Optional<Ingredient> ingredient : RecipeHelper.getIngredients(recipe)) {
            Ingredient i;
            if (!ingredient.isPresent() || !customIngredientClass.isInstance((i = ingredient.get()).getCustomIngredient())) continue;
            ICustomIngredient customIngredient = i.getCustomIngredient();
            return customIngredient.display().resolveForStacks(RecipeHelper.getContextMap());
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void lambda$getVariantResult$2(CraftingContainer craftingInventory, int fSlot) {
        craftingInventory.setItem(fSlot, ItemStack.EMPTY);
    }

    private static /* synthetic */ void lambda$getVariantResult$1(ItemStack variantItem, CraftingContainer craftingInventory, int fSlot, Ingredient i) {
        if (ClientRecipeHelper.ingredientMatchesVariantItem(variantItem, i)) {
            craftingInventory.setItem(fSlot, variantItem.copy());
        } else {
            craftingInventory.setItem(fSlot, ClientRecipeHelper.getStackFromIngredient(i));
        }
    }
}

