/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.controller;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public interface IControllerBoundable {
    public static final String CONTROLLER_POS_TAG = "controllerPos";

    public void setControllerPos(BlockPos var1);

    public Optional<BlockPos> getControllerPos();

    public void removeControllerPos();

    public BlockPos getStorageBlockPos();

    public Level getStorageBlockLevel();

    default public boolean canBeConnected() {
        return this.getControllerPos().isEmpty();
    }

    public void registerController(ControllerBlockEntityBase var1);

    public void unregisterController();

    public boolean canConnectStorages();

    default public void runOnController(Level level, Consumer<ControllerBlockEntityBase> toRun) {
        this.getControllerPos().flatMap(pos -> WorldHelper.getLoadedBlockEntity(level, pos, ControllerBlockEntityBase.class)).ifPresent(toRun);
    }

    default public void saveControllerPos(CompoundTag tag) {
        this.getControllerPos().ifPresent(p -> tag.putLong(CONTROLLER_POS_TAG, p.asLong()));
    }

    default public void loadControllerPos(CompoundTag tag) {
        NBTHelper.getLong(tag, CONTROLLER_POS_TAG).ifPresent(value -> {
            BlockPos controllerPos = BlockPos.of((long)value);
            this.setControllerPos(controllerPos);
        });
    }

    default public void addToController(Level level, BlockPos pos, BlockPos controllerPos) {
    }

    default public void addToAdjacentController() {
        Level level = this.getStorageBlockLevel();
        if (!level.isClientSide()) {
            BlockPos pos = this.getStorageBlockPos();
            for (Direction dir : Direction.values()) {
                BlockPos offsetPos = pos.offset(dir.getUnitVec3i());
                WorldHelper.getBlockEntity((BlockGetter)level, offsetPos, IControllerBoundable.class).ifPresentOrElse(s -> {
                    if (s.canConnectStorages()) {
                        s.getControllerPos().ifPresent(controllerPos -> this.addToController(level, pos, (BlockPos)controllerPos));
                    }
                }, () -> this.addToController(level, pos, offsetPos));
                if (this.getControllerPos().isPresent()) break;
            }
        }
    }
}

