/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.common.gui;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.HashCode;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetCursorItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.HashOps;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.RemoteSlot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.network.SyncContainerStacksPayload;
import net.p3pp3rf1y.sophisticatedcore.network.SyncSlotStackPayload;

public class HighStackCountSynchronizer
implements ContainerSynchronizer {
    private final ServerPlayer player;
    private final LoadingCache<TypedDataComponent<?>, Integer> cache;

    public HighStackCountSynchronizer(final ServerPlayer player) {
        this.player = player;
        this.cache = CacheBuilder.newBuilder().maximumSize(256L).build(new CacheLoader<TypedDataComponent<?>, Integer>(this){
            private final DynamicOps<HashCode> registryHashOps;
            {
                this.registryHashOps = player.registryAccess().createSerializationContext((DynamicOps)HashOps.CRC32C_INSTANCE);
            }

            public Integer load(TypedDataComponent<?> key) {
                return ((HashCode)key.encodeValue(this.registryHashOps).getOrThrow(e -> new IllegalArgumentException("Failed to hash " + String.valueOf(key) + ": " + e))).asInt();
            }
        });
    }

    public void sendInitialData(AbstractContainerMenu containerMenu, List<ItemStack> stacks, ItemStack carriedStack, int[] dataSlots) {
        PacketDistributor.sendToPlayer((ServerPlayer)this.player, (CustomPacketPayload)new SyncContainerStacksPayload(containerMenu.containerId, containerMenu.incrementStateId(), stacks, carriedStack), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendSlotChange(AbstractContainerMenu containerMenu, int slotInd, ItemStack stack) {
        PacketDistributor.sendToPlayer((ServerPlayer)this.player, (CustomPacketPayload)new SyncSlotStackPayload(containerMenu.containerId, containerMenu.incrementStateId(), slotInd, stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendCarriedChange(AbstractContainerMenu containerMenu, ItemStack stack) {
        this.player.connection.send((Packet)new ClientboundSetCursorItemPacket(stack));
    }

    public void sendDataChange(AbstractContainerMenu containerMenu, int slotInd, int data) {
    }

    public RemoteSlot createSlot() {
        return new RemoteSlot.Synchronized(arg_0 -> this.cache.getUnchecked(arg_0));
    }
}

