/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.nosort;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;

public class NoSortSettingsContainer
extends SettingsContainerBase<NoSortSettingsCategory> {
    private static final String ACTION_TAG = "action";
    private static final String SELECT_ALL_ACTION = "selectAll";
    private static final String UNSELECT_ALL_ACTION = "unselectAll";
    private static final String UNSELECT_SLOT_TAG = "unselectSlot";
    private static final String SELECT_SLOT_TAG = "selectSlot";
    private static final String COLOR_TAG = "color";

    public NoSortSettingsContainer(SettingsContainerMenu<?> settingsContainer, String categoryName, NoSortSettingsCategory category) {
        super(settingsContainer, categoryName, category);
    }

    @Override
    public void handlePacket(CompoundTag data) {
        data.getString(ACTION_TAG).ifPresent(action -> {
            switch (action) {
                case "selectAll": {
                    this.selectAllSlots();
                    break;
                }
                case "unselectAll": {
                    this.unselectAllSlots();
                    break;
                }
            }
        });
        data.getInt(SELECT_SLOT_TAG).ifPresent(this::selectSlot);
        data.getInt(UNSELECT_SLOT_TAG).ifPresent(this::unselectSlot);
        data.getInt(COLOR_TAG).ifPresent(colorId -> this.setColor(DyeColor.byId((int)colorId)));
    }

    public void unselectSlot(int slotNumber) {
        if (!this.isSlotSelected(slotNumber)) {
            return;
        }
        if (this.isServer()) {
            ((NoSortSettingsCategory)this.getCategory()).unselectSlot(slotNumber);
        } else {
            this.sendIntToServer(UNSELECT_SLOT_TAG, slotNumber);
        }
    }

    public void selectSlot(int slotNumber) {
        if (this.isSlotSelected(slotNumber)) {
            return;
        }
        if (this.isServer()) {
            ((NoSortSettingsCategory)this.getCategory()).selectSlot(slotNumber);
        } else {
            this.sendIntToServer(SELECT_SLOT_TAG, slotNumber);
        }
    }

    public void unselectAllSlots() {
        if (this.isServer()) {
            ((NoSortSettingsCategory)this.getCategory()).unselectAllSlots();
        } else {
            this.sendStringToServer(ACTION_TAG, UNSELECT_ALL_ACTION);
        }
    }

    public void selectAllSlots() {
        if (this.isServer()) {
            ((NoSortSettingsCategory)this.getCategory()).selectSlots(0, this.getSettingsContainer().getNumberOfSlots());
        } else {
            this.sendStringToServer(ACTION_TAG, SELECT_ALL_ACTION);
        }
    }

    public void setColor(DyeColor color) {
        if (this.isServer()) {
            ((NoSortSettingsCategory)this.getCategory()).setColor(color);
        } else {
            this.sendIntToServer(COLOR_TAG, color.getId());
        }
    }

    public boolean isSlotSelected(int slotNumber) {
        return ((NoSortSettingsCategory)this.getCategory()).isSlotSelected(slotNumber);
    }

    public DyeColor getColor() {
        return ((NoSortSettingsCategory)this.getCategory()).getColor();
    }
}

