/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.common.gui;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.HighStackCountSynchronizer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IAdditionalSlotInfoMenu;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.TemplatePersistanceContainer;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.network.SyncAdditionalSlotInfoPayload;
import net.p3pp3rf1y.sophisticatedcore.network.SyncContainerClientDataPayload;
import net.p3pp3rf1y.sophisticatedcore.network.SyncEmptySlotIconsPayload;
import net.p3pp3rf1y.sophisticatedcore.network.SyncTemplateSettingsPayload;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsTemplateStorage;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsContainer;

public abstract class SettingsContainerMenu<S extends IStorageWrapper>
extends AbstractContainerMenu
implements ISyncedContainer,
IAdditionalSlotInfoMenu {
    private static final Map<String, ISettingsContainerFactory<?, ?>> SETTINGS_CONTAINER_FACTORIES = new HashMap();
    protected final Player player;
    protected final S storageWrapper;
    private final List<Slot> storageInventorySlots = new ArrayList<Slot>();
    public final NonNullList<ItemStack> lastGhostSlots = NonNullList.create();
    public final NonNullList<ItemStack> remoteGhostSlots = NonNullList.create();
    private final Map<String, SettingsContainerBase<?>> settingsContainers = new LinkedHashMap();
    private final TemplatePersistanceContainer templatePersistanceContainer;
    public final List<Slot> ghostSlots = new ArrayList<Slot>();
    private boolean inventorySlotStackChanged = false;
    private final Set<Integer> inaccessibleSlots = new HashSet<Integer>();
    private final Map<Integer, ItemStack> slotFilterItems = new HashMap<Integer, ItemStack>();
    private final Map<Integer, ResourceLocation> emptySlotIcons = new HashMap<Integer, ResourceLocation>();

    protected SettingsContainerMenu(MenuType<?> menuType, int windowId, Player player, S storageWrapper) {
        super(menuType, windowId);
        this.player = player;
        this.storageWrapper = storageWrapper;
        this.addStorageInventorySlots();
        this.addSettingsContainers();
        this.templatePersistanceContainer = new TemplatePersistanceContainer(this, player.level().registryAccess());
    }

    public int getNumberOfStorageInventorySlots() {
        return this.storageWrapper.getInventoryHandler().getSlots();
    }

    public S getStorageWrapper() {
        return this.storageWrapper;
    }

    private void addSettingsContainers() {
        SettingsHandler settingsHandler = this.storageWrapper.getSettingsHandler();
        settingsHandler.getSettingsCategories().forEach((name, category) -> this.settingsContainers.put((String)name, SettingsContainerMenu.instantiateContainer(this, name, category)));
    }

    private void addStorageInventorySlots() {
        InventoryHandler inventoryHandler = this.storageWrapper.getInventoryHandler();
        int slotIndex = 0;
        while (slotIndex < inventoryHandler.getSlots()) {
            int finalSlotIndex = slotIndex++;
            this.storageInventorySlots.add(this.addSlot((Slot)new ViewOnlyStorageInventorySlot((IItemHandler)inventoryHandler, finalSlotIndex)));
        }
    }

    public int getColumnsTaken() {
        return this.storageWrapper.getColumnsTaken();
    }

    protected Slot addSlot(Slot slot) {
        slot.index = this.ghostSlots.size();
        this.ghostSlots.add(slot);
        this.lastGhostSlots.add((Object)ItemStack.EMPTY);
        this.remoteGhostSlots.add((Object)ItemStack.EMPTY);
        return slot;
    }

    public void broadcastChanges() {
        for (int slot = 0; slot < this.ghostSlots.size(); ++slot) {
            ItemStack itemstack = this.ghostSlots.get(slot).getItem();
            com.google.common.base.Supplier supplier = Suppliers.memoize(() -> ((ItemStack)itemstack).copy());
            this.triggerSlotListeners(slot, itemstack, (Supplier<ItemStack>)supplier);
            this.synchronizeSlotToRemote(slot, itemstack, (Supplier<ItemStack>)supplier);
        }
        if (this.inventorySlotStackChanged) {
            this.inventorySlotStackChanged = false;
            this.sendAdditionalSlotInfo();
        }
    }

    public void broadcastFullState() {
        for (int slotIndex = 0; slotIndex < this.ghostSlots.size(); ++slotIndex) {
            ItemStack itemstack = this.ghostSlots.get(slotIndex).getItem();
            this.triggerSlotListeners(slotIndex, itemstack, () -> ((ItemStack)itemstack).copy());
        }
        this.sendAllDataToRemote();
    }

    private void triggerSlotListeners(int slotIndex, ItemStack slotStack, Supplier<ItemStack> slotStackCopy) {
        ItemStack itemstack = (ItemStack)this.lastGhostSlots.get(slotIndex);
        if (!ItemStack.matches((ItemStack)itemstack, (ItemStack)slotStack)) {
            ItemStack itemstack1 = slotStackCopy.get();
            this.lastGhostSlots.set(slotIndex, (Object)itemstack1);
            for (ContainerListener containerlistener : this.containerListeners) {
                containerlistener.slotChanged((AbstractContainerMenu)this, slotIndex, itemstack1);
            }
        }
    }

    private void synchronizeSlotToRemote(int slotIndex, ItemStack slotStack, Supplier<ItemStack> slotStackCopy) {
        ItemStack remoteStack;
        if (!this.suppressRemoteUpdates && !ItemStack.matches((ItemStack)(remoteStack = (ItemStack)this.remoteGhostSlots.get(slotIndex)), (ItemStack)slotStack)) {
            ItemStack stackCopy = slotStackCopy.get();
            this.remoteGhostSlots.set(slotIndex, (Object)stackCopy);
            if (remoteStack.isEmpty() || slotStack.isEmpty()) {
                this.inventorySlotStackChanged = true;
            }
            if (this.synchronizer != null) {
                this.synchronizer.sendSlotChange((AbstractContainerMenu)this, slotIndex, stackCopy);
            }
        }
    }

    public int getNumberOfSlots() {
        return this.storageWrapper.getInventoryHandler().getSlots();
    }

    public void sendAllDataToRemote() {
        Player player;
        for (int slotIndex = 0; slotIndex < this.ghostSlots.size(); ++slotIndex) {
            this.remoteGhostSlots.set(slotIndex, (Object)this.ghostSlots.get(slotIndex).getItem().copy());
        }
        ItemStack carriedStack = this.getCarried();
        this.remoteCarried.force(carriedStack);
        if (this.synchronizer != null) {
            this.synchronizer.sendInitialData((AbstractContainerMenu)this, this.remoteGhostSlots, carriedStack, new int[0]);
        }
        if ((player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SettingsTemplateStorage settingsTemplateStorage = SettingsTemplateStorage.get();
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncTemplateSettingsPayload(settingsTemplateStorage.getPlayerTemplates((Player)serverPlayer), settingsTemplateStorage.getPlayerNamedTemplates((Player)serverPlayer)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.sendEmptySlotIcons();
        this.sendAdditionalSlotInfo();
    }

    public abstract void detectSettingsChangeAndReload();

    public void setSynchronizer(ContainerSynchronizer synchronizer) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.storageWrapper.getInventoryHandler().getStackSizeMultiplier() > 1.0) {
                super.setSynchronizer((ContainerSynchronizer)new HighStackCountSynchronizer(serverPlayer));
                return;
            }
        }
        super.setSynchronizer(synchronizer);
    }

    public Slot getSlot(int slotId) {
        return this.ghostSlots.get(slotId);
    }

    public void onMemorizedStackAdded(int slotNumber) {
        this.storageWrapper.getInventoryHandler().onSlotFilterChanged(slotNumber);
        this.sendAdditionalSlotInfo();
    }

    public void onMemorizedStackRemoved(int slotNumber) {
        if (this.getSlot(slotNumber).getItem().isEmpty()) {
            this.storageWrapper.getInventoryHandler().onSlotFilterChanged(slotNumber);
            this.storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class).itemChanged(slotNumber);
            this.sendAdditionalSlotInfo();
        }
    }

    public void onMemorizedItemsChanged() {
        this.storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class).itemsChanged();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public List<Slot> getStorageInventorySlots() {
        return this.storageInventorySlots;
    }

    @Override
    public void handlePacket(CompoundTag data) {
        data.getString("categoryName").ifPresent(categoryName -> {
            if (this.settingsContainers.containsKey(categoryName)) {
                this.settingsContainers.get(categoryName).handlePacket(data);
            }
        });
        data.getCompound("templatePersistance").ifPresent(this.templatePersistanceContainer::handlePacket);
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public void forEachSettingsContainer(BiConsumer<String, ? super SettingsContainerBase<?>> consumer) {
        this.settingsContainers.forEach(consumer);
    }

    public Player getPlayer() {
        return this.player;
    }

    public BlockPos getBlockPosition() {
        return BlockPos.ZERO;
    }

    public <T extends ISettingsCategory<?>> Optional<T> getSelectedTemplatesCategory(Class<T> categoryClass) {
        return this.templatePersistanceContainer.getSelectedTemplate().map(selectedTemplate -> selectedTemplate.getTypeCategory(categoryClass));
    }

    public TemplatePersistanceContainer getTemplatePersistanceContainer() {
        return this.templatePersistanceContainer;
    }

    public void refreshTemplateSlots() {
        this.templatePersistanceContainer.refreshTemplateSlots();
    }

    public boolean supportsItemDisplaySideSelection() {
        return false;
    }

    public int getNumberOfRows() {
        return this.storageWrapper.getNumberOfSlotRows();
    }

    protected static <C extends ISettingsCategory<?>, T extends SettingsContainerBase<C>> void addFactory(String categoryName, ISettingsContainerFactory<C, T> factory) {
        SETTINGS_CONTAINER_FACTORIES.put(categoryName, factory);
    }

    private static <C extends ISettingsCategory<?>> SettingsContainerBase<C> instantiateContainer(SettingsContainerMenu<?> settingsContainer, String name, C category) {
        return SettingsContainerMenu.getSettingsContainerFactory(name).create(settingsContainer, name, category);
    }

    private static <C extends ISettingsCategory<?>, T extends SettingsContainerBase<C>> ISettingsContainerFactory<C, T> getSettingsContainerFactory(String name) {
        return SETTINGS_CONTAINER_FACTORIES.get(name);
    }

    public void sendDataToServer(Supplier<CompoundTag> supplyData) {
        if (this.isServer()) {
            return;
        }
        CompoundTag data = supplyData.get();
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncContainerClientDataPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected boolean isServer() {
        return !this.player.level().isClientSide;
    }

    public void sendAdditionalSlotInfo() {
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        HashSet<Integer> inaccessibleSlots = new HashSet<Integer>();
        InventoryHandler inventoryHandler = this.storageWrapper.getInventoryHandler();
        HashMap<Integer, Holder<Item>> slotFilterItems = new HashMap<Integer, Holder<Item>>();
        for (int slot = 0; slot < inventoryHandler.getSlots(); ++slot) {
            if (!inventoryHandler.isSlotAccessible(slot)) {
                inaccessibleSlots.add(slot);
            }
            if (inventoryHandler.getFilterItem(slot) == Items.AIR) continue;
            slotFilterItems.put(slot, (Holder<Item>)inventoryHandler.getFilterItem(slot).builtInRegistryHolder());
        }
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncAdditionalSlotInfoPayload(inaccessibleSlots, Map.of(), Set.of(), slotFilterItems), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void updateAdditionalSlotInfo(Set<Integer> inaccessibleSlots, Map<Integer, Integer> slotLimitOverrides, Set<Integer> infiniteSlots, Map<Integer, Holder<Item>> slotFilterItems) {
        this.inaccessibleSlots.clear();
        this.inaccessibleSlots.addAll(inaccessibleSlots);
        this.slotFilterItems.clear();
        slotFilterItems.forEach((slot, item) -> this.slotFilterItems.put((Integer)slot, new ItemStack(item)));
    }

    @Override
    public void updateEmptySlotIcons(Map<ResourceLocation, Set<Integer>> emptySlotIcons) {
        this.emptySlotIcons.clear();
        emptySlotIcons.forEach((textureName, slots) -> slots.forEach(slot -> this.emptySlotIcons.put((Integer)slot, (ResourceLocation)textureName)));
    }

    private void sendEmptySlotIcons() {
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        HashMap<ResourceLocation, Set<Integer>> noItemSlotTextures = new HashMap<ResourceLocation, Set<Integer>>();
        for (int slot = 0; slot < this.storageWrapper.getInventoryHandler().getSlots(); ++slot) {
            ResourceLocation noItemIcon = this.storageWrapper.getInventoryHandler().getNoItemIcon(slot);
            if (noItemIcon == null) continue;
            noItemSlotTextures.computeIfAbsent(noItemIcon, rl -> new HashSet()).add(slot);
        }
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncEmptySlotIconsPayload(noItemSlotTextures), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public ItemStack getSlotFilterItem(int slot) {
        return this.slotFilterItems.getOrDefault(slot, ItemStack.EMPTY);
    }

    static {
        SettingsContainerMenu.addFactory("global", MainSettingsContainer::new);
        SettingsContainerMenu.addFactory("no_sort", NoSortSettingsContainer::new);
        SettingsContainerMenu.addFactory("memory", MemorySettingsContainer::new);
        SettingsContainerMenu.addFactory("item_display", ItemDisplaySettingsContainer::new);
    }

    private class ViewOnlyStorageInventorySlot
    extends SlotItemHandler {
        public ViewOnlyStorageInventorySlot(IItemHandler inventoryHandler, int slotIndex) {
            super(inventoryHandler, slotIndex, 0, 0);
        }

        public boolean mayPickup(Player playerIn) {
            return false;
        }

        @Nullable
        public ResourceLocation getNoItemIcon() {
            return SettingsContainerMenu.this.inaccessibleSlots.contains(this.getSlotIndex()) ? StorageContainerMenuBase.INACCESSIBLE_SLOT_BACKGROUND : (ResourceLocation)SettingsContainerMenu.this.emptySlotIcons.getOrDefault(this.getSlotIndex(), null);
        }
    }

    public static interface ISettingsContainerFactory<C extends ISettingsCategory<?>, T extends SettingsContainerBase<C>> {
        public T create(SettingsContainerMenu<?> var1, String var2, C var3);
    }
}

