/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.jei;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.CustomDisplayIngredient;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.ShapelessRecipeDisplayBuilder;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.jei.JeiRecipeDisplayGenerator;

public class JeiShapelessRecipeDisplayBuilder
extends ShapelessRecipeDisplayBuilder<CraftingRecipe> {
    private final HolderGetter<Item> items;
    private final JeiRecipeDisplayGenerator generator;
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private final ItemStack result;

    public JeiShapelessRecipeDisplayBuilder(HolderGetter<Item> items, JeiRecipeDisplayGenerator generator, ItemStack result) {
        this.items = items;
        this.generator = generator;
        this.result = result;
    }

    @Override
    public ShapelessRecipeDisplayBuilder<CraftingRecipe> requires(TagKey<Item> tag) {
        return this.requires(Ingredient.of((HolderSet)this.items.getOrThrow(tag)));
    }

    @Override
    public ShapelessRecipeDisplayBuilder<CraftingRecipe> requires(ItemLike item) {
        return this.requires(Ingredient.of((ItemLike)item));
    }

    @Override
    public ShapelessRecipeDisplayBuilder<CraftingRecipe> requires(ItemStack itemStack) {
        return this.requires(CustomDisplayIngredient.of((Ingredient)Ingredient.of((ItemLike)itemStack.getItem()), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(itemStack)));
    }

    @Override
    public ShapelessRecipeDisplayBuilder<CraftingRecipe> requires(HolderSet<Item> items) {
        return this.requires(Ingredient.of(items));
    }

    @Override
    public ShapelessRecipeDisplayBuilder<CraftingRecipe> requires(Ingredient ingredient) {
        this.ingredients.add(ingredient);
        return this;
    }

    @Override
    public void save(ResourceKey<Recipe<?>> id) {
        this.generator.acceptCrafting((RecipeHolder<CraftingRecipe>)new RecipeHolder(id, (Recipe)new ShapelessRecipe("", CraftingBookCategory.MISC, this.result, this.ingredients)));
    }
}

