/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class SettingsTemplateStorage
extends SavedData {
    private static final SavedDataType<SettingsTemplateStorage> TYPE = new SavedDataType("sophisticatedcore_settings_templates", SettingsTemplateStorage::new, RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap((Codec)Codec.STRING.xmap(UUID::fromString, UUID::toString), (Codec)Codec.unboundedMap((Codec)ExtraCodecs.POSITIVE_INT, (Codec)CompoundTag.CODEC)).fieldOf("playerTemplates").forGetter(storage -> storage.playerTemplates), (App)Codec.unboundedMap((Codec)Codec.STRING.xmap(UUID::fromString, UUID::toString), (Codec)Codec.unboundedMap((Codec)ExtraCodecs.NON_EMPTY_STRING, (Codec)CompoundTag.CODEC)).fieldOf("playerNamedTemplates").forGetter(storage -> storage.playerNamedTemplates)).apply((Applicative)builder, SettingsTemplateStorage::new)));
    private Map<UUID, Map<Integer, CompoundTag>> playerTemplates = new HashMap<UUID, Map<Integer, CompoundTag>>();
    private Map<UUID, Map<String, CompoundTag>> playerNamedTemplates = new HashMap<UUID, Map<String, CompoundTag>>();
    private static final SettingsTemplateStorage clientStorageCopy = new SettingsTemplateStorage();

    private SettingsTemplateStorage() {
    }

    private SettingsTemplateStorage(Map<UUID, Map<Integer, CompoundTag>> playerTemplates, Map<UUID, Map<String, CompoundTag>> playerNamedTemplates) {
        this.playerTemplates = playerTemplates;
        this.playerNamedTemplates = playerNamedTemplates;
    }

    public void putPlayerTemplate(Player player, int slot, CompoundTag settingsTag) {
        this.playerTemplates.computeIfAbsent(player.getUUID(), u -> new HashMap()).put(slot, settingsTag);
        this.setDirty();
    }

    public void putPlayerNamedTemplate(Player player, String name, CompoundTag settingsTag) {
        this.playerNamedTemplates.computeIfAbsent(player.getUUID(), u -> new TreeMap()).put(name, settingsTag);
        this.setDirty();
    }

    public Map<Integer, CompoundTag> getPlayerTemplates(Player player) {
        return this.playerTemplates.getOrDefault(player.getUUID(), new HashMap());
    }

    public Map<String, CompoundTag> getPlayerNamedTemplates(Player player) {
        return this.playerNamedTemplates.getOrDefault(player.getUUID(), new TreeMap());
    }

    public static SettingsTemplateStorage get() {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.getLevel(Level.OVERWORLD);
            DimensionDataStorage storage = overworld.getDataStorage();
            return (SettingsTemplateStorage)storage.computeIfAbsent(TYPE);
        }
        return clientStorageCopy;
    }

    public void clearPlayerTemplates(Player player) {
        this.playerTemplates.remove(player.getUUID());
        this.playerNamedTemplates.remove(player.getUUID());
        this.setDirty();
    }
}

