/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui.utils;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.UV;

public class GuiHelper {
    public static final ResourceLocation GUI_CONTROLS = SophisticatedCore.getRL("textures/gui/gui_controls.png");
    public static final int GUI_CONTROLS_TEXTURE_WIDTH = 256;
    public static final int GUI_CONTROLS_TEXTURE_HEIGHT = 256;
    public static final TextureBlitData BAR_BACKGROUND_BOTTOM = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 66), Dimension.SQUARE_18);
    public static final TextureBlitData BAR_BACKGROUND_MIDDLE = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 48), Dimension.SQUARE_18);
    public static final TextureBlitData BAR_BACKGROUND_TOP = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 30), Dimension.SQUARE_18);
    public static final ResourceLocation ICONS = SophisticatedCore.getRL("textures/gui/icons.png");
    public static final TextureBlitData CRAFTING_RESULT_SLOT = new TextureBlitData(GUI_CONTROLS, new UV(71, 216), new Dimension(26, 26));
    public static final TextureBlitData DEFAULT_BUTTON_HOVERED_BACKGROUND = new TextureBlitData(GUI_CONTROLS, new UV(47, 0), Dimension.SQUARE_18);
    public static final TextureBlitData DEFAULT_BUTTON_BACKGROUND = new TextureBlitData(GUI_CONTROLS, new UV(29, 0), Dimension.SQUARE_18);
    public static final TextureBlitData SMALL_BUTTON_BACKGROUND = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 18), Dimension.SQUARE_12);
    public static final TextureBlitData SMALL_BUTTON_HOVERED_BACKGROUND = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(41, 18), Dimension.SQUARE_12);
    public static final ResourceLocation SLOTS_BACKGROUND = SophisticatedCore.getRL("textures/gui/slots_background.png");
    private static final Map<Integer, TextureBlitData> SLOTS_BACKGROUNDS = new HashMap<Integer, TextureBlitData>();

    private GuiHelper() {
    }

    public static void renderItemInGUI(GuiGraphics guiGraphics, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition) {
        GuiHelper.renderItemInGUI(guiGraphics, minecraft, stack, xPosition, yPosition, false);
    }

    public static void renderSlotsBackground(GuiGraphics guiGraphics, int x, int y, int slotWidth, int slotHeight) {
        int currentY = y;
        for (int remainingSlotHeight = slotHeight; remainingSlotHeight > 0; remainingSlotHeight -= Math.min(slotHeight, 12)) {
            int finalRemainingSlotHeight = remainingSlotHeight;
            int key = GuiHelper.getSlotsBackgroundKey(slotWidth, remainingSlotHeight);
            GuiHelper.blit(guiGraphics, x, currentY, SLOTS_BACKGROUNDS.computeIfAbsent(key, k -> new TextureBlitData(SLOTS_BACKGROUND, Dimension.SQUARE_256, new UV(0, 0), new Dimension(slotWidth * 18, finalRemainingSlotHeight * 18))));
            currentY += 216;
        }
    }

    private static int getSlotsBackgroundKey(int slotWidth, int slotHeight) {
        return slotWidth * 31 + slotHeight;
    }

    public static void renderItemInGUI(GuiGraphics guiGraphics, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition, boolean renderOverlay) {
        GuiHelper.renderItemInGUI(guiGraphics, minecraft, stack, xPosition, yPosition, renderOverlay, null);
    }

    public static void renderItemInGUI(GuiGraphics guiGraphics, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition, boolean renderOverlay, @Nullable String countText) {
        guiGraphics.renderItem(stack, xPosition, yPosition);
        if (renderOverlay) {
            guiGraphics.renderItemDecorations(minecraft.font, stack, xPosition, yPosition, countText);
        }
    }

    public static void blit(GuiGraphics guiGraphics, int x, int y, TextureBlitData texData) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texData.getTextureName(), x + texData.getXOffset(), y + texData.getYOffset(), (float)texData.getU(), (float)texData.getV(), texData.getWidth(), texData.getHeight(), texData.getTextureWidth(), texData.getTextureHeight());
    }

    public static void blit(GuiGraphics guiGraphics, int x, int y, TextureBlitData texData, int width, int height) {
        int halfWidth = width / 2;
        int secondHalfWidth = width - halfWidth;
        int halfHeight = height / 2;
        int secondHalfHeight = height - halfHeight;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texData.getTextureName(), x + texData.getXOffset(), y + texData.getYOffset(), (float)texData.getU(), (float)texData.getV(), halfWidth, halfHeight, texData.getTextureWidth(), texData.getTextureHeight());
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texData.getTextureName(), x + texData.getXOffset() + halfWidth, y + texData.getYOffset(), (float)texData.getU() + (float)texData.getWidth() - (float)secondHalfWidth, (float)texData.getV(), secondHalfWidth, halfHeight, texData.getTextureWidth(), texData.getTextureHeight());
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texData.getTextureName(), x + texData.getXOffset(), y + texData.getYOffset() + halfHeight, (float)texData.getU(), (float)texData.getV() + (float)texData.getHeight() - (float)secondHalfHeight, halfWidth, secondHalfHeight, texData.getTextureWidth(), texData.getTextureHeight());
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texData.getTextureName(), x + texData.getXOffset() + halfWidth, y + texData.getYOffset() + halfHeight, (float)texData.getU() + (float)texData.getWidth() - (float)secondHalfWidth, (float)texData.getV() + (float)texData.getHeight() - (float)secondHalfHeight, secondHalfWidth, secondHalfHeight, texData.getTextureWidth(), texData.getTextureHeight());
    }

    public static void coloredBlit(GuiGraphics guiGraphics, int x, int y, TextureBlitData texData, int color) {
        int xMin = x + texData.getXOffset();
        int yMin = y + texData.getYOffset();
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texData.getTextureName(), xMin, yMin, (float)texData.getU(), (float)texData.getV(), texData.getWidth(), texData.getHeight(), texData.getTextureWidth(), texData.getTextureHeight(), color);
    }

    public static void writeTooltipLines(GuiGraphics guiGraphics, List<FormattedCharSequence> textLines, Font font, int leftX, int topY, int color) {
        for (int i = 0; i < textLines.size(); ++i) {
            FormattedCharSequence line = textLines.get(i);
            if (line != null) {
                guiGraphics.drawString(font, line, leftX, topY, color, true);
            }
            if (i == 0) {
                topY += 2;
            }
            topY += 10;
        }
    }

    public static void fill(GuiGraphics guiGraphics, int minX, int minY, int maxX, int maxY, int color) {
        guiGraphics.fill(minX, minY, maxX, maxY, color);
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, Dimension dimension, Position offset, Component ... tooltip) {
        return GuiHelper.getButtonStateData(uv, dimension, offset, Arrays.asList(tooltip));
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, String tooltip, Dimension dimension) {
        return GuiHelper.getButtonStateData(uv, tooltip, dimension, new Position(0, 0));
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, String tooltip, Dimension dimension, Position offset) {
        return new ToggleButton.StateData(new TextureBlitData(ICONS, offset, Dimension.SQUARE_256, uv, dimension), new Component[]{Component.translatable((String)tooltip)});
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, Dimension dimension, Position offset, List<Component> tooltip) {
        return new ToggleButton.StateData(new TextureBlitData(ICONS, offset, Dimension.SQUARE_256, uv, dimension), tooltip);
    }

    public static void renderSlotsBackground(GuiGraphics guiGraphics, int x, int y, int slotsInRow, int fullSlotRows, int extraRowSlots) {
        GuiHelper.renderSlotsBackground(guiGraphics, x, y, slotsInRow, fullSlotRows);
        if (extraRowSlots > 0) {
            GuiHelper.renderSlotsBackground(guiGraphics, x, y + fullSlotRows * 18, extraRowSlots, 1);
        }
    }

    public static void renderTiledSprite(GuiGraphics guiGraphics, TextureAtlasSprite sprite, int color, int x, int y, int height) {
        int renderHeight;
        int spriteHeight = sprite.contents().height();
        int startY = y;
        int textureWidth = (int)((float)sprite.contents().width() / (sprite.getU1() - sprite.getU0()));
        int textureHeight = (int)((float)sprite.contents().height() / (sprite.getV1() - sprite.getV0()));
        do {
            renderHeight = Math.min(spriteHeight, height);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, sprite.atlasLocation(), x, startY, (float)textureWidth * sprite.getU0(), (float)textureHeight * sprite.getV0(), 16, renderHeight, textureWidth, textureHeight, color);
            startY += renderHeight;
        } while ((height -= renderHeight) > 0);
    }

    public static void renderControlBackground(GuiGraphics guiGraphics, int x, int y, int renderWidth, int renderHeight) {
        int u = 29;
        int v = 146;
        int textureBgWidth = 66;
        int textureBgHeight = 56;
        GuiHelper.renderControlBackground(guiGraphics, x, y, renderWidth, renderHeight, u, v, textureBgWidth, textureBgHeight);
    }

    public static void renderControlBackground(GuiGraphics guiGraphics, int x, int y, int renderWidth, int renderHeight, int u, int v, int textureBgWidth, int textureBgHeight) {
        int halfWidth = renderWidth / 2;
        int halfHeight = renderHeight / 2;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_CONTROLS, x, y, (float)u, (float)v, halfWidth, halfHeight, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_CONTROLS, x, y + halfHeight, (float)u, (float)v + (float)textureBgHeight - (float)halfHeight, halfWidth, halfHeight, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_CONTROLS, x + halfWidth, y, (float)u + (float)textureBgWidth - (float)halfWidth, (float)v, halfWidth, halfHeight, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_CONTROLS, x + halfWidth, y + halfHeight, (float)u + (float)textureBgWidth - (float)halfWidth, (float)v + (float)textureBgHeight - (float)halfHeight, halfWidth, halfHeight, 256, 256);
    }

    private static MultiBufferSource.BufferSource getBufferSource() {
        return Minecraft.getInstance().renderBuffers().bufferSource();
    }

    public static void renderTooltip(Screen screen, GuiGraphics guiGraphics, List<Component> components, int x, int y) {
        if (components.isEmpty()) {
            return;
        }
        List<ClientTooltipComponent> list = GuiHelper.gatherTooltipComponents(components, x, screen.width, screen.height, screen.getFont());
        guiGraphics.renderTooltip(screen.getFont(), list, x, y, DefaultTooltipPositioner.INSTANCE, null);
    }

    public static void renderTooltip(Screen screen, GuiGraphics guiGraphics, ItemStack tooltipStack, List<Component> components, Optional<TooltipComponent> tooltipComponent, int x, int y) {
        List list = ClientHooks.gatherTooltipComponents((ItemStack)tooltipStack, components, tooltipComponent, (int)x, (int)screen.width, (int)screen.height, (Font)screen.getFont());
        guiGraphics.renderTooltip(screen.getFont(), list, x, y, DefaultTooltipPositioner.INSTANCE, null);
    }

    public static List<ClientTooltipComponent> gatherTooltipComponents(List<? extends FormattedText> textElements, int mouseX, int screenWidth, int screenHeight, Font fallbackFont) {
        Font font = ClientHooks.getTooltipFont((ItemStack)ItemStack.EMPTY, (Font)fallbackFont);
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        RenderTooltipEvent.GatherComponents event = new RenderTooltipEvent.GatherComponents(ItemStack.EMPTY, screenWidth, screenHeight, elements, -1);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return List.of();
        }
        int tooltipX = mouseX + 12;
        int tooltipTextWidth = event.getTooltipElements().stream().mapToInt(either -> (Integer)either.map(arg_0 -> ((Font)font).width(arg_0), component -> 0)).max().orElse(0);
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
        }
        if (event.getMaxWidth() > 0 && tooltipTextWidth > event.getMaxWidth()) {
            tooltipTextWidth = event.getMaxWidth();
        }
        int tooltipTextWidthF = tooltipTextWidth;
        return event.getTooltipElements().stream().flatMap(either -> (Stream)either.map(text -> font.split(text, tooltipTextWidthF).stream().map(ClientTooltipComponent::create), component -> Stream.of(ClientTooltipComponent.create((TooltipComponent)component)))).toList();
    }

    public static Optional<Rect2i> getPositiveRectangle(int x, int y, int width, int height) {
        if (x + width <= 0 || y + height <= 0) {
            return Optional.empty();
        }
        int positiveX = Math.max(0, x);
        int positiveY = Math.max(0, y);
        int positiveWidth = width + Math.min(0, x);
        int positiveHeight = height + Math.min(0, y);
        return Optional.of(new Rect2i(positiveX, positiveY, positiveWidth, positiveHeight));
    }
}

