/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IAdditionalSlotInfoMenu;

public class SyncAdditionalSlotInfoMessage {
    private final Set<Integer> inaccessibleSlots;
    private final Map<Integer, Integer> slotLimitOverrides;
    private final Set<Integer> infiniteSlots;
    private final Map<Integer, Item> slotFilterItems;

    public SyncAdditionalSlotInfoMessage(Set<Integer> inaccessibleSlots, Map<Integer, Integer> slotLimitOverrides, Set<Integer> infiniteSlots, Map<Integer, Item> slotFilterItems) {
        this.inaccessibleSlots = inaccessibleSlots;
        this.slotLimitOverrides = slotLimitOverrides;
        this.slotFilterItems = slotFilterItems;
        this.infiniteSlots = infiniteSlots;
    }

    public static void encode(SyncAdditionalSlotInfoMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130089_(msg.inaccessibleSlots.stream().mapToInt(i -> i).toArray());
        SyncAdditionalSlotInfoMessage.serializeSlotLimitOverrides(packetBuffer, msg.slotLimitOverrides);
        packetBuffer.m_130089_(msg.infiniteSlots.stream().mapToInt(i -> i).toArray());
        SyncAdditionalSlotInfoMessage.serializeSlotFilterItems(packetBuffer, msg.slotFilterItems);
    }

    public static SyncAdditionalSlotInfoMessage decode(FriendlyByteBuf packetBuffer) {
        return new SyncAdditionalSlotInfoMessage(Arrays.stream(packetBuffer.m_130100_()).boxed().collect(Collectors.toSet()), SyncAdditionalSlotInfoMessage.deserializeSlotLimitOverrides(packetBuffer), Arrays.stream(packetBuffer.m_130100_()).boxed().collect(Collectors.toSet()), SyncAdditionalSlotInfoMessage.deserializeSlotFilterItems(packetBuffer));
    }

    private static void serializeSlotFilterItems(FriendlyByteBuf packetBuffer, Map<Integer, Item> slotFilterItems) {
        packetBuffer.writeInt(slotFilterItems.size());
        slotFilterItems.forEach((slot, item) -> {
            packetBuffer.writeInt(slot.intValue());
            packetBuffer.writeInt(Item.m_41393_((Item)item));
        });
    }

    private static Map<Integer, Item> deserializeSlotFilterItems(FriendlyByteBuf packetBuffer) {
        HashMap<Integer, Item> ret = new HashMap<Integer, Item>();
        int size = packetBuffer.readInt();
        for (int i = 0; i < size; ++i) {
            ret.put(packetBuffer.readInt(), Item.m_41445_((int)packetBuffer.readInt()));
        }
        return ret;
    }

    private static Map<Integer, Integer> deserializeSlotLimitOverrides(FriendlyByteBuf packetBuffer) {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        int size = packetBuffer.readInt();
        for (int i = 0; i < size; ++i) {
            ret.put(packetBuffer.readInt(), packetBuffer.readInt());
        }
        return ret;
    }

    private static void serializeSlotLimitOverrides(FriendlyByteBuf packetBuffer, Map<Integer, Integer> slotLimitOverrides) {
        packetBuffer.writeInt(slotLimitOverrides.size());
        slotLimitOverrides.forEach((slot, limit) -> {
            packetBuffer.writeInt(slot.intValue());
            packetBuffer.writeInt(limit.intValue());
        });
    }

    public static void onMessage(SyncAdditionalSlotInfoMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SyncAdditionalSlotInfoMessage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(SyncAdditionalSlotInfoMessage msg) {
        AbstractContainerMenu abstractContainerMenu;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !((abstractContainerMenu = player.f_36096_) instanceof IAdditionalSlotInfoMenu)) {
            return;
        }
        IAdditionalSlotInfoMenu menu = (IAdditionalSlotInfoMenu)abstractContainerMenu;
        menu.updateAdditionalSlotInfo(msg.inaccessibleSlots, msg.slotLimitOverrides, msg.infiniteSlots, msg.slotFilterItems);
    }
}

