/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class ClientRecipeHelper {
    private ClientRecipeHelper() {
    }

    public static <I extends RecipeInput, T extends Recipe<I>, U extends Recipe<?>> List<RecipeHolder<T>> transformAllRecipesOfType(RecipeType<T> recipeType, Class<U> filterRecipeClass, Function<U, T> transformRecipe) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return Collections.emptyList();
        }
        return level.getRecipeManager().getAllRecipesFor(recipeType).stream().filter(r -> filterRecipeClass.isInstance(r.value())).map(r -> new RecipeHolder(r.id(), (Recipe)transformRecipe.apply((Recipe)filterRecipeClass.cast(r.value())))).toList();
    }

    public static <I extends RecipeInput, T extends Recipe<I>, U extends Recipe<?>> List<RecipeHolder<T>> transformAllRecipesOfTypeIntoMultiple(RecipeType<T> recipeType, Class<U> filterRecipeClass, Function<U, List<RecipeHolder<T>>> transformRecipe) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return Collections.emptyList();
        }
        return level.getRecipeManager().getAllRecipesFor(recipeType).stream().filter(r -> filterRecipeClass.isInstance(r.value())).map(r -> (List)transformRecipe.apply((Recipe)filterRecipeClass.cast(r.value()))).collect(ArrayList::new, List::addAll, List::addAll);
    }

    public static CraftingRecipe copyShapedRecipe(ShapedRecipe recipe) {
        return new ShapedRecipe("", recipe.category(), recipe.pattern, RecipeUtil.getResultItem((Recipe)recipe));
    }

    public static CraftingRecipe copyShapelessRecipe(ShapelessRecipe recipe) {
        return new ShapelessRecipe("", recipe.category(), RecipeUtil.getResultItem((Recipe)recipe), recipe.getIngredients());
    }

    public static <I extends RecipeInput> ItemStack assemble(Recipe<I> recipe, I container) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.registryAccess();
        return recipe.assemble(container, (HolderLookup.Provider)registryAccess);
    }
}

