/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.render;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.p3pp3rf1y.sophisticatedcore.api.IUpgradeClientTickHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeClientData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeClientDataType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeClientData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeClientTickHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeClientData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeClientTickHandler;

public class UpgradeClientRegistry {
    private static final Map<UpgradeClientDataType<?>, IUpgradeClientTickHandler<?>> UPGRADE_RENDERERS = new HashMap();

    private UpgradeClientRegistry() {
    }

    private static <T extends IUpgradeClientData> void registerUpgradeRenderer(UpgradeClientDataType<T> upgradeClientDataType, IUpgradeClientTickHandler<T> upgradeRenderer) {
        UPGRADE_RENDERERS.put(upgradeClientDataType, upgradeRenderer);
    }

    public static <T extends IUpgradeClientData> Optional<IUpgradeClientTickHandler<T>> getUpgradeClientTickHandler(UpgradeClientDataType<T> upgradeClientDataType) {
        return Optional.ofNullable(UPGRADE_RENDERERS.get(upgradeClientDataType));
    }

    static {
        UpgradeClientRegistry.registerUpgradeRenderer(CookingUpgradeClientData.TYPE, new CookingUpgradeClientTickHandler());
        UpgradeClientRegistry.registerUpgradeRenderer(JukeboxUpgradeClientData.TYPE, new JukeboxUpgradeClientTickHandler());
    }
}

