/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.common.gui;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.network.SyncDatapackSettingsTemplatePayload;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.settings.DatapackSettingsTemplateManager;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsTemplateStorage;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;

public class TemplatePersistanceContainer {
    private static final Pattern EXPORT_FILE_NAME_PATTERN = Pattern.compile("[A-Za-z0-9_\\-\\s]+");
    private static final int TOTAL_ORDINAL_SAVE_SLOTS = 10;
    private static final String ACTION_TAG = "action";
    private static final String SAVE_SLOT_TAG = "saveSlot";
    private static final String LOAD_SLOT_TAG = "loadSlot";
    static final String TEMPLATE_PERSISTANCE_TAG = "templatePersistance";
    private final SettingsContainerMenu<?> settingsContainer;
    private final RegistryAccess registryAccess;
    private final List<IPersistanceSlot> saveSlots = new ArrayList<IPersistanceSlot>();
    private int saveSlotIndex = 0;
    private final List<IPersistanceSlot> loadSlots = new ArrayList<IPersistanceSlot>();
    private int loadSlotIndex = -1;
    @Nullable
    private TemplateSettingsHandler selectedTemplate;
    private Runnable onSlotsRefreshed = () -> {};

    public TemplatePersistanceContainer(SettingsContainerMenu<?> settingsContainer, RegistryAccess registryAccess) {
        this.settingsContainer = settingsContainer;
        this.registryAccess = registryAccess;
        this.initSlots();
    }

    public void setOnSlotsRefreshed(Runnable onSlotsRefreshed) {
        this.onSlotsRefreshed = onSlotsRefreshed;
    }

    private void initSlots() {
        int i;
        this.saveSlots.clear();
        for (i = 0; i < this.getNumberOfSaves(); ++i) {
            this.saveSlots.add(new OrdinalPersistanceSlot(i + 1));
        }
        if (i < 9) {
            this.saveSlots.add(new OrdinalPersistanceSlot(i + 1));
        }
        this.getNamedSaves().forEach(name -> this.saveSlots.add(new NamedPersistanceSlot((String)name)));
        this.saveSlots.add(new EditNamePersistanceSlot(""));
        this.loadSlots.clear();
        for (i = 0; i < this.getNumberOfSaves(); ++i) {
            this.loadSlots.add(new OrdinalPersistanceSlot(i + 1));
        }
        this.getNamedSaves().forEach(name -> this.loadSlots.add(new NamedPersistanceSlot((String)name)));
        DatapackSettingsTemplateManager.getTemplates().forEach((datapackName, templates) -> templates.forEach((templateName, templateNbt) -> this.loadSlots.add(new DatapackSlot((String)datapackName, (String)templateName))));
        if (this.loadSlotIndex == -1 && !this.loadSlots.isEmpty()) {
            this.loadSlotIndex = 0;
        } else if (this.loadSlotIndex != -1 && this.loadSlots.isEmpty()) {
            this.loadSlotIndex = -1;
        }
        this.updateSelectedTemplate();
        this.onSlotsRefreshed.run();
    }

    public void handlePacket(CompoundTag data) {
        data.getString(ACTION_TAG).ifPresent(action -> {
            switch (action) {
                case "saveTemplate": {
                    data.getString("slotName").ifPresent(this::saveTemplate);
                    break;
                }
                case "loadTemplate": {
                    this.loadTemplate();
                    break;
                }
                case "exportTemplate": {
                    data.getString("fileName").ifPresent(this::exportTemplate);
                }
            }
        });
        data.getBoolean(SAVE_SLOT_TAG).ifPresent(this::scrollSaveSlot);
        data.getBoolean(LOAD_SLOT_TAG).ifPresent(this::scrollLoadSlot);
    }

    private void sendDataToServer(Supplier<CompoundTag> compoundSupplier) {
        this.settingsContainer.sendDataToServer(() -> {
            CompoundTag compound = new CompoundTag();
            compound.put(TEMPLATE_PERSISTANCE_TAG, (Tag)compoundSupplier.get());
            return compound;
        });
    }

    private Player getPlayer() {
        return this.settingsContainer.getPlayer();
    }

    public void loadTemplate() {
        if (this.selectedTemplate == null) {
            return;
        }
        this.settingsContainer.getStorageWrapper().getSettingsHandler().getSettingsCategories().values().forEach(category -> this.overwriteCategory(category.getClass(), (ISettingsCategory<?>)category, (ISettingsCategory<?>)this.selectedTemplate.getTypeCategory(category.getClass())));
        this.sendDataToServer(() -> NBTHelper.putString(new CompoundTag(), ACTION_TAG, "loadTemplate"));
        if (this.getPlayer().level().isClientSide()) {
            this.getPlayer().displayClientMessage((Component)Component.translatable((String)TranslationHelper.INSTANCE.translSettingsMessage("load_template"), (Object[])new Object[]{this.loadSlots.get(this.loadSlotIndex).getSlotName()}), false);
        }
    }

    private <T extends ISettingsCategory<T>> void overwriteCategory(Class<T> categoryClazz, ISettingsCategory<?> currentCategory, ISettingsCategory<?> otherCategory) {
        currentCategory.overwriteWith(otherCategory);
    }

    public void saveTemplate(String slotName) {
        SettingsTemplateStorage settingsTemplateStorage = SettingsTemplateStorage.get();
        IPersistanceSlot saveSlot = this.saveSlots.get(this.saveSlotIndex);
        saveSlot.setSlotName(slotName);
        saveSlot.persistTo(this.getPlayer(), settingsTemplateStorage, this.settingsContainer.getStorageWrapper().getSettingsHandler().getNbt().copy());
        this.sendDataToServer(() -> NBTHelper.putString(NBTHelper.putString(new CompoundTag(), ACTION_TAG, "saveTemplate"), "slotName", slotName));
        this.initSlots();
        this.moveSaveSlotIndexTo(saveSlot.getSlotName());
        if (this.getPlayer().level().isClientSide()) {
            this.getPlayer().displayClientMessage((Component)Component.translatable((String)TranslationHelper.INSTANCE.translSettingsMessage("save_template"), (Object[])new Object[]{saveSlot.getSlotName()}), false);
        }
    }

    private void moveSaveSlotIndexTo(String slotName) {
        for (int i = 0; i < this.saveSlots.size(); ++i) {
            if (!this.saveSlots.get(i).getSlotName().equals(slotName)) continue;
            this.saveSlotIndex = i;
            break;
        }
    }

    public void scrollSaveSlot(boolean next) {
        this.saveSlotIndex += next ? 1 : -1;
        if (this.saveSlotIndex < 0) {
            this.saveSlotIndex = this.saveSlots.size() - 1;
        }
        if (this.saveSlotIndex >= this.saveSlots.size()) {
            this.saveSlotIndex = 0;
        }
        this.sendDataToServer(() -> NBTHelper.putBoolean(new CompoundTag(), SAVE_SLOT_TAG, next));
    }

    public void scrollLoadSlot(boolean next) {
        if (this.loadSlots.isEmpty()) {
            this.loadSlotIndex = -1;
            return;
        }
        this.loadSlotIndex += next ? 1 : -1;
        if (this.loadSlotIndex < 0) {
            this.loadSlotIndex = this.loadSlots.size() - 1;
        }
        if (this.loadSlotIndex >= this.loadSlots.size()) {
            this.loadSlotIndex = 0;
        }
        this.updateSelectedTemplate();
        this.sendDataToServer(() -> NBTHelper.putBoolean(new CompoundTag(), LOAD_SLOT_TAG, next));
    }

    private void updateSelectedTemplate() {
        if (this.loadSlotIndex > -1 && this.loadSlotIndex < this.loadSlots.size()) {
            CompoundTag settingsTag = this.loadSlots.get(this.loadSlotIndex).getSettingsNbt(this.getPlayer(), SettingsTemplateStorage.get());
            this.selectedTemplate = new TemplateSettingsHandler(settingsTag, this.registryAccess){

                @Override
                protected SettingsHandler getCurrentSettingsHandler() {
                    return TemplatePersistanceContainer.this.settingsContainer.getStorageWrapper().getSettingsHandler();
                }
            };
        }
    }

    public MutableComponent getSaveSlotTooltipName() {
        return this.saveSlots.get(this.saveSlotIndex).getSlotTooltipName();
    }

    public MutableComponent getLoadSlotTooltipName() {
        return this.loadSlots.get(this.loadSlotIndex).getSlotTooltipName();
    }

    public int getLoadSlot() {
        return this.loadSlotIndex;
    }

    private int getNumberOfSaves() {
        return SettingsTemplateStorage.get().getPlayerTemplates(this.settingsContainer.getPlayer()).size();
    }

    private List<String> getNamedSaves() {
        return new ArrayList<String>(SettingsTemplateStorage.get().getPlayerNamedTemplates(this.settingsContainer.getPlayer()).keySet());
    }

    public Optional<TemplateSettingsHandler> getSelectedTemplate() {
        return Optional.ofNullable(this.selectedTemplate);
    }

    public boolean showsTextbox() {
        return this.saveSlots.get(this.saveSlotIndex).showsTextbox();
    }

    public void refreshTemplateSlots() {
        this.initSlots();
        this.onSlotsRefreshed.run();
    }

    public void exportTemplate(String fileName) {
        if (fileName.isEmpty()) {
            this.getPlayer().displayClientMessage((Component)Component.translatable((String)TranslationHelper.INSTANCE.translSettingsMessage("export_template.empty_name")).withStyle(ChatFormatting.RED), false);
            return;
        }
        Matcher matcher = EXPORT_FILE_NAME_PATTERN.matcher(fileName);
        if (!matcher.matches()) {
            this.getPlayer().displayClientMessage((Component)Component.translatable((String)TranslationHelper.INSTANCE.translSettingsMessage("export_template.invalid_characters"), (Object[])new Object[]{TemplatePersistanceContainer.findNonMatchingCharacters(matcher, fileName)}).withStyle(ChatFormatting.RED), false);
            return;
        }
        fileName = fileName.replace(' ', '_');
        String finalFileName = fileName = fileName.toLowerCase(Locale.ROOT);
        this.sendDataToServer(() -> NBTHelper.putString(NBTHelper.putString(new CompoundTag(), ACTION_TAG, "exportTemplate"), "fileName", finalFileName));
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            Path templatesDir;
            String playersFolder;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerLevel serverLevel = serverPlayer.serverLevel();
            Path datapacksDir = serverLevel.getServer().getWorldPath(LevelResource.DATAPACK_DIR);
            Path datapackRoot = datapacksDir.resolve(playersFolder = this.getPlayer().getScoreboardName().toLowerCase(Locale.ROOT) + "_soph_templates");
            if (!TemplatePersistanceContainer.initDatapackStructure(datapackRoot, templatesDir = datapackRoot.resolve("data/" + playersFolder + "/sophisticated_settingstemplates"))) {
                return;
            }
            Path exportPath = templatesDir.resolve(fileName + ".snbt");
            CompoundTag settingsNbt = this.settingsContainer.getStorageWrapper().getSettingsHandler().getNbt().copy();
            try {
                NbtToSnbt.writeSnbt((CachedOutput)CachedOutput.NO_CACHE, (Path)exportPath, (String)new SnbtPrinterTagVisitor().visit((Tag)settingsNbt));
            }
            catch (IOException e) {
                SophisticatedCore.LOGGER.error("Error writing template export", (Throwable)e);
                return;
            }
            DatapackSettingsTemplateManager.putTemplate(playersFolder, fileName, settingsNbt);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncDatapackSettingsTemplatePayload(playersFolder, fileName, settingsNbt), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.initSlots();
            this.getPlayer().displayClientMessage((Component)Component.translatable((String)TranslationHelper.INSTANCE.translSettingsMessage("export_template"), (Object[])new Object[]{serverLevel.getServer().getWorldPath(LevelResource.ROOT).relativize(exportPath).toString()}), false);
        }
    }

    public static String findNonMatchingCharacters(Matcher matcher, String input) {
        StringBuilder nonMatchingCharacters = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (matcher.reset(String.valueOf(c)).matches()) continue;
            nonMatchingCharacters.append(c);
        }
        return nonMatchingCharacters.toString();
    }

    public boolean templateHasTooManySlots() {
        return this.selectedTemplate != null && this.selectedTemplate.getSettingsCategories().values().stream().anyMatch(category -> category.isLargerThanNumberOfSlots(this.settingsContainer.getStorageWrapper().getInventoryHandler().getSlots()));
    }

    private static boolean initDatapackStructure(Path datapackRoot, Path templatesDir) {
        try {
            Files.createDirectories(templatesDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            SophisticatedCore.LOGGER.error("Error creating directory for template export", (Throwable)e);
            return false;
        }
        Path packMcmetaFile = datapackRoot.resolve("pack.mcmeta");
        if (!Files.exists(packMcmetaFile, new LinkOption[0])) {
            try {
                Files.writeString(packMcmetaFile, (CharSequence)"{\n    \"pack\": {\n        \"pack_format\": 15,\n        \"description\": \"Sophisticated Settings Templates data pack\"\n    }\n}\n", new OpenOption[0]);
            }
            catch (IOException e) {
                SophisticatedCore.LOGGER.error("Error creating pack.mcmeta for template export", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public Optional<String> getLoadSlotSource() {
        return this.loadSlots.get(this.loadSlotIndex).getSlotSource();
    }

    private static class OrdinalPersistanceSlot
    implements IPersistanceSlot {
        private final int slot;

        public OrdinalPersistanceSlot(int slot) {
            this.slot = slot;
        }

        @Override
        public String getName() {
            return "ordinal";
        }

        @Override
        public String getSlotName() {
            return String.valueOf(this.slot);
        }

        @Override
        public void serialize(CompoundTag tag) {
            IPersistanceSlot.super.serialize(tag);
            tag.putInt("slot", this.slot);
        }

        @Override
        public void persistTo(Player player, SettingsTemplateStorage settingsTemplateStorage, CompoundTag settingsCopy) {
            settingsTemplateStorage.putPlayerTemplate(player, this.slot, settingsCopy);
        }

        @Override
        public CompoundTag getSettingsNbt(Player player, SettingsTemplateStorage settingsTemplateStorage) {
            return settingsTemplateStorage.getPlayerTemplates(player).getOrDefault(this.slot, new CompoundTag());
        }
    }

    private static class EditNamePersistanceSlot
    extends NamedPersistanceSlot {
        public EditNamePersistanceSlot(String slotName) {
            super(slotName);
        }

        @Override
        public boolean showsTextbox() {
            return true;
        }

        @Override
        public void setSlotName(String slotName) {
            this.slotName = slotName;
        }

        @Override
        public MutableComponent getSlotTooltipName() {
            return Component.translatable((String)TranslationHelper.INSTANCE.translSettingsButton("save_template.custom_name_slot"));
        }
    }

    public static abstract class TemplateSettingsHandler
    extends SettingsHandler {
        protected TemplateSettingsHandler(CompoundTag contentsNbt, RegistryAccess registryAccess) {
            super(contentsNbt, () -> {}, NoopStorageWrapper.INSTANCE::getInventoryHandler, NoopStorageWrapper.INSTANCE::getRenderInfo);
        }

        protected abstract SettingsHandler getCurrentSettingsHandler();

        @Override
        protected CompoundTag getSettingsNbtFromContentsNbt(CompoundTag contentsNbt) {
            return contentsNbt;
        }

        @Override
        protected void addItemDisplayCategory(Supplier<InventoryHandler> inventoryHandlerSupplier, Supplier<RenderInfo> renderInfoSupplier, CompoundTag settingsNbt) {
            int itemNumberLimit = this.getCurrentSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class).getItemNumberLimit();
            this.addSettingsCategory(settingsNbt, "item_display", this.markContentsDirty, (categoryNbt, saveNbt) -> new ItemDisplaySettingsCategory(inventoryHandlerSupplier, renderInfoSupplier, (CompoundTag)categoryNbt, (Consumer<CompoundTag>)saveNbt, itemNumberLimit, () -> this.getTypeCategory(MemorySettingsCategory.class)));
        }

        @Override
        public String getGlobalSettingsCategoryName() {
            return this.getCurrentSettingsHandler().getGlobalSettingsCategoryName();
        }

        @Override
        public ISettingsCategory<?> instantiateGlobalSettingsCategory(CompoundTag categoryNbt, Consumer<CompoundTag> saveNbt) {
            return this.getCurrentSettingsHandler().instantiateGlobalSettingsCategory(categoryNbt, saveNbt);
        }

        @Override
        protected void saveCategoryNbt(CompoundTag settingsNbt, String categoryName, CompoundTag tag) {
        }
    }

    private static interface IPersistanceSlot {
        public String getName();

        public String getSlotName();

        default public void serialize(CompoundTag tag) {
            tag.putString("name", this.getName());
        }

        default public void persistTo(Player player, SettingsTemplateStorage settingsTemplateStorage, CompoundTag settingsCopy) {
        }

        default public boolean showsTextbox() {
            return false;
        }

        default public void setSlotName(String slotName) {
        }

        default public MutableComponent getSlotTooltipName() {
            return Component.literal((String)this.getSlotName());
        }

        public CompoundTag getSettingsNbt(Player var1, SettingsTemplateStorage var2);

        default public Optional<String> getSlotSource() {
            return Optional.empty();
        }
    }

    private static class DatapackSlot
    implements IPersistanceSlot {
        private final String datapackName;
        private final String templateName;

        public DatapackSlot(String datapackName, String templateName) {
            this.datapackName = datapackName;
            this.templateName = templateName;
        }

        @Override
        public String getName() {
            return "datapack";
        }

        @Override
        public String getSlotName() {
            return this.templateName;
        }

        @Override
        public CompoundTag getSettingsNbt(Player player, SettingsTemplateStorage settingsTemplateStorage) {
            return DatapackSettingsTemplateManager.getTemplateNbt(this.datapackName, this.templateName).orElseGet(CompoundTag::new);
        }

        @Override
        public Optional<String> getSlotSource() {
            return Optional.of(this.datapackName);
        }
    }

    private static class NamedPersistanceSlot
    implements IPersistanceSlot {
        protected String slotName;

        public NamedPersistanceSlot(String slotName) {
            this.slotName = slotName;
        }

        @Override
        public String getName() {
            return "named";
        }

        @Override
        public String getSlotName() {
            return this.slotName;
        }

        @Override
        public void serialize(CompoundTag tag) {
            IPersistanceSlot.super.serialize(tag);
            tag.putString("slot", this.slotName);
        }

        @Override
        public void persistTo(Player player, SettingsTemplateStorage settingsTemplateStorage, CompoundTag settingsCopy) {
            settingsTemplateStorage.putPlayerNamedTemplate(player, this.slotName, settingsCopy);
        }

        @Override
        public CompoundTag getSettingsNbt(Player player, SettingsTemplateStorage settingsTemplateStorage) {
            return settingsTemplateStorage.getPlayerNamedTemplates(player).getOrDefault(this.slotName, new CompoundTag());
        }
    }
}

