/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.jei;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.library.plugins.vanilla.crafting.JeiShapedRecipe;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.ShapedRecipeDisplayBuilder;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.jei.JeiRecipeDisplayGenerator;

public class JeiShapedRecipeDisplayBuilder
extends ShapedRecipeDisplayBuilder<CraftingRecipe> {
    private final JeiRecipeDisplayGenerator generator;
    private final SlotDisplay result;
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Map<Character, SlotDisplay> displayKey = Maps.newLinkedHashMap();
    private List<Optional<Ingredient>> ingredients = new ArrayList<Optional<Ingredient>>();
    private List<SlotDisplay> displays = new ArrayList<SlotDisplay>();
    private final HolderGetter<Item> items;

    public JeiShapedRecipeDisplayBuilder(HolderGetter<Item> items, JeiRecipeDisplayGenerator generator, ItemStack result) {
        this.items = items;
        this.generator = generator;
        this.result = new SlotDisplay.ItemStackSlotDisplay(result);
    }

    public JeiShapedRecipeDisplayBuilder define(Character symbol, TagKey<Item> tag) {
        Ingredient ingredient = Ingredient.of((HolderSet)this.items.getOrThrow(tag));
        return this.define(symbol, ingredient, ingredient.display());
    }

    public JeiShapedRecipeDisplayBuilder define(Character symbol, ItemLike item) {
        Ingredient ingredient = Ingredient.of((ItemLike)item);
        return this.define(symbol, ingredient, ingredient.display());
    }

    public JeiShapedRecipeDisplayBuilder define(Character symbol, ItemStack itemStack) {
        return this.define(symbol, Ingredient.of((ItemLike)itemStack.getItem()), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(itemStack));
    }

    @Override
    public ShapedRecipeDisplayBuilder<CraftingRecipe> define(Character symbol, List<ItemStack> itemStacks) {
        return this.define(symbol, Ingredient.of((ItemLike)(itemStacks.isEmpty() ? Items.AIR : itemStacks.getFirst().getItem())), (SlotDisplay)new SlotDisplay.Composite(itemStacks.stream().map(SlotDisplay.ItemStackSlotDisplay::new).map(SlotDisplay.class::cast).toList()));
    }

    @Override
    public ShapedRecipeDisplayBuilder<CraftingRecipe> setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public ShapedRecipeDisplayBuilder<CraftingRecipe> define(HolderSet<Item> items) {
        if (items.size() > 0) {
            Ingredient ingredient = Ingredient.of(items);
            this.ingredients.add(Optional.of(ingredient));
            this.displays.add(ingredient.display());
        } else {
            this.ingredients.add(Optional.empty());
            this.displays.add((SlotDisplay)SlotDisplay.Empty.INSTANCE);
        }
        return this;
    }

    @Override
    public ShapedRecipeDisplayBuilder<CraftingRecipe> define(ItemStack itemStack) {
        this.ingredients.add(Optional.of(Ingredient.of((ItemLike)itemStack.getItem())));
        this.displays.add((SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(itemStack));
        return this;
    }

    private JeiShapedRecipeDisplayBuilder define(Character symbol, Ingredient ingredient, SlotDisplay slotDisplay) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(symbol, ingredient);
        this.displayKey.put(symbol, slotDisplay);
        return this;
    }

    @Override
    public void save(ResourceKey<Recipe<?>> id) {
        List<SlotDisplay> displays;
        ShapedRecipePattern pattern;
        if (this.ingredients.isEmpty()) {
            pattern = ShapedRecipePattern.of(this.key, (List)this.rows);
            displays = (List<SlotDisplay>)this.unpack(this.displayKey, SlotDisplay.Empty.INSTANCE).getOrThrow();
        } else {
            pattern = new ShapedRecipePattern(this.width, this.height, this.ingredients, Optional.empty());
            displays = this.displays;
        }
        this.generator.acceptCrafting((RecipeHolder<CraftingRecipe>)new RecipeHolder(id, (Recipe)new JeiShapedRecipe("", CraftingBookCategory.MISC, pattern, displays, this.result)));
    }
}

