/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.pump;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.FluidFilterContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeWrapper;

public class PumpUpgradeContainer
extends UpgradeContainerBase<PumpUpgradeWrapper, PumpUpgradeContainer> {
    private static final String DATA_IS_INPUT = "isInput";
    private static final String DATA_INTERACT_WITH_HAND = "interactWithHand";
    private static final String DATA_INTERACT_WITH_WORLD = "interactWithWorld";
    public static final String DATA_INTERACT_WITH_FLUID_HANDLERS = "interactWithFluidHandlers";
    private final FluidFilterContainer fluidFilterContainer;

    public PumpUpgradeContainer(Player player, int upgradeContainerId, PumpUpgradeWrapper upgradeWrapper, UpgradeContainerType<PumpUpgradeWrapper, PumpUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
        this.fluidFilterContainer = new FluidFilterContainer(player, this, upgradeWrapper::getFluidFilterLogic);
    }

    public void setIsInput(boolean input) {
        ((PumpUpgradeWrapper)this.upgradeWrapper).setIsInput(input);
        this.sendBooleanToServer(DATA_IS_INPUT, input);
    }

    public boolean isInput() {
        return ((PumpUpgradeWrapper)this.upgradeWrapper).isInput();
    }

    @Override
    public void handlePacket(CompoundTag data) {
        data.getBoolean(DATA_IS_INPUT).ifPresent(this::setIsInput);
        data.getBoolean(DATA_INTERACT_WITH_HAND).ifPresent(this::setInteractWithHand);
        data.getBoolean(DATA_INTERACT_WITH_WORLD).ifPresent(this::setInteractWithWorld);
        data.getBoolean(DATA_INTERACT_WITH_FLUID_HANDLERS).ifPresent(this::setInteractWithFluidHandlers);
        this.fluidFilterContainer.handlePacket(data);
    }

    public FluidFilterContainer getFluidFilterContainer() {
        return this.fluidFilterContainer;
    }

    public void setInteractWithHand(boolean interactWithHand) {
        ((PumpUpgradeWrapper)this.upgradeWrapper).setInteractWithHand(interactWithHand);
        this.sendBooleanToServer(DATA_INTERACT_WITH_HAND, interactWithHand);
    }

    public boolean shouldInteractWithHand() {
        return ((PumpUpgradeWrapper)this.upgradeWrapper).shouldInteractWithHand();
    }

    public void setInteractWithWorld(boolean interactWithWorld) {
        ((PumpUpgradeWrapper)this.upgradeWrapper).setInteractWithWorld(interactWithWorld);
        this.sendBooleanToServer(DATA_INTERACT_WITH_WORLD, interactWithWorld);
    }

    public boolean shouldInteractWithWorld() {
        return ((PumpUpgradeWrapper)this.upgradeWrapper).shouldInteractWithWorld();
    }

    public void setInteractWithFluidHandlers(boolean interact) {
        ((PumpUpgradeWrapper)this.upgradeWrapper).setInteractWithFluidHandlers(interact);
        this.sendBooleanToServer(DATA_INTERACT_WITH_FLUID_HANDLERS, interact);
    }

    public boolean shouldInteractWithFluidHandlers() {
        return ((PumpUpgradeWrapper)this.upgradeWrapper).shouldInteractWithFluidHandlers();
    }
}

