/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.memory;

import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;

public class MemorySettingsContainer
extends SettingsContainerBase<MemorySettingsCategory> {
    private static final String ACTION_TAG = "action";
    private static final String SELECT_ALL_ACTION = "selectAll";
    private static final String UNSELECT_ALL_ACTION = "unselectAll";
    private static final String UNSELECT_SLOT_TAG = "unselectSlot";
    private static final String SELECT_SLOT_TAG = "selectSlot";
    private static final String IGNORE_NBT_TAG = "ignoreNbt";

    public MemorySettingsContainer(SettingsContainerMenu<?> settingsContainer, String categoryName, MemorySettingsCategory category) {
        super(settingsContainer, categoryName, category);
    }

    @Override
    public void handlePacket(CompoundTag data) {
        if (data.contains(ACTION_TAG)) {
            switch (data.getString(ACTION_TAG)) {
                case "selectAll": {
                    this.selectAllSlots();
                    break;
                }
                case "unselectAll": {
                    this.unselectAllSlots();
                    break;
                }
            }
        } else if (data.contains(SELECT_SLOT_TAG)) {
            this.selectSlot(data.getInt(SELECT_SLOT_TAG));
        } else if (data.contains(UNSELECT_SLOT_TAG)) {
            this.unselectSlot(data.getInt(UNSELECT_SLOT_TAG));
        } else if (data.contains(IGNORE_NBT_TAG)) {
            this.setIgnoreNbt(data.getBoolean(IGNORE_NBT_TAG));
        }
    }

    public void unselectSlot(int slotNumber) {
        if (!this.isSlotSelected(slotNumber)) {
            return;
        }
        if (this.isServer()) {
            ((MemorySettingsCategory)this.getCategory()).unselectSlot(slotNumber);
            this.getSettingsContainer().onMemorizedStackRemoved(slotNumber);
        } else {
            this.sendIntToServer(UNSELECT_SLOT_TAG, slotNumber);
        }
    }

    public void selectSlot(int slotNumber) {
        if (this.isSlotSelected(slotNumber)) {
            return;
        }
        if (this.isServer()) {
            ((MemorySettingsCategory)this.getCategory()).selectSlot(slotNumber);
            this.getSettingsContainer().onMemorizedStackAdded(slotNumber);
        } else {
            this.sendIntToServer(SELECT_SLOT_TAG, slotNumber);
        }
    }

    public void unselectAllSlots() {
        if (this.isServer()) {
            Set<Integer> selectedSlots = ((MemorySettingsCategory)this.getCategory()).getSlotIndexes();
            ((MemorySettingsCategory)this.getCategory()).unselectAllSlots();
            selectedSlots.forEach(slotNumber -> this.getSettingsContainer().onMemorizedStackRemoved((int)slotNumber));
        } else {
            this.sendStringToServer(ACTION_TAG, UNSELECT_ALL_ACTION);
        }
    }

    public void selectAllSlots() {
        if (this.isServer()) {
            ((MemorySettingsCategory)this.getCategory()).selectSlots(0, this.getSettingsContainer().getNumberOfSlots());
        } else {
            this.sendStringToServer(ACTION_TAG, SELECT_ALL_ACTION);
        }
    }

    public boolean isSlotSelected(int slotNumber) {
        return ((MemorySettingsCategory)this.getCategory()).isSlotSelected(slotNumber);
    }

    public boolean ignoresNbt() {
        return ((MemorySettingsCategory)this.getCategory()).ignoresNbt();
    }

    public void setIgnoreNbt(boolean ignoreNbt) {
        if (this.isServer()) {
            ((MemorySettingsCategory)this.getCategory()).setIgnoreNbt(ignoreNbt);
            this.getSettingsContainer().onMemorizedItemsChanged();
        } else {
            this.sendBooleanToServer(IGNORE_NBT_TAG, ignoreNbt);
        }
    }

    public ItemStack getMemorizedStack(int slotNumber) {
        return ((MemorySettingsCategory)this.getCategory()).getSlotFilterStack(slotNumber, false).orElse(ItemStack.EMPTY);
    }

    public ItemStack getSelectedTemplatesMemorizedStack(int slotNumber) {
        return this.getSettingsContainer().getSelectedTemplatesCategory(MemorySettingsCategory.class).flatMap(cat -> cat.getSlotFilterStack(slotNumber, false)).orElse(ItemStack.EMPTY);
    }
}

