/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.create;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageSavedData;

public class MountedStorageData
extends SavedData
implements IStorageSavedData {
    private static final String SAVED_DATA_NAME = "sophisticatedcore_mounted_storage";
    private static final String STORAGE_CONTENTS_TAG = "storageContents";
    private static final MountedStorageData clientStorageCopy = new MountedStorageData();
    private final Map<UUID, CompoundTag> mountedStorageContents = new HashMap<UUID, CompoundTag>();
    private final Set<UUID> updatedStorageSettingsFlags = new HashSet<UUID>();

    private MountedStorageData() {
    }

    public static MountedStorageData get() {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.getLevel(Level.OVERWORLD);
            DimensionDataStorage storage = overworld.getDataStorage();
            return (MountedStorageData)storage.computeIfAbsent(new SavedData.Factory(MountedStorageData::new, MountedStorageData::load), SAVED_DATA_NAME);
        }
        return clientStorageCopy;
    }

    public static MountedStorageData load(CompoundTag nbt, HolderLookup.Provider registries) {
        MountedStorageData storageData = new MountedStorageData();
        storageData.readStorageContents(nbt);
        return storageData;
    }

    private void readStorageContents(CompoundTag nbt) {
        this.mountedStorageContents.clear();
        ListTag list = nbt.getList(STORAGE_CONTENTS_TAG, 10);
        for (Tag storageNbt : list) {
            CompoundTag uuidContentsPair = (CompoundTag)storageNbt;
            UUID uuid = NbtUtils.loadUUID((Tag)Objects.requireNonNull(uuidContentsPair.get("uuid")));
            CompoundTag contents = uuidContentsPair.getCompound("contents");
            this.mountedStorageContents.put(uuid, contents);
        }
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider registries) {
        CompoundTag ret = new CompoundTag();
        this.writeStorageContents(ret);
        return ret;
    }

    private void writeStorageContents(CompoundTag ret) {
        ListTag list = new ListTag();
        for (Map.Entry<UUID, CompoundTag> entry : this.mountedStorageContents.entrySet()) {
            CompoundTag uuidContentsPair = new CompoundTag();
            uuidContentsPair.putUUID("uuid", entry.getKey());
            uuidContentsPair.put("contents", (Tag)entry.getValue());
            list.add((Object)uuidContentsPair);
        }
        ret.put(STORAGE_CONTENTS_TAG, (Tag)list);
        this.setDirty();
    }

    @Override
    public CompoundTag getContents(UUID storageId) {
        return this.mountedStorageContents.computeIfAbsent(storageId, k -> new CompoundTag());
    }

    public void removeStorageContents(UUID storageId) {
        this.mountedStorageContents.remove(storageId);
        this.setDirty();
    }

    public void setContentsClient(UUID storageId, CompoundTag contents) {
        for (String key : contents.getAllKeys()) {
            this.getContents(storageId).put(key, contents.get(key));
            if (!key.equals("settings")) continue;
            this.updatedStorageSettingsFlags.add(storageId);
        }
        this.setDirty();
    }

    @Override
    public void setContents(UUID storageId, CompoundTag contents) {
        this.mountedStorageContents.put(storageId, contents);
        this.setDirty();
    }

    @Override
    public void markChanged() {
        this.setDirty();
    }

    public boolean removeUpdatedStorageSettingsFlag(UUID storageId) {
        return this.updatedStorageSettingsFlags.remove(storageId);
    }
}

