/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.crafting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;

public abstract class StorageDyeRecipeBase
extends CustomRecipe {
    protected StorageDyeRecipeBase(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        boolean storagePresent = false;
        boolean dyePresent = false;
        for (int slot = 0; slot < inv.size(); ++slot) {
            ItemStack slotStack = inv.getItem(slot);
            if (slotStack.isEmpty()) continue;
            if (this.isDyeableStorageItem(slotStack)) {
                if (storagePresent) {
                    return false;
                }
                storagePresent = true;
                continue;
            }
            if (slotStack.is(Tags.Items.DYES)) {
                dyePresent = true;
                continue;
            }
            return false;
        }
        return storagePresent && dyePresent;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        HashMap<Integer, List<DyeColor>> columnDyes = new HashMap<Integer, List<DyeColor>>();
        Tuple columnStorage = null;
        for (int slot = 0; slot < inv.size(); ++slot) {
            ItemStack slotStack = inv.getItem(slot);
            if (slotStack.isEmpty()) continue;
            int column = slot % inv.width();
            if (this.isDyeableStorageItem(slotStack)) {
                if (columnStorage != null) {
                    return ItemStack.EMPTY;
                }
                columnStorage = new Tuple((Object)column, (Object)slotStack);
                continue;
            }
            if (slotStack.is(Tags.Items.DYES)) {
                DyeColor dyeColor = DyeColor.getColor((ItemStack)slotStack);
                if (dyeColor == null) {
                    return ItemStack.EMPTY;
                }
                columnDyes.computeIfAbsent(column, c -> new ArrayList()).add(dyeColor);
                continue;
            }
            return ItemStack.EMPTY;
        }
        if (columnStorage == null) {
            return ItemStack.EMPTY;
        }
        ItemStack coloredStorage = ((ItemStack)columnStorage.getB()).copy();
        coloredStorage.setCount(1);
        int storageColumn = (Integer)columnStorage.getA();
        this.applyTintColors(columnDyes, coloredStorage, storageColumn);
        return coloredStorage;
    }

    protected abstract boolean isDyeableStorageItem(ItemStack var1);

    private void applyTintColors(Map<Integer, List<DyeColor>> columnDyes, ItemStack coloredStorage, int storageColumn) {
        ArrayList<DyeColor> mainDyes = new ArrayList<DyeColor>();
        ArrayList<DyeColor> trimDyes = new ArrayList<DyeColor>();
        for (Map.Entry<Integer, List<DyeColor>> entry : columnDyes.entrySet()) {
            if (entry.getKey() <= storageColumn) {
                mainDyes.addAll((Collection<DyeColor>)entry.getValue());
            }
            if (entry.getKey() < storageColumn) continue;
            trimDyes.addAll((Collection<DyeColor>)entry.getValue());
        }
        this.applyColors(coloredStorage, mainDyes, trimDyes);
    }

    protected abstract void applyColors(ItemStack var1, List<DyeColor> var2, List<DyeColor> var3);

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 1;
    }
}

