/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui.utils;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.UV;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class GuiHelper {
    public static final ResourceLocation GUI_CONTROLS = SophisticatedCore.getRL("textures/gui/gui_controls.png");
    public static final int GUI_CONTROLS_TEXTURE_WIDTH = 256;
    public static final int GUI_CONTROLS_TEXTURE_HEIGHT = 256;
    public static final TextureBlitData BAR_BACKGROUND_BOTTOM = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 66), Dimension.SQUARE_18);
    public static final TextureBlitData BAR_BACKGROUND_MIDDLE = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 48), Dimension.SQUARE_18);
    public static final TextureBlitData BAR_BACKGROUND_TOP = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 30), Dimension.SQUARE_18);
    public static final ResourceLocation ICONS = SophisticatedCore.getRL("textures/gui/icons.png");
    public static final TextureBlitData CRAFTING_RESULT_SLOT = new TextureBlitData(GUI_CONTROLS, new UV(71, 216), new Dimension(26, 26));
    public static final TextureBlitData DEFAULT_BUTTON_HOVERED_BACKGROUND = new TextureBlitData(GUI_CONTROLS, new UV(47, 0), Dimension.SQUARE_18);
    public static final TextureBlitData DEFAULT_BUTTON_BACKGROUND = new TextureBlitData(GUI_CONTROLS, new UV(29, 0), Dimension.SQUARE_18);
    public static final TextureBlitData SMALL_BUTTON_BACKGROUND = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 18), Dimension.SQUARE_12);
    public static final TextureBlitData SMALL_BUTTON_HOVERED_BACKGROUND = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(41, 18), Dimension.SQUARE_12);
    public static final ResourceLocation SLOTS_BACKGROUND = SophisticatedCore.getRL("textures/gui/slots_background.png");
    private static final Map<Integer, TextureBlitData> SLOTS_BACKGROUNDS = new HashMap<Integer, TextureBlitData>();
    private static final ItemStackRenderState scratchItemStackRenderState = new ItemStackRenderState();

    private GuiHelper() {
    }

    public static void renderItemInGUI(GuiGraphics guiGraphics, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition) {
        GuiHelper.renderItemInGUI(guiGraphics, minecraft, stack, xPosition, yPosition, false);
    }

    public static void renderSlotsBackground(GuiGraphics guiGraphics, int x, int y, int slotWidth, int slotHeight) {
        int currentY = y;
        for (int remainingSlotHeight = slotHeight; remainingSlotHeight > 0; remainingSlotHeight -= Math.min(slotHeight, 12)) {
            int finalRemainingSlotHeight = remainingSlotHeight;
            int key = GuiHelper.getSlotsBackgroundKey(slotWidth, remainingSlotHeight);
            GuiHelper.blit(guiGraphics, x, currentY, SLOTS_BACKGROUNDS.computeIfAbsent(key, k -> new TextureBlitData(SLOTS_BACKGROUND, Dimension.SQUARE_256, new UV(0, 0), new Dimension(slotWidth * 18, finalRemainingSlotHeight * 18))));
            currentY += 216;
        }
    }

    private static int getSlotsBackgroundKey(int slotWidth, int slotHeight) {
        return slotWidth * 31 + slotHeight;
    }

    public static void renderItemInGUI(GuiGraphics guiGraphics, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition, boolean renderOverlay) {
        GuiHelper.renderItemInGUI(guiGraphics, minecraft, stack, xPosition, yPosition, renderOverlay, null);
    }

    public static void renderItemInGUI(GuiGraphics guiGraphics, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition, boolean renderOverlay, @Nullable String countText) {
        guiGraphics.renderItem(stack, xPosition, yPosition);
        if (renderOverlay) {
            guiGraphics.renderItemDecorations(minecraft.font, stack, xPosition, yPosition, countText);
        }
    }

    public static void blit(GuiGraphics guiGraphics, int x, int y, TextureBlitData texData) {
        guiGraphics.blit(RenderType::guiTextured, texData.getTextureName(), x + texData.getXOffset(), y + texData.getYOffset(), (float)texData.getU(), (float)texData.getV(), texData.getWidth(), texData.getHeight(), texData.getTextureWidth(), texData.getTextureHeight());
    }

    public static void blit(GuiGraphics guiGraphics, int x, int y, TextureBlitData texData, int width, int height) {
        int halfWidth = width / 2;
        int secondHalfWidth = width - halfWidth;
        int halfHeight = height / 2;
        int secondHalfHeight = height - halfHeight;
        guiGraphics.blit(RenderType::guiTextured, texData.getTextureName(), x + texData.getXOffset(), y + texData.getYOffset(), (float)texData.getU(), (float)texData.getV(), halfWidth, halfHeight, texData.getTextureWidth(), texData.getTextureHeight());
        guiGraphics.blit(RenderType::guiTextured, texData.getTextureName(), x + texData.getXOffset() + halfWidth, y + texData.getYOffset(), (float)texData.getU() + (float)texData.getWidth() - (float)secondHalfWidth, (float)texData.getV(), secondHalfWidth, halfHeight, texData.getTextureWidth(), texData.getTextureHeight());
        guiGraphics.blit(RenderType::guiTextured, texData.getTextureName(), x + texData.getXOffset(), y + texData.getYOffset() + halfHeight, (float)texData.getU(), (float)texData.getV() + (float)texData.getHeight() - (float)secondHalfHeight, halfWidth, secondHalfHeight, texData.getTextureWidth(), texData.getTextureHeight());
        guiGraphics.blit(RenderType::guiTextured, texData.getTextureName(), x + texData.getXOffset() + halfWidth, y + texData.getYOffset() + halfHeight, (float)texData.getU() + (float)texData.getWidth() - (float)secondHalfWidth, (float)texData.getV() + (float)texData.getHeight() - (float)secondHalfHeight, secondHalfWidth, secondHalfHeight, texData.getTextureWidth(), texData.getTextureHeight());
    }

    public static void coloredBlit(Function<ResourceLocation, RenderType> renderTypeGetter, Matrix4f matrix, int x, int y, TextureBlitData texData, int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        int xMin = x + texData.getXOffset();
        int yMin = y + texData.getYOffset();
        int xMax = xMin + texData.getWidth();
        int yMax = yMin + texData.getHeight();
        float minU = (float)texData.getU() / (float)texData.getTextureWidth();
        float maxU = minU + (float)texData.getWidth() / (float)texData.getTextureWidth();
        float minV = (float)texData.getV() / (float)texData.getTextureHeight();
        float maxV = minV + (float)texData.getHeight() / (float)texData.getTextureWidth();
        RenderType renderType = renderTypeGetter.apply(texData.getTextureName());
        VertexConsumer vertexConsumer = GuiHelper.getBufferSource().getBuffer(renderType);
        vertexConsumer.addVertex(matrix, (float)xMin, (float)yMax, 0.0f).setUv(minU, maxV).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix, (float)xMax, (float)yMax, 0.0f).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix, (float)xMax, (float)yMin, 0.0f).setUv(maxU, minV).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix, (float)xMin, (float)yMin, 0.0f).setUv(minU, minV).setColor(red, green, blue, alpha);
    }

    public static void writeTooltipLines(GuiGraphics guiGraphics, List<FormattedCharSequence> textLines, Font font, float leftX, int topY, MultiBufferSource.BufferSource renderTypeBuffer, int color) {
        for (int i = 0; i < textLines.size(); ++i) {
            FormattedCharSequence line = textLines.get(i);
            if (line != null) {
                guiGraphics.drawString(font, line, leftX, (float)topY, color, true);
            }
            if (i == 0) {
                topY += 2;
            }
            topY += 10;
        }
    }

    public static void fill(GuiGraphics guiGraphics, float minX, float minY, float maxX, float maxY, int color) {
        GuiHelper.fill(guiGraphics, RenderType.gui(), minX, minY, maxX, maxY, 0.0f, color);
    }

    public static void fill(GuiGraphics guiGraphics, RenderType renderType, float minX, float minY, float maxX, float maxY, float z, int color) {
        float j;
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        if (minX < maxX) {
            j = minX;
            minX = maxX;
            maxX = j;
        }
        if (minY < maxY) {
            j = minY;
            minY = maxY;
            maxY = j;
        }
        VertexConsumer vertexconsumer = GuiHelper.getBufferSource().getBuffer(renderType);
        vertexconsumer.addVertex(matrix4f, minX, minY, z).setColor(color);
        vertexconsumer.addVertex(matrix4f, minX, maxY, z).setColor(color);
        vertexconsumer.addVertex(matrix4f, maxX, maxY, z).setColor(color);
        vertexconsumer.addVertex(matrix4f, maxX, minY, z).setColor(color);
        guiGraphics.flush();
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, Dimension dimension, Position offset, Component ... tooltip) {
        return GuiHelper.getButtonStateData(uv, dimension, offset, Arrays.asList(tooltip));
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, String tooltip, Dimension dimension) {
        return GuiHelper.getButtonStateData(uv, tooltip, dimension, new Position(0, 0));
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, String tooltip, Dimension dimension, Position offset) {
        return new ToggleButton.StateData(new TextureBlitData(ICONS, offset, Dimension.SQUARE_256, uv, dimension), new Component[]{Component.translatable((String)tooltip)});
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, Dimension dimension, Position offset, List<Component> tooltip) {
        return new ToggleButton.StateData(new TextureBlitData(ICONS, offset, Dimension.SQUARE_256, uv, dimension), tooltip);
    }

    public static void renderSlotsBackground(GuiGraphics guiGraphics, int x, int y, int slotsInRow, int fullSlotRows, int extraRowSlots) {
        GuiHelper.renderSlotsBackground(guiGraphics, x, y, slotsInRow, fullSlotRows);
        if (extraRowSlots > 0) {
            GuiHelper.renderSlotsBackground(guiGraphics, x, y + fullSlotRows * 18, extraRowSlots, 1);
        }
    }

    public static void renderTiledFluidTextureAtlas(GuiGraphics guiGraphics, Function<ResourceLocation, RenderType> renderTypeGetter, TextureAtlasSprite sprite, int color, int x, int y, int height) {
        RenderType renderType = renderTypeGetter.apply(sprite.atlasLocation());
        VertexConsumer vertexConsumer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(renderType);
        float u0 = sprite.getU0();
        float v0 = sprite.getV0();
        int spriteHeight = sprite.contents().height();
        int startY = y;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        do {
            int renderHeight = Math.min(spriteHeight, height);
            height -= renderHeight;
            float v1 = sprite.getV((float)renderHeight / (float)spriteHeight);
            Matrix4f matrix = guiGraphics.pose().last().pose();
            float u1 = sprite.getU1();
            vertexConsumer.addVertex(matrix, (float)x, (float)startY + (float)renderHeight, 100.0f).setUv(u0, v1).setColor(red, green, blue, 1.0f);
            vertexConsumer.addVertex(matrix, (float)x + 16.0f, (float)startY + (float)renderHeight, 100.0f).setUv(u1, v1).setColor(red, green, blue, 1.0f);
            vertexConsumer.addVertex(matrix, (float)x + 16.0f, (float)startY, 100.0f).setUv(u1, v0).setColor(red, green, blue, 1.0f);
            vertexConsumer.addVertex(matrix, (float)x, (float)startY, 100.0f).setUv(u0, v0).setColor(red, green, blue, 1.0f);
            startY += renderHeight;
        } while (height > 0);
    }

    public static void renderControlBackground(GuiGraphics guiGraphics, int x, int y, int renderWidth, int renderHeight) {
        int u = 29;
        int v = 146;
        int textureBgWidth = 66;
        int textureBgHeight = 56;
        GuiHelper.renderControlBackground(guiGraphics, x, y, renderWidth, renderHeight, u, v, textureBgWidth, textureBgHeight);
    }

    public static void renderControlBackground(GuiGraphics guiGraphics, int x, int y, int renderWidth, int renderHeight, int u, int v, int textureBgWidth, int textureBgHeight) {
        int halfWidth = renderWidth / 2;
        int halfHeight = renderHeight / 2;
        guiGraphics.blit(RenderType::guiTextured, GUI_CONTROLS, x, y, (float)u, (float)v, halfWidth, halfHeight, 256, 256);
        guiGraphics.blit(RenderType::guiTextured, GUI_CONTROLS, x, y + halfHeight, (float)u, (float)v + (float)textureBgHeight - (float)halfHeight, halfWidth, halfHeight, 256, 256);
        guiGraphics.blit(RenderType::guiTextured, GUI_CONTROLS, x + halfWidth, y, (float)u + (float)textureBgWidth - (float)halfWidth, (float)v, halfWidth, halfHeight, 256, 256);
        guiGraphics.blit(RenderType::guiTextured, GUI_CONTROLS, x + halfWidth, y + halfHeight, (float)u + (float)textureBgWidth - (float)halfWidth, (float)v + (float)textureBgHeight - (float)halfHeight, halfWidth, halfHeight, 256, 256);
    }

    public static void tryRenderGuiItem(GuiGraphics guiGraphics, @Nullable LivingEntity livingEntity, ItemStack stack, int x, int y, int rotation) {
        if (!stack.isEmpty()) {
            Minecraft.getInstance().getItemModelResolver().updateForTopItem(scratchItemStackRenderState, stack, ItemDisplayContext.GUI, livingEntity != null ? livingEntity.level() : null, livingEntity, 0);
            try {
                GuiHelper.renderGuiItem(guiGraphics, x, y, rotation);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Item being rendered");
                crashreportcategory.setDetail("Item Type", () -> String.valueOf(stack.getItem()));
                crashreportcategory.setDetail("Item Components", () -> String.valueOf(stack.getComponents()));
                crashreportcategory.setDetail("Item Foil", () -> String.valueOf(stack.hasFoil()));
                throw new ReportedException(crashreport);
            }
        }
    }

    private static void renderGuiItem(GuiGraphics guiGraphics, int x, int y, int rotation) {
        boolean flag;
        PoseStack posestack = guiGraphics.pose();
        posestack.pushPose();
        posestack.translate((float)x + 8.0f, (float)y + 8.0f, 150.0f);
        if (rotation != 0) {
            posestack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)rotation));
        }
        posestack.scale(1.0f, -1.0f, 1.0f);
        posestack.scale(16.0f, 16.0f, 16.0f);
        MultiBufferSource.BufferSource bufferSource = GuiHelper.getBufferSource();
        boolean bl = flag = !scratchItemStackRenderState.usesBlockLight();
        if (flag) {
            bufferSource.endBatch();
            Lighting.setupForFlatItems();
        }
        scratchItemStackRenderState.render(posestack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
        bufferSource.endBatch();
        if (flag) {
            Lighting.setupFor3DItems();
        }
        posestack.popPose();
    }

    private static MultiBufferSource.BufferSource getBufferSource() {
        return Minecraft.getInstance().renderBuffers().bufferSource();
    }

    public static void renderTooltip(Screen screen, GuiGraphics guiGraphics, List<Component> components, int x, int y) {
        List<ClientTooltipComponent> list = GuiHelper.gatherTooltipComponents(components, x, screen.width, screen.height, screen.getFont());
        guiGraphics.renderTooltipInternal(screen.getFont(), list, x, y, DefaultTooltipPositioner.INSTANCE, null);
    }

    public static List<ClientTooltipComponent> gatherTooltipComponents(List<? extends FormattedText> textElements, int mouseX, int screenWidth, int screenHeight, Font fallbackFont) {
        Font font = ClientHooks.getTooltipFont((ItemStack)ItemStack.EMPTY, (Font)fallbackFont);
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        RenderTooltipEvent.GatherComponents event = new RenderTooltipEvent.GatherComponents(ItemStack.EMPTY, screenWidth, screenHeight, elements, -1);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return List.of();
        }
        int tooltipX = mouseX + 12;
        int tooltipTextWidth = event.getTooltipElements().stream().mapToInt(either -> (Integer)either.map(arg_0 -> ((Font)font).width(arg_0), component -> 0)).max().orElse(0);
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
        }
        if (event.getMaxWidth() > 0 && tooltipTextWidth > event.getMaxWidth()) {
            tooltipTextWidth = event.getMaxWidth();
        }
        int tooltipTextWidthF = tooltipTextWidth;
        return event.getTooltipElements().stream().flatMap(either -> (Stream)either.map(text -> font.split(text, tooltipTextWidthF).stream().map(ClientTooltipComponent::create), component -> Stream.of(ClientTooltipComponent.create((TooltipComponent)component)))).toList();
    }

    public static Optional<Rect2i> getPositiveRectangle(int x, int y, int width, int height) {
        if (x + width <= 0 || y + height <= 0) {
            return Optional.empty();
        }
        int positiveX = Math.max(0, x);
        int positiveY = Math.max(0, y);
        int positiveWidth = width + Math.min(0, x);
        int positiveHeight = height + Math.min(0, y);
        return Optional.of(new Rect2i(positiveX, positiveY, positiveWidth, positiveHeight));
    }
}

