/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.create;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageSavedData;

public class MountedStorageData
extends SavedData
implements IStorageSavedData {
    private static final SavedDataType<MountedStorageData> TYPE = new SavedDataType("sophisticatedcore_mounted_storage", MountedStorageData::new, RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap((Codec)Codec.STRING.xmap(UUID::fromString, UUID::toString), (Codec)CompoundTag.CODEC).fieldOf("storageContents").forGetter(storage -> storage.mountedStorageContents)).apply((Applicative)builder, MountedStorageData::new)));
    private static final MountedStorageData clientStorageCopy = new MountedStorageData();
    private final Map<UUID, CompoundTag> mountedStorageContents = new HashMap<UUID, CompoundTag>();
    private final Set<UUID> updatedStorageSettingsFlags = new HashSet<UUID>();

    private MountedStorageData(Map<UUID, CompoundTag> mountedStorageContents) {
        this.mountedStorageContents.putAll(mountedStorageContents);
    }

    private MountedStorageData() {
    }

    public static MountedStorageData get() {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.getLevel(Level.OVERWORLD);
            DimensionDataStorage storage = overworld.getDataStorage();
            return (MountedStorageData)storage.computeIfAbsent(TYPE);
        }
        return clientStorageCopy;
    }

    @Override
    public CompoundTag getContents(UUID storageId) {
        return this.mountedStorageContents.computeIfAbsent(storageId, k -> new CompoundTag());
    }

    public void removeStorageContents(UUID storageId) {
        this.mountedStorageContents.remove(storageId);
        this.setDirty();
    }

    public void setContentsClient(UUID storageId, CompoundTag contents) {
        for (String key : contents.keySet()) {
            this.getContents(storageId).put(key, contents.get(key));
            if (!key.equals("settings")) continue;
            this.updatedStorageSettingsFlags.add(storageId);
        }
        this.setDirty();
    }

    @Override
    public void setContents(UUID storageId, CompoundTag contents) {
        this.mountedStorageContents.put(storageId, contents);
        this.setDirty();
    }

    @Override
    public void markChanged() {
        this.setDirty();
    }

    public boolean removeUpdatedStorageSettingsFlag(UUID storageId) {
        return this.updatedStorageSettingsFlags.remove(storageId);
    }
}

