/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.cooking;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.BlastingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeClientData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.ICookingUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.ICookingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.SmeltingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.SmokingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public abstract class CookingUpgradeWrapper<W extends CookingUpgradeWrapper<W, U, R>, U extends UpgradeItemBase<W>, R extends AbstractCookingRecipe>
extends UpgradeWrapperBase<W, U>
implements ITickableUpgrade,
ICookingUpgrade<R> {
    private static final int NOTHING_TO_DO_COOLDOWN = 10;
    protected final CookingLogic<R> cookingLogic;

    protected CookingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler, RecipeType<R> recipeType, ResourceKey<RecipePropertySet> acceptedInputs, float burnTimeModifier) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        RecipePropertySet validInput = RecipeHelper.getPropertySet(acceptedInputs);
        this.cookingLogic = new CookingLogic<R>(upgrade, upgradeSaveHandler, ((ICookingUpgradeItem)((Object)this.upgradeItem)).getCookingUpgradeConfig(), recipeType, arg_0 -> ((RecipePropertySet)validInput).test(arg_0), burnTimeModifier);
    }

    @Override
    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        if (this.isInCooldown(level)) {
            return;
        }
        if (!this.cookingLogic.tick(level)) {
            this.setCooldown(level, 10);
        }
        boolean isBurning = this.cookingLogic.isBurning(level);
        RenderInfo renderInfo = this.storageWrapper.getRenderInfo();
        if (renderInfo.getUpgradeClientData(CookingUpgradeClientData.TYPE).map(CookingUpgradeClientData::isBurning).orElse(false) != isBurning) {
            if (isBurning) {
                renderInfo.setUpgradeClientData(CookingUpgradeClientData.TYPE, new CookingUpgradeClientData(true));
            } else {
                renderInfo.removeUpgradeClientData(CookingUpgradeClientData.TYPE);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.pauseAndRemoveRenderInfo();
        }
        super.setEnabled(enabled);
    }

    @Override
    public void onBeforeRemoved() {
        this.pauseAndRemoveRenderInfo();
    }

    private void pauseAndRemoveRenderInfo() {
        this.cookingLogic.pause();
        RenderInfo renderInfo = this.storageWrapper.getRenderInfo();
        renderInfo.removeUpgradeClientData(CookingUpgradeClientData.TYPE);
    }

    @Override
    public CookingLogic<R> getCookingLogic() {
        return this.cookingLogic;
    }

    public static class BlastingUpgradeWrapper
    extends CookingUpgradeWrapper<BlastingUpgradeWrapper, BlastingUpgradeItem, BlastingRecipe> {
        public BlastingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler, RecipeType.BLASTING, (ResourceKey<RecipePropertySet>)RecipePropertySet.BLAST_FURNACE_INPUT, 0.5f);
        }
    }

    public static class SmokingUpgradeWrapper
    extends CookingUpgradeWrapper<SmokingUpgradeWrapper, SmokingUpgradeItem, SmokingRecipe> {
        public SmokingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler, RecipeType.SMOKING, (ResourceKey<RecipePropertySet>)RecipePropertySet.SMOKER_INPUT, 0.5f);
        }
    }

    public static class SmeltingUpgradeWrapper
    extends CookingUpgradeWrapper<SmeltingUpgradeWrapper, SmeltingUpgradeItem, SmeltingRecipe> {
        public SmeltingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler, RecipeType.SMELTING, (ResourceKey<RecipePropertySet>)RecipePropertySet.FURNACE_INPUT, 1.0f);
        }
    }
}

