/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.config;

import me.roundaround.enchantmentcompat.roundalib.config.ConfigPath;
import me.roundaround.enchantmentcompat.roundalib.config.manage.ModConfigImpl;
import me.roundaround.enchantmentcompat.roundalib.config.manage.store.WorldScopedFileStore;
import me.roundaround.enchantmentcompat.roundalib.config.option.BooleanConfigOption;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.Config;

public class EnchantmentCompatConfig
extends ModConfigImpl
implements WorldScopedFileStore {
    private static EnchantmentCompatConfig instance;
    public BooleanConfigOption modEnabled;
    public BooleanConfigOption bows;
    public BooleanConfigOption crossbows;
    public BooleanConfigOption armor;
    public BooleanConfigOption damage;

    private EnchantmentCompatConfig() {
        super("enchantmentcompat", 2);
    }

    public static EnchantmentCompatConfig getInstance() {
        if (instance == null) {
            instance = new EnchantmentCompatConfig();
        }
        return instance;
    }

    @Override
    protected void registerOptions() {
        this.modEnabled = this.register((BooleanConfigOption)((BooleanConfigOption.Builder)((BooleanConfigOption.Builder)BooleanConfigOption.builder(ConfigPath.of("modEnabled")).setDefaultValue(true)).setComment("Simple toggle for the mod! Set to false to disable.")).build());
        this.bows = this.register((BooleanConfigOption)((BooleanConfigOption.Builder)((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder(ConfigPath.of("bows")).setDefaultValue(true)).setComment("Allow bow enchantments (i.e. infinity, mending) to combine.")).build());
        this.crossbows = this.register((BooleanConfigOption)((BooleanConfigOption.Builder)((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder(ConfigPath.of("crossbows")).setDefaultValue(true)).setComment("Allow crossbow enchantments (i.e. multishot, piercing) to combine.")).build());
        this.armor = this.register((BooleanConfigOption)((BooleanConfigOption.Builder)((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder(ConfigPath.of("armor")).setDefaultValue(true)).setComment("Allow armor enchantments (i.e. X protection) to combine.")).build());
        this.damage = this.register((BooleanConfigOption)((BooleanConfigOption.Builder)((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder(ConfigPath.of("damage")).setDefaultValue(true)).setComment("Allow damage enchantments (i.e. sharpness, smite) to combine.")).build());
    }

    @Override
    public boolean performConfigUpdate(int n, Config config) {
        if (n == 1) {
            config.set("bows", config.get("infinityMending"));
            config.remove("infinityMending");
            config.set("crossbows", config.get("multishotPiercing"));
            config.remove("multishotPiercing");
            config.set("armor", config.get("protection"));
            config.remove("protection");
            return true;
        }
        return false;
    }
}

