/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.client.gui.util;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import me.roundaround.enchantmentcompat.roundalib.client.gui.util.FourSided;
import me.roundaround.enchantmentcompat.roundalib.client.gui.util.IntRect;
import net.minecraft.class_3532;

public final class FloatRect
extends Record
implements FourSided<Float> {
    private final Float left;
    private final Float top;
    private final Float right;
    private final Float bottom;

    public FloatRect(Float f, Float f2, Float f3, Float f4) {
        this.left = f;
        this.top = f2;
        this.right = f3;
        this.bottom = f4;
    }

    public static FloatRect zero() {
        return FloatRect.byBounds(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static FloatRect byBounds(float f, float f2, float f3, float f4) {
        return new FloatRect(Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4));
    }

    public static FloatRect byDimensions(float f, float f2, float f3, float f4) {
        return new FloatRect(Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f + f3), Float.valueOf(f2 + f4));
    }

    public static FloatRect fromIntRect(IntRect intRect) {
        return intRect.toFloatRect();
    }

    public float getWidth() {
        return this.right.floatValue() - this.left.floatValue();
    }

    public float getHeight() {
        return this.bottom.floatValue() - this.top.floatValue();
    }

    public IntRect round() {
        return IntRect.byBounds(Math.round(this.left().floatValue()), Math.round(this.top().floatValue()), Math.round(this.right().floatValue()), Math.round(this.bottom().floatValue()));
    }

    public IntRect roundOutward() {
        return IntRect.byBounds(class_3532.method_15375((float)this.left().floatValue()), class_3532.method_15375((float)this.top().floatValue()), class_3532.method_15386((float)this.right().floatValue()), class_3532.method_15386((float)this.bottom().floatValue()));
    }

    public IntRect truncate() {
        return IntRect.byBounds(this.left.intValue(), this.top.intValue(), this.right.intValue(), this.bottom.intValue());
    }

    public FloatRect expand(float f) {
        return FloatRect.byBounds(this.left.floatValue() - f, this.top.floatValue() - f, this.right.floatValue() + f, this.bottom.floatValue() + f);
    }

    public FloatRect expand(FourSided<Float> fourSided) {
        return FloatRect.byBounds(this.left.floatValue() - fourSided.left().floatValue(), this.top.floatValue() - fourSided.top().floatValue(), this.right.floatValue() + fourSided.right().floatValue(), this.bottom.floatValue() + fourSided.bottom().floatValue());
    }

    public FloatRect reduce(float f) {
        return FloatRect.byBounds(this.left.floatValue() + f, this.top.floatValue() + f, this.right.floatValue() - f, this.bottom.floatValue() - f);
    }

    public FloatRect reduce(FourSided<Float> fourSided) {
        return FloatRect.byBounds(this.left.floatValue() + fourSided.left().floatValue(), this.top.floatValue() + fourSided.top().floatValue(), this.right.floatValue() - fourSided.right().floatValue(), this.bottom.floatValue() - fourSided.bottom().floatValue());
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{FloatRect.class, "left;top;right;bottom", "left", "top", "right", "bottom"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FloatRect.class, "left;top;right;bottom", "left", "top", "right", "bottom"}, this);
    }

    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FloatRect.class, "left;top;right;bottom", "left", "top", "right", "bottom"}, this, object);
    }

    @Override
    public Float left() {
        return this.left;
    }

    @Override
    public Float top() {
        return this.top;
    }

    @Override
    public Float right() {
        return this.right;
    }

    @Override
    public Float bottom() {
        return this.bottom;
    }
}

