/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.config.manage.store;

import java.util.Collection;
import java.util.function.Consumer;
import me.roundaround.enchantmentcompat.roundalib.config.option.ConfigOption;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.Config;

public interface ConfigStore {
    public String getModId();

    public int getVersion();

    public Collection<ConfigOption<?>> getAll();

    public void setStoreSuppliedVersion(int var1);

    public int getStoreSuppliedVersion();

    public void readFromStore();

    public void writeToStore();

    public void clear();

    public boolean isInitialized();

    default public boolean isReady() {
        return this.isInitialized();
    }

    default public boolean isDirty() {
        return this.getVersion() != this.getStoreSuppliedVersion() || this.getAll().stream().anyMatch(ConfigOption::isDirty);
    }

    default public void initializeStore() {
        this.syncWithStore();
    }

    default public void syncWithStore() {
        this.setStoreSuppliedVersion(-1);
        this.readFromStore();
        this.writeToStore();
        this.refresh();
    }

    default public void forEach(Consumer<ConfigOption<?>> consumer) {
        this.getAll().forEach(consumer);
    }

    default public void refresh() {
        this.getAll().forEach(ConfigOption::update);
    }

    default public boolean performConfigUpdate(int n, Config config) {
        return false;
    }
}

