/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.config.manage.store;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import me.roundaround.enchantmentcompat.roundalib.RoundaLib;
import me.roundaround.enchantmentcompat.roundalib.config.manage.store.ConfigStore;
import me.roundaround.enchantmentcompat.roundalib.config.option.ConfigOption;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.CommentedConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.CommentedFileConfig;
import me.roundaround.enchantmentcompat.roundalib.util.PathAccessor;

public interface FileBackedConfigStore
extends ConfigStore {
    public Path getConfigDirectory();

    default public String getFileName() {
        return this.getModId();
    }

    default public Path getConfigFile() {
        return PathAccessor.getInstance().getConfigFile(this.getConfigDirectory(), this.getFileName(), PathAccessor.ConfigFormat.TOML);
    }

    @Override
    default public void readFromStore() {
        Path path = this.getConfigFile();
        if (path == null || Files.notExists(path, new LinkOption[0])) {
            return;
        }
        CommentedFileConfig commentedFileConfig = (CommentedFileConfig)CommentedFileConfig.builder(path).preserveInsertionOrder().sync().build();
        commentedFileConfig.load();
        commentedFileConfig.close();
        this.setStoreSuppliedVersion(commentedFileConfig.getIntOrElse("configVersion", -1));
        CommentedConfig commentedConfig = CommentedConfig.copy(commentedFileConfig);
        if (this.performConfigUpdate(this.getStoreSuppliedVersion(), commentedConfig)) {
            commentedFileConfig.putAll(commentedConfig);
        }
        this.getAll().forEach((? super T configOption) -> {
            Object t = commentedFileConfig.get(configOption.getPath().toString());
            if (t != null) {
                configOption.deserialize(t);
            } else {
                configOption.markDirty();
            }
        });
    }

    @Override
    default public void writeToStore() {
        Path path = this.getConfigFile();
        if (path == null) {
            return;
        }
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                RoundaLib.LOGGER.error("Failed to create config file or its directory tree: {}", (Object)path.toAbsolutePath());
                return;
            }
        }
        if (!this.isDirty()) {
            RoundaLib.LOGGER.debug("Skipping saving {} config to file because nothing has changed.", (Object)this.getModId());
            return;
        }
        CommentedFileConfig commentedFileConfig = (CommentedFileConfig)CommentedFileConfig.builder(path).preserveInsertionOrder().sync().build();
        commentedFileConfig.setComment("configVersion", " Config version is auto-generated\n DO NOT CHANGE");
        commentedFileConfig.set("configVersion", (Object)this.getVersion());
        Collection<ConfigOption<?>> collection = this.getAll();
        collection.forEach((? super T configOption) -> {
            String string = configOption.getPath().toString();
            List<String> list = configOption.getComment();
            if (!list.isEmpty()) {
                commentedFileConfig.setComment(string, " " + String.join((CharSequence)"\n ", list));
            }
            commentedFileConfig.set(string, configOption.serialize());
        });
        commentedFileConfig.save();
        commentedFileConfig.close();
        collection.forEach(ConfigOption::commit);
    }
}

