/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.config.option;

import java.util.regex.Pattern;
import me.roundaround.enchantmentcompat.roundalib.config.ConfigPath;
import me.roundaround.enchantmentcompat.roundalib.config.option.ConfigOption;

public class StringConfigOption
extends ConfigOption<String> {
    protected StringConfigOption(Builder builder) {
        super(builder);
    }

    public static Builder builder(ConfigPath configPath) {
        return new Builder(configPath);
    }

    public static class Builder
    extends ConfigOption.AbstractBuilder<String, StringConfigOption, Builder> {
        private Integer minLength = null;
        private Integer maxLength = null;
        private Pattern regex = null;

        private Builder(ConfigPath configPath) {
            super(configPath);
        }

        public Builder setMinLength(int n) {
            this.minLength = n;
            return this;
        }

        public Builder setMaxLength(int n) {
            this.maxLength = n;
            return this;
        }

        public Builder setRegex(Pattern pattern) {
            this.regex = pattern;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.maxLength != null) {
                this.validators.addFirst((string, configOption) -> string != null && string.length() <= this.maxLength);
            }
            if (this.minLength != null) {
                this.validators.addFirst((string, configOption) -> string != null && string.length() >= this.minLength);
            }
            if (this.regex != null) {
                this.validators.addFirst((string, configOption) -> string != null && this.regex.matcher((CharSequence)string).find());
            }
        }

        @Override
        protected StringConfigOption buildInternal() {
            return new StringConfigOption(this);
        }
    }
}

