/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.config.option;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import me.roundaround.enchantmentcompat.roundalib.config.ConfigPath;
import me.roundaround.enchantmentcompat.roundalib.config.option.ConfigOption;

public class StringListConfigOption
extends ConfigOption<List<String>> {
    protected StringListConfigOption(Builder builder) {
        super(builder);
    }

    @Override
    public void deserialize(Object object) {
        this.setValue(((List)object).stream().map(String::valueOf).toList());
    }

    @Override
    public void setValue(List<String> list) {
        super.setValue(List.copyOf(list));
    }

    @Override
    protected boolean areValuesEqual(List<String> list, List<String> list2) {
        if (list == null != (list2 == null)) {
            return false;
        }
        if (list == null) {
            return true;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        Iterator<String> iterator = list.iterator();
        Iterator<String> iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (Objects.equals(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public void add(String string) {
        ArrayList<String> arrayList = new ArrayList<String>((Collection)super.getValue());
        arrayList.add(string);
        this.setValue((List<String>)arrayList);
    }

    public void remove(String string) {
        ArrayList<String> arrayList = new ArrayList<String>((Collection)super.getValue());
        arrayList.remove(string);
        this.setValue((List<String>)arrayList);
    }

    public static Builder builder(ConfigPath configPath) {
        return new Builder(configPath);
    }

    public static class Builder
    extends ConfigOption.AbstractBuilder<List<String>, StringListConfigOption, Builder> {
        private Builder(ConfigPath configPath) {
            super(configPath);
            this.setDefaultValue(List.of());
        }

        @Override
        protected StringListConfigOption buildInternal() {
            return new StringListConfigOption(this);
        }
    }
}

