/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.config.value;

import java.util.Arrays;
import me.roundaround.enchantmentcompat.roundalib.config.value.EnumValue;
import net.minecraft.class_310;

public enum GuiAlignment implements EnumValue<GuiAlignment>
{
    TOP_LEFT(AlignmentY.TOP, AlignmentX.LEFT),
    TOP_RIGHT(AlignmentY.TOP, AlignmentX.RIGHT),
    BOTTOM_LEFT(AlignmentY.BOTTOM, AlignmentX.LEFT),
    BOTTOM_RIGHT(AlignmentY.BOTTOM, AlignmentX.RIGHT);

    private final AlignmentX alignmentX;
    private final AlignmentY alignmentY;
    private final String id;

    private GuiAlignment(AlignmentY alignmentY, AlignmentX alignmentX) {
        this.alignmentX = alignmentX;
        this.alignmentY = alignmentY;
        this.id = String.valueOf((Object)alignmentY) + "_" + String.valueOf((Object)alignmentX);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getI18nKey(String string) {
        return string + ".roundalib.gui_alignment." + this.id;
    }

    @Override
    public GuiAlignment getFromId(String string) {
        return GuiAlignment.fromId(string);
    }

    @Override
    public GuiAlignment getNext() {
        return GuiAlignment.values()[(this.ordinal() + 1) % GuiAlignment.values().length];
    }

    @Override
    public GuiAlignment getPrev() {
        return GuiAlignment.values()[(this.ordinal() + GuiAlignment.values().length - 1) % GuiAlignment.values().length];
    }

    public AlignmentX getAlignmentX() {
        return this.alignmentX;
    }

    public AlignmentY getAlignmentY() {
        return this.alignmentY;
    }

    public int getPosX() {
        return GuiAlignment.getPosX(this);
    }

    public int getPosY() {
        return GuiAlignment.getPosY(this);
    }

    public int getOffsetMultiplierX() {
        return GuiAlignment.getOffsetMultiplierX(this);
    }

    public int getOffsetMultiplierY() {
        return GuiAlignment.getOffsetMultiplierY(this);
    }

    public static GuiAlignment getDefault() {
        return TOP_LEFT;
    }

    public static GuiAlignment fromId(String string) {
        return Arrays.stream(GuiAlignment.values()).filter(guiAlignment -> guiAlignment.id.equals(string)).findFirst().orElse(GuiAlignment.getDefault());
    }

    public static int getPosX(GuiAlignment guiAlignment) {
        return guiAlignment.alignmentX.getPos();
    }

    public static int getPosY(GuiAlignment guiAlignment) {
        return guiAlignment.alignmentY.getPos();
    }

    public static int getOffsetMultiplierX(GuiAlignment guiAlignment) {
        return guiAlignment.alignmentX.getOffsetMultiplier();
    }

    public static int getOffsetMultiplierY(GuiAlignment guiAlignment) {
        return guiAlignment.alignmentY.getOffsetMultiplier();
    }

    private static int getScaledWindowWidth() {
        return class_310.method_1551().method_22683().method_4486();
    }

    private static int getScaledWindowHeight() {
        return class_310.method_1551().method_22683().method_4502();
    }

    public static enum AlignmentX {
        LEFT("left"),
        RIGHT("right");

        private final String value;

        private AlignmentX(String string2) {
            this.value = string2;
        }

        public String toString() {
            return this.value;
        }

        public int getPos() {
            return this.value.equals("right") ? GuiAlignment.getScaledWindowWidth() : 0;
        }

        public int getOffsetMultiplier() {
            return this.value.equals("right") ? -1 : 1;
        }
    }

    public static enum AlignmentY {
        TOP("top"),
        BOTTOM("bottom");

        private final String value;

        private AlignmentY(String string2) {
            this.value = string2;
        }

        public String toString() {
            return this.value;
        }

        public int getPos() {
            return this.value.equals("bottom") ? GuiAlignment.getScaledWindowHeight() : 0;
        }

        public int getOffsetMultiplier() {
            return this.value.equals("bottom") ? -1 : 1;
        }
    }
}

