/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.config.value;

import java.util.List;

public record Position(int x, int y) {
    public Position movedUp(int n) {
        return new Position(this.x(), this.y() - n);
    }

    public Position movedDown(int n) {
        return new Position(this.x(), this.y() + n);
    }

    public Position movedLeft(int n) {
        return new Position(this.x() - n, this.y());
    }

    public Position movedRight(int n) {
        return new Position(this.x() + n, this.y());
    }

    public Position moved(Direction direction, int n) {
        return switch (direction.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.movedLeft(n);
            case 1 -> this.movedUp(n);
            case 2 -> this.movedRight(n);
            case 3 -> this.movedDown(n);
        };
    }

    @Override
    public String toString() {
        return String.format("(%d,%d)", this.x(), this.y());
    }

    public static Position fromString(String string) {
        String[] stringArray = string.substring(1, string.length() - 1).split(",");
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        return new Position(n, n2);
    }

    public static Position fromList(List<Integer> list) {
        return new Position(list.get(0), list.get(1));
    }

    public static enum Direction {
        LEFT,
        UP,
        RIGHT,
        DOWN;

    }
}

