/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.nightconfig.core;

import java.util.List;
import java.util.Map;
import java.util.Set;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.Config;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.utils.ConfigWrapper;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.utils.TransformingMap;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.utils.TransformingSet;

class CheckedConfig
extends ConfigWrapper<Config> {
    CheckedConfig(Config config) {
        super(config);
        config.valueMap().forEach((string, object) -> this.checkValue(object));
    }

    @Override
    public Config checked() {
        return this;
    }

    @Override
    public <T> T set(List<String> list, Object object) {
        return super.set(list, this.checkedValue(object));
    }

    @Override
    public boolean add(List<String> list, Object object) {
        return super.add(list, this.checkedValue(object));
    }

    @Override
    public Map<String, Object> valueMap() {
        return new TransformingMap<String, Object, Object>(super.valueMap(), object -> object, this::checkedValue, object -> object);
    }

    @Override
    public Set<? extends Config.Entry> entrySet() {
        return new TransformingSet<Config.Entry, Config.Entry>(super.entrySet(), entry -> entry, this::checkedValue, object -> object);
    }

    @Override
    public String toString() {
        return "checked of " + String.valueOf(this.config);
    }

    private void checkValue(Object object2) {
        ConfigFormat<?> configFormat = this.configFormat();
        if (object2 != null && !configFormat.supportsType(object2.getClass())) {
            throw new IllegalArgumentException("Unsupported value type: " + object2.getClass().getTypeName());
        }
        if (object2 == null && !configFormat.supportsType(null)) {
            throw new IllegalArgumentException("Null values aren't supported by this configuration.");
        }
        if (object2 instanceof Config) {
            ((Config)object2).valueMap().forEach((string, object) -> this.checkValue(object));
        }
    }

    private <T> T checkedValue(T t) {
        this.checkValue(t);
        return t;
    }
}

