/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.nightconfig.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.CheckedCommentedConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.Config;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.InMemoryCommentedFormat;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.SimpleCommentedConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.UnmodifiableCommentedConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.utils.FakeCommentedConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.utils.StringUtils;

public interface CommentedConfig
extends UnmodifiableCommentedConfig,
Config {
    default public String setComment(String string, String string2) {
        return this.setComment(StringUtils.split(string, '.'), string2);
    }

    public String setComment(List<String> var1, String var2);

    default public String removeComment(String string) {
        return this.removeComment(StringUtils.split(string, '.'));
    }

    public String removeComment(List<String> var1);

    public void clearComments();

    default public void putAllComments(Map<String, UnmodifiableCommentedConfig.CommentNode> map) {
        for (Map.Entry<String, UnmodifiableCommentedConfig.CommentNode> entry : map.entrySet()) {
            CommentedConfig commentedConfig;
            Map<String, UnmodifiableCommentedConfig.CommentNode> map2;
            String string = entry.getKey();
            UnmodifiableCommentedConfig.CommentNode commentNode = entry.getValue();
            String string2 = commentNode.getComment();
            if (string2 != null) {
                this.setComment(Collections.singletonList(string), string2);
            }
            if ((map2 = commentNode.getChildren()) == null || (commentedConfig = (CommentedConfig)this.getRaw(Collections.singletonList(string))) == null) continue;
            commentedConfig.putAllComments(map2);
        }
    }

    default public void putAllComments(UnmodifiableCommentedConfig unmodifiableCommentedConfig) {
        for (UnmodifiableCommentedConfig.Entry entry : unmodifiableCommentedConfig.entrySet()) {
            CommentedConfig commentedConfig;
            Object t;
            String string = entry.getKey();
            String string2 = entry.getComment();
            if (string2 != null) {
                this.setComment(Collections.singletonList(string), string2);
            }
            if (!((t = entry.getValue()) instanceof UnmodifiableCommentedConfig) || (commentedConfig = (CommentedConfig)this.getRaw(Collections.singletonList(string))) == null) continue;
            commentedConfig.putAllComments((UnmodifiableCommentedConfig)t);
        }
    }

    @Override
    default public UnmodifiableCommentedConfig unmodifiable() {
        return new UnmodifiableCommentedConfig(){

            @Override
            public <T> T getRaw(List<String> list) {
                return CommentedConfig.this.getRaw(list);
            }

            @Override
            public String getComment(List<String> list) {
                return CommentedConfig.this.getComment(list);
            }

            @Override
            public boolean contains(List<String> list) {
                return CommentedConfig.this.contains(list);
            }

            @Override
            public boolean containsComment(List<String> list) {
                return CommentedConfig.this.containsComment(list);
            }

            @Override
            public int size() {
                return CommentedConfig.this.size();
            }

            @Override
            public Map<String, Object> valueMap() {
                return Collections.unmodifiableMap(CommentedConfig.this.valueMap());
            }

            @Override
            public Map<String, String> commentMap() {
                return Collections.unmodifiableMap(CommentedConfig.this.commentMap());
            }

            @Override
            public Map<String, UnmodifiableCommentedConfig.CommentNode> getComments() {
                return CommentedConfig.this.getComments();
            }

            @Override
            public Set<? extends UnmodifiableCommentedConfig.Entry> entrySet() {
                return CommentedConfig.this.entrySet();
            }

            @Override
            public ConfigFormat<?> configFormat() {
                return CommentedConfig.this.configFormat();
            }
        };
    }

    @Override
    default public CommentedConfig checked() {
        return new CheckedCommentedConfig(this);
    }

    @Override
    public Map<String, String> commentMap();

    public Set<? extends Entry> entrySet();

    @Override
    public CommentedConfig createSubConfig();

    public static CommentedConfig of(ConfigFormat<? extends CommentedConfig> configFormat) {
        return new SimpleCommentedConfig(configFormat, false);
    }

    public static CommentedConfig of(Supplier<Map<String, Object>> supplier, ConfigFormat<? extends CommentedConfig> configFormat) {
        return new SimpleCommentedConfig(supplier, configFormat);
    }

    @Deprecated
    public static CommentedConfig ofConcurrent(ConfigFormat<? extends CommentedConfig> configFormat) {
        return new SimpleCommentedConfig(configFormat, false);
    }

    public static CommentedConfig inMemory() {
        return (CommentedConfig)InMemoryCommentedFormat.defaultInstance().createConfig();
    }

    @Deprecated
    public static CommentedConfig inMemoryConcurrent() {
        return (CommentedConfig)InMemoryCommentedFormat.defaultInstance().createConcurrentConfig();
    }

    public static CommentedConfig wrap(Map<String, Object> map, ConfigFormat<?> configFormat) {
        return new SimpleCommentedConfig(map, configFormat);
    }

    public static CommentedConfig copy(UnmodifiableConfig unmodifiableConfig) {
        return new SimpleCommentedConfig(unmodifiableConfig, unmodifiableConfig.configFormat(), false);
    }

    public static CommentedConfig copy(UnmodifiableConfig unmodifiableConfig, Supplier<Map<String, Object>> supplier) {
        return new SimpleCommentedConfig(unmodifiableConfig, supplier, unmodifiableConfig.configFormat());
    }

    public static CommentedConfig copy(UnmodifiableConfig unmodifiableConfig, ConfigFormat<?> configFormat) {
        return new SimpleCommentedConfig(unmodifiableConfig, configFormat, false);
    }

    public static CommentedConfig copy(UnmodifiableConfig unmodifiableConfig, Supplier<Map<String, Object>> supplier, ConfigFormat<?> configFormat) {
        return new SimpleCommentedConfig(unmodifiableConfig, supplier, configFormat);
    }

    public static CommentedConfig copy(UnmodifiableCommentedConfig unmodifiableCommentedConfig) {
        return new SimpleCommentedConfig(unmodifiableCommentedConfig, unmodifiableCommentedConfig.configFormat(), false);
    }

    public static CommentedConfig copy(UnmodifiableCommentedConfig unmodifiableCommentedConfig, Supplier<Map<String, Object>> supplier) {
        return new SimpleCommentedConfig(unmodifiableCommentedConfig, supplier, unmodifiableCommentedConfig.configFormat());
    }

    public static CommentedConfig copy(UnmodifiableCommentedConfig unmodifiableCommentedConfig, ConfigFormat<?> configFormat) {
        return new SimpleCommentedConfig(unmodifiableCommentedConfig, configFormat, false);
    }

    public static CommentedConfig copy(UnmodifiableCommentedConfig unmodifiableCommentedConfig, Supplier<Map<String, Object>> supplier, ConfigFormat<? extends CommentedConfig> configFormat) {
        return new SimpleCommentedConfig(unmodifiableCommentedConfig, supplier, configFormat);
    }

    @Deprecated
    public static CommentedConfig concurrentCopy(UnmodifiableConfig unmodifiableConfig) {
        return new SimpleCommentedConfig(unmodifiableConfig, unmodifiableConfig.configFormat(), true);
    }

    @Deprecated
    public static CommentedConfig concurrentCopy(UnmodifiableConfig unmodifiableConfig, ConfigFormat<?> configFormat) {
        return new SimpleCommentedConfig(unmodifiableConfig, configFormat, true);
    }

    @Deprecated
    public static CommentedConfig concurrentCopy(UnmodifiableCommentedConfig unmodifiableCommentedConfig) {
        return new SimpleCommentedConfig(unmodifiableCommentedConfig, unmodifiableCommentedConfig.configFormat(), true);
    }

    @Deprecated
    public static CommentedConfig concurrentCopy(UnmodifiableCommentedConfig unmodifiableCommentedConfig, ConfigFormat<?> configFormat) {
        return new SimpleCommentedConfig(unmodifiableCommentedConfig, configFormat, true);
    }

    public static CommentedConfig fake(Config config) {
        if (config instanceof CommentedConfig) {
            return (CommentedConfig)config;
        }
        return new FakeCommentedConfig(config);
    }

    public static interface Entry
    extends Config.Entry,
    UnmodifiableCommentedConfig.Entry {
        public String setComment(String var1);

        public String removeComment();
    }
}

