/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.EnumGetMethod;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.AdvancedPath;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.Conversion;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.Converter;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.InvalidValueException;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.Path;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.PreserveNotNull;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.ReflectionException;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.SpecClassInArray;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.SpecDoubleInRange;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.SpecEnum;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.SpecFloatInRange;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.SpecIntInRange;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.SpecLongInRange;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.SpecNotNull;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.SpecStringInArray;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.SpecStringInRange;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.SpecValidator;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.utils.StringUtils;

final class AnnotationUtils {
    private AnnotationUtils() {
    }

    static boolean hasPreserveNotNull(AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(PreserveNotNull.class);
    }

    static boolean mustPreserve(Field field, Class<?> clazz) {
        return AnnotationUtils.hasPreserveNotNull(field) || AnnotationUtils.hasPreserveNotNull(clazz);
    }

    static Converter<Object, Object> getConverter(Field field) {
        Conversion conversion = field.getAnnotation(Conversion.class);
        if (conversion != null) {
            try {
                Constructor<Converter<?, ?>> constructor = conversion.value().getDeclaredConstructor(new Class[0]);
                if (!constructor.isAccessible()) {
                    constructor.setAccessible(true);
                }
                return constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new ReflectionException("Cannot create a converter for field " + String.valueOf(field), reflectiveOperationException);
            }
        }
        return null;
    }

    static List<String> getPath(Field field) {
        List<String> list = AnnotationUtils.getPath((AnnotatedElement)field);
        return list == null ? Collections.singletonList(field.getName()) : list;
    }

    static List<String> getPath(AnnotatedElement annotatedElement) {
        Path path = annotatedElement.getDeclaredAnnotation(Path.class);
        if (path != null) {
            return StringUtils.split(path.value(), '.');
        }
        AdvancedPath advancedPath = annotatedElement.getDeclaredAnnotation(AdvancedPath.class);
        if (advancedPath != null) {
            return Arrays.asList(advancedPath.value());
        }
        return null;
    }

    static void checkField(Field field, Object object) {
        SpecValidator specValidator;
        SpecEnum specEnum;
        SpecIntInRange specIntInRange;
        SpecLongInRange specLongInRange;
        SpecFloatInRange specFloatInRange;
        SpecDoubleInRange specDoubleInRange;
        SpecStringInRange specStringInRange;
        SpecStringInArray specStringInArray;
        SpecClassInArray specClassInArray;
        SpecNotNull specNotNull = field.getDeclaredAnnotation(SpecNotNull.class);
        if (specNotNull != null) {
            AnnotationUtils.checkNotNull(field, object);
        }
        if ((specClassInArray = field.getDeclaredAnnotation(SpecClassInArray.class)) != null) {
            AnnotationUtils.checkFieldSpec(field, object, specClassInArray);
        }
        if ((specStringInArray = field.getDeclaredAnnotation(SpecStringInArray.class)) != null) {
            AnnotationUtils.checkFieldSpec(field, object, specStringInArray);
        }
        if ((specStringInRange = field.getDeclaredAnnotation(SpecStringInRange.class)) != null) {
            AnnotationUtils.checkFieldSpec(field, object, specStringInRange);
        }
        if ((specDoubleInRange = field.getDeclaredAnnotation(SpecDoubleInRange.class)) != null) {
            AnnotationUtils.checkFieldSpec(field, object, specDoubleInRange);
        }
        if ((specFloatInRange = field.getDeclaredAnnotation(SpecFloatInRange.class)) != null) {
            AnnotationUtils.checkFieldSpec(field, object, specFloatInRange);
        }
        if ((specLongInRange = field.getDeclaredAnnotation(SpecLongInRange.class)) != null) {
            AnnotationUtils.checkFieldSpec(field, object, specLongInRange);
        }
        if ((specIntInRange = field.getDeclaredAnnotation(SpecIntInRange.class)) != null) {
            AnnotationUtils.checkFieldSpec(field, object, specIntInRange);
        }
        if ((specEnum = field.getDeclaredAnnotation(SpecEnum.class)) != null) {
            AnnotationUtils.checkFieldSpec(field, object, specEnum);
        }
        if ((specValidator = field.getDeclaredAnnotation(SpecValidator.class)) != null) {
            AnnotationUtils.checkFieldSpec(field, object, specValidator);
        }
    }

    private static void checkFieldSpec(Field field, Object object, SpecValidator specValidator) {
        Predicate<Object> predicate;
        try {
            Constructor<? extends Predicate<Object>> constructor = specValidator.value().getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            predicate = constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ReflectionException("Cannot create a converter for field " + String.valueOf(field), reflectiveOperationException);
        }
        if (!predicate.test(object)) {
            throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", object, field, specValidator);
        }
    }

    private static void checkFieldSpec(Field field, Object object, SpecClassInArray specClassInArray) {
        AnnotationUtils.checkNotNull(field, object);
        Class<?> clazz = object.getClass();
        if (specClassInArray.strict()) {
            for (Class<?> clazz2 : specClassInArray.value()) {
                if (!clazz2.isAssignableFrom(clazz)) continue;
                return;
            }
        } else {
            for (Class<?> clazz3 : specClassInArray.value()) {
                if (!clazz3.equals(clazz)) continue;
                return;
            }
        }
        throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", object, field, specClassInArray);
    }

    private static void checkFieldSpec(Field field, Object object, SpecStringInRange specStringInRange) {
        AnnotationUtils.checkClass(field, object, String.class);
        String string = (String)object;
        if (string.compareTo(specStringInRange.min()) < 0 || string.compareTo(specStringInRange.max()) > 0) {
            throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", object, field, specStringInRange);
        }
    }

    private static void checkFieldSpec(Field field, Object object, SpecEnum specEnum) {
        EnumGetMethod enumGetMethod = specEnum.method();
        Class<?> clazz = field.getType();
        if (!clazz.isEnum()) {
            throw new InvalidValueException("Field %s is annotated with @SpecEnum but isn't of type enum", field);
        }
        Class<?> clazz2 = clazz;
        if (!enumGetMethod.validate(object, clazz2)) {
            throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", object, field, specEnum);
        }
    }

    private static void checkFieldSpec(Field field, Object object, SpecStringInArray specStringInArray) {
        AnnotationUtils.checkClass(field, object, String.class);
        String string = (String)object;
        if (specStringInArray.ignoreCase()) {
            for (String string2 : specStringInArray.value()) {
                if (!string.equalsIgnoreCase(string2)) continue;
                return;
            }
        } else {
            for (String string3 : specStringInArray.value()) {
                if (!string.equals(string3)) continue;
                return;
            }
        }
        throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", object, field, specStringInArray);
    }

    private static void checkFieldSpec(Field field, Object object, SpecDoubleInRange specDoubleInRange) {
        AnnotationUtils.checkClass(field, object, Double.class);
        double d = (Double)object;
        if (d < specDoubleInRange.min() || d > specDoubleInRange.max()) {
            throw new InvalidValueException("Invalid value %f for field %s: it doesn't conform to %s", object, field, specDoubleInRange);
        }
    }

    private static void checkFieldSpec(Field field, Object object, SpecFloatInRange specFloatInRange) {
        AnnotationUtils.checkClass(field, object, Float.class);
        float f = ((Float)object).floatValue();
        if (f < specFloatInRange.min() || f > specFloatInRange.max()) {
            throw new InvalidValueException("Invalid value %f for field %s: it doesn't conform to %s", object, field, specFloatInRange);
        }
    }

    private static void checkFieldSpec(Field field, Object object, SpecLongInRange specLongInRange) {
        AnnotationUtils.checkClass(field, object, Long.class);
        long l = (Long)object;
        if (l < specLongInRange.min() || l > specLongInRange.max()) {
            throw new InvalidValueException("Invalid value %d for field %s: it doesn't conform to %s", object, field, specLongInRange);
        }
    }

    private static void checkFieldSpec(Field field, Object object, SpecIntInRange specIntInRange) {
        AnnotationUtils.checkClass(field, object, Integer.class);
        int n = (Integer)object;
        if (n < specIntInRange.min() || n > specIntInRange.max()) {
            throw new InvalidValueException("Invalid value %d for field %s: it doesn't conform to %s", object, field, specIntInRange);
        }
    }

    private static void checkNotNull(Field field, Object object) {
        if (object == null) {
            throw new InvalidValueException("Invalid null value for field %s", field);
        }
    }

    private static void checkClass(Field field, Object object, Class<?> clazz) {
        AnnotationUtils.checkNotNull(field, object);
        Class<?> clazz2 = object.getClass();
        if (clazz2 != clazz) {
            throw new InvalidValueException("Invalid type %s for field %s, expected %s", clazz2, field, clazz);
        }
    }
}

