/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.CommentedConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.Config;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.ConvertedCommentedConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.ConvertedCommentedFileConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.ConvertedConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.ConvertedFileConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.CommentedFileConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.FileConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.utils.TransformingMap;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.utils.TransformingSet;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.utils.UnmodifiableConfigWrapper;

public final class ConversionTable
implements Cloneable {
    private final Map<Class<?>, Function<?, Object>> conversionMap;

    public ConversionTable() {
        this.conversionMap = new HashMap();
    }

    private ConversionTable(ConversionTable conversionTable) {
        this.conversionMap = new HashMap(conversionTable.conversionMap);
    }

    public <T> void put(Class<T> clazz, Function<? super T, Object> function) {
        this.conversionMap.put(clazz, function);
    }

    public void remove(Class<?> clazz) {
        this.conversionMap.remove(clazz);
    }

    public boolean contains(Class<?> clazz) {
        return this.conversionMap.containsKey(clazz);
    }

    public Object convert(Object object) {
        Function<Object, Object> function = this.getConversionFunction(object);
        if (function == null) {
            return object;
        }
        return function.apply(object);
    }

    public void convertShallow(Config config) {
        for (Map.Entry<String, Object> entry : config.valueMap().entrySet()) {
            Object object = entry.getValue();
            Function<Object, Object> function = this.getConversionFunction(object);
            if (function == null) continue;
            entry.setValue(function.apply(object));
        }
    }

    public void convertDeep(Config config) {
        for (Map.Entry<String, Object> entry : config.valueMap().entrySet()) {
            Object object = entry.getValue();
            if (object instanceof Config) {
                this.convertDeep(config);
                continue;
            }
            Function<Object, Object> function = this.getConversionFunction(object);
            if (function == null) continue;
            entry.setValue(function.apply(object));
        }
    }

    private Function<Object, Object> getConversionFunction(Object object) {
        if (object == null) {
            return this.conversionMap.get(null);
        }
        Class<?> clazz = object.getClass();
        Function<Object, Object> function = this.conversionMap.get(clazz);
        while (function == null && (clazz = clazz.getSuperclass()) != null) {
            function = this.conversionMap.get(clazz);
        }
        return function;
    }

    public ConversionTable chainThen(ConversionTable conversionTable) {
        ConversionTable conversionTable2 = new ConversionTable(this);
        for (Map.Entry<Class<?>, Function<?, Object>> entry : conversionTable2.conversionMap.entrySet()) {
            entry.setValue(entry.getValue().andThen(conversionTable::convert));
        }
        for (Map.Entry<Class<?>, Function<?, Object>> entry : conversionTable.conversionMap.entrySet()) {
            conversionTable2.conversionMap.putIfAbsent(entry.getKey(), entry.getValue());
        }
        return conversionTable2;
    }

    public UnmodifiableConfig wrap(UnmodifiableConfig unmodifiableConfig) {
        return new UnmodifiableConfigWrapper<UnmodifiableConfig>(unmodifiableConfig){

            @Override
            public <T> T getRaw(List<String> list) {
                return (T)ConversionTable.this.convert(this.config.getRaw(list));
            }

            @Override
            public Map<String, Object> valueMap() {
                return new TransformingMap<String, Object, Object>(this.config.valueMap(), object -> ConversionTable.this.convert(object), object -> object, object -> object);
            }

            @Override
            public Set<? extends UnmodifiableConfig.Entry> entrySet() {
                Function<UnmodifiableConfig.Entry, UnmodifiableConfig.Entry> function = entry -> new UnmodifiableConfig.Entry(){
                    final /* synthetic */ UnmodifiableConfig.Entry val$entry;
                    {
                        this.val$entry = entry;
                    }

                    @Override
                    public String getKey() {
                        return this.val$entry.getKey();
                    }

                    @Override
                    public <T> T getRawValue() {
                        return (T)ConversionTable.this.convert(this.val$entry.getRawValue());
                    }
                };
                return new TransformingSet<UnmodifiableConfig.Entry, UnmodifiableConfig.Entry>(this.config.entrySet(), function, entry -> null, object -> object);
            }

            @Override
            public ConfigFormat<?> configFormat() {
                return this.config.configFormat();
            }
        };
    }

    public Config wrapRead(Config config) {
        return new ConvertedConfig(config, this::convert, object -> object, config.configFormat()::supportsType);
    }

    public CommentedConfig wrapRead(CommentedConfig commentedConfig) {
        return new ConvertedCommentedConfig(commentedConfig, this::convert, object -> object, commentedConfig.configFormat()::supportsType);
    }

    public FileConfig wrapRead(FileConfig fileConfig) {
        return new ConvertedFileConfig(fileConfig, this::convert, object -> object, fileConfig.configFormat()::supportsType);
    }

    public CommentedFileConfig wrapRead(CommentedFileConfig commentedFileConfig) {
        return new ConvertedCommentedFileConfig(commentedFileConfig, this::convert, object -> object, commentedFileConfig.configFormat()::supportsType);
    }

    public Config wrapWrite(Config config, Predicate<Class<?>> predicate) {
        return new ConvertedConfig(config, object -> object, this::convert, predicate);
    }

    public CommentedConfig wrapWrite(CommentedConfig commentedConfig, Predicate<Class<?>> predicate) {
        return new ConvertedCommentedConfig(commentedConfig, object -> object, this::convert, predicate);
    }

    public FileConfig wrapWrite(FileConfig fileConfig, Predicate<Class<?>> predicate) {
        return new ConvertedFileConfig(fileConfig, object -> object, this::convert, predicate);
    }

    public CommentedFileConfig wrapWrite(CommentedFileConfig commentedFileConfig, Predicate<Class<?>> predicate) {
        return new ConvertedCommentedFileConfig(commentedFileConfig, object -> object, this::convert, predicate);
    }

    public ConversionTable clone() {
        return new ConversionTable(this);
    }

    public String toString() {
        return "ConversionTable: " + String.valueOf(this.conversionMap);
    }
}

