/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.Config;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.EnumGetMethod;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.InMemoryFormat;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.AnnotationUtils;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.Converter;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.ReflectionException;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.conversion.SpecEnum;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.utils.TransformingMap;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.utils.TransformingSet;

public final class ObjectBinder {
    private final boolean bypassTransient;
    private final boolean bypassFinal;

    public ObjectBinder(boolean bl, boolean bl2) {
        this.bypassTransient = bl;
        this.bypassFinal = bl2;
    }

    public ObjectBinder() {
        this(false, true);
    }

    public Config bind(Class<?> clazz) {
        return this.bind(clazz, InMemoryFormat.defaultInstance());
    }

    public Config bind(Class<?> clazz, ConfigFormat<?> configFormat) {
        return this.bind(null, clazz, configFormat);
    }

    public Config bind(Object object) {
        return this.bind(object, InMemoryFormat.defaultInstance());
    }

    public Config bind(Object object, ConfigFormat<?> configFormat) {
        return this.bind(object, object.getClass(), configFormat);
    }

    private Config bind(Object object, Class<?> clazz, ConfigFormat<?> configFormat) {
        BoundConfig boundConfig = this.createBoundConfig(object, clazz, configFormat);
        List<String> list = AnnotationUtils.getPath(clazz);
        if (list != null) {
            Object obj = configFormat.createConfig();
            obj.set(list, (Object)boundConfig);
            return obj;
        }
        return boundConfig;
    }

    private BoundConfig createBoundConfig(Object object, Class<?> clazz, ConfigFormat<?> configFormat) {
        BoundConfig boundConfig = new BoundConfig(object, configFormat, this.bypassFinal);
        for (Field field : clazz.getDeclaredFields()) {
            FieldInfos fieldInfos;
            Object object2;
            SpecEnum specEnum;
            int n = field.getModifiers();
            if (object == null && Modifier.isStatic(n) || !this.bypassTransient && Modifier.isTransient(n)) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            List<String> list = AnnotationUtils.getPath(field);
            Converter<Object, Object> converter = AnnotationUtils.getConverter(field);
            boolean bl = Enum.class.isAssignableFrom(field.getType());
            if (converter == null) {
                if (bl) {
                    specEnum = field.getAnnotation(SpecEnum.class);
                    object2 = specEnum == null ? EnumGetMethod.NAME_IGNORECASE : specEnum.method();
                    converter = new EnumValueConverter(field.getType(), (EnumGetMethod)((Object)object2));
                } else {
                    converter = NoOpConverter.INSTANCE;
                }
            }
            try {
                specEnum = converter.convertFromField(field.get(object));
                if (specEnum == null || bl || configFormat.supportsType(specEnum.getClass())) {
                    fieldInfos = new FieldInfos(field, null, converter);
                } else {
                    object2 = this.createBoundConfig(specEnum, field.getType(), configFormat);
                    fieldInfos = new FieldInfos(field, (BoundConfig)object2, converter);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ReflectionException("Failed to bind field " + String.valueOf(field), illegalAccessException);
            }
            boundConfig.registerField(fieldInfos, list);
        }
        return boundConfig;
    }

    private static final class BoundConfig
    implements Config {
        private Object object;
        private final Map<String, Object> dataMap;
        private final ConfigFormat<?> configFormat;
        private final boolean bypassFinal;

        private BoundConfig(Object object, Map<String, Object> map, ConfigFormat<?> configFormat, boolean bl) {
            this.object = object;
            this.dataMap = map;
            this.configFormat = configFormat;
            this.bypassFinal = bl;
        }

        private BoundConfig(Object object, ConfigFormat<?> configFormat, boolean bl) {
            this(object, new HashMap<String, Object>(), configFormat, bl);
        }

        private void registerField(FieldInfos fieldInfos, List<String> list) {
            int n = list.size() - 1;
            Map<String, Object> map = this.dataMap;
            for (String string : list.subList(0, n)) {
                BoundConfig boundConfig;
                Object object = map.get(string);
                if (object == null) {
                    boundConfig = new BoundConfig(null, new HashMap<String, Object>(1), this.configFormat, this.bypassFinal);
                    map.put(string, boundConfig);
                } else {
                    if (!(object instanceof BoundConfig)) {
                        throw new IllegalArgumentException("Cannot add an element to an intermediary value of type: " + String.valueOf(object.getClass()));
                    }
                    boundConfig = (BoundConfig)object;
                }
                map = boundConfig.dataMap;
            }
            String string = list.get(n);
            map.put(string, fieldInfos);
        }

        private BoundSearchResult searchInfosOrConfig(List<String> list) {
            int n = list.size() - 1;
            BoundConfig boundConfig = this;
            for (String object2 : list.subList(0, n)) {
                Object object = boundConfig.dataMap.get(object2);
                if (object == null) {
                    return null;
                }
                if (object instanceof BoundConfig) {
                    boundConfig = (BoundConfig)object;
                    continue;
                }
                FieldInfos fieldInfos = (FieldInfos)object;
                boundConfig = fieldInfos.getUpdatedConfig(boundConfig.object);
            }
            String string = list.get(n);
            Object object = boundConfig.dataMap.get(string);
            return new BoundSearchResult(boundConfig, object);
        }

        @Override
        public <T> T getRaw(List<String> list) {
            BoundSearchResult boundSearchResult = this.searchInfosOrConfig(list);
            if (boundSearchResult == null) {
                return null;
            }
            if (boundSearchResult.hasSubConfig()) {
                return (T)boundSearchResult.subConfig;
            }
            return (T)boundSearchResult.fieldInfos.getValue(boundSearchResult.parentConfig.object);
        }

        @Override
        public boolean contains(List<String> list) {
            return this.searchInfosOrConfig(list) != null;
        }

        @Override
        public <T> T set(List<String> list, Object object) {
            BoundSearchResult boundSearchResult = this.searchInfosOrConfig(list);
            if (boundSearchResult == null) {
                throw new UnsupportedOperationException("Cannot add elements to a bound config");
            }
            if (boundSearchResult.hasFieldInfos()) {
                return (T)boundSearchResult.fieldInfos.setValue(boundSearchResult.parentConfig.object, object, this.bypassFinal);
            }
            throw new UnsupportedOperationException("Cannot modify non-field elements of a bound config");
        }

        @Override
        public boolean add(List<String> list, Object object) {
            throw new UnsupportedOperationException("Cannot add elements to a bound config");
        }

        @Override
        public <T> T remove(List<String> list) {
            BoundSearchResult boundSearchResult = this.searchInfosOrConfig(list);
            if (boundSearchResult == null) {
                return null;
            }
            if (boundSearchResult.hasFieldInfos()) {
                return (T)boundSearchResult.fieldInfos.removeValue(boundSearchResult.parentConfig.object, this.bypassFinal);
            }
            Config config = Config.copy(boundSearchResult.subConfig);
            boundSearchResult.subConfig.clear();
            return (T)config;
        }

        @Override
        public void clear() {
            for (Map.Entry<String, Object> entry : this.dataMap.entrySet()) {
                Object object = entry.getValue();
                if (object instanceof FieldInfos) {
                    ((FieldInfos)object).removeValue(this.object, this.bypassFinal);
                    continue;
                }
                if (!(object instanceof BoundConfig)) continue;
                ((BoundConfig)object).clear();
            }
            this.dataMap.clear();
        }

        @Override
        public ConfigFormat<?> configFormat() {
            return this.configFormat;
        }

        @Override
        public Config createSubConfig() {
            return new BoundConfig(null, new HashMap<String, Object>(1), this.configFormat, this.bypassFinal);
        }

        @Override
        public Map<String, Object> valueMap() {
            Function<Object, Object> function = object -> {
                if (object instanceof FieldInfos) {
                    FieldInfos fieldInfos = (FieldInfos)object;
                    if (fieldInfos.boundConfig != null) {
                        return fieldInfos.getUpdatedConfig(this.object);
                    }
                    return fieldInfos.getValue(this.object);
                }
                return object;
            };
            return new TransformingMap<String, Object, Object>(this.dataMap, function, object -> object, object -> object);
        }

        @Override
        public Set<? extends Config.Entry> entrySet() {
            Function<Map.Entry, Config.Entry> function = entry -> new Config.Entry(){
                final /* synthetic */ Map.Entry val$entry;
                {
                    this.val$entry = entry;
                }

                @Override
                public <T> T setValue(Object object) {
                    return this.set((String)this.val$entry.getKey(), object);
                }

                @Override
                public String getKey() {
                    return (String)this.val$entry.getKey();
                }

                @Override
                public <T> T getRawValue() {
                    return (T)this.val$entry.getValue();
                }
            };
            return new TransformingSet<Map.Entry, Config.Entry>(this.dataMap.entrySet(), function, entry -> null, object -> object);
        }

        @Override
        public int size() {
            return this.dataMap.size();
        }

        public String toString() {
            return "BoundConfig{object=" + String.valueOf(this.object) + ", dataMap=" + String.valueOf(this.dataMap) + "}";
        }
    }

    private static final class EnumValueConverter<T extends Enum<T>>
    implements Converter<T, Object> {
        private final Class<T> enumType;
        private final EnumGetMethod method;

        EnumValueConverter(Class<T> clazz, EnumGetMethod enumGetMethod) {
            this.enumType = clazz;
            this.method = enumGetMethod;
        }

        @Override
        public T convertToField(Object object) {
            return this.method.get(object, this.enumType);
        }

        @Override
        public String convertFromField(T t) {
            return t == null ? null : ((Enum)t).toString();
        }
    }

    private static final class NoOpConverter
    implements Converter<Object, Object> {
        static final NoOpConverter INSTANCE = new NoOpConverter();

        private NoOpConverter() {
        }

        @Override
        public Object convertToField(Object object) {
            return object;
        }

        @Override
        public Object convertFromField(Object object) {
            return object;
        }
    }

    private static final class FieldInfos {
        final Field field;
        final BoundConfig boundConfig;
        final Converter<Object, Object> converter;

        FieldInfos(Field field, BoundConfig boundConfig, Converter<Object, Object> converter) {
            this.field = field;
            this.boundConfig = boundConfig;
            this.converter = converter;
        }

        Object setValue(Object object, Object object2, boolean bl) {
            if (!bl && Modifier.isFinal(this.field.getModifiers())) {
                throw new UnsupportedOperationException("Cannot modify the field " + String.valueOf(this.field));
            }
            try {
                Object object3 = this.converter.convertFromField(this.field.get(object));
                Object object4 = this.converter.convertToField(object2);
                AnnotationUtils.checkField(this.field, object4);
                this.field.set(object, object4);
                return object3;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ReflectionException("Failed to set field " + String.valueOf(this.field), illegalAccessException);
            }
        }

        Object removeValue(Object object, boolean bl) {
            Object object2 = this.getValue(object);
            if (this.field.getType().isPrimitive()) {
                this.setValue(object, (byte)0, bl);
            } else {
                this.setValue(object, null, bl);
                if (this.boundConfig != null) {
                    this.boundConfig.clear();
                }
            }
            return object2;
        }

        Object getValue(Object object) {
            try {
                return this.converter.convertFromField(this.field.get(object));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ReflectionException("Failed to get field " + String.valueOf(this.field), illegalAccessException);
            }
        }

        BoundConfig getUpdatedConfig(Object object) {
            this.boundConfig.object = this.getValue(object);
            return this.boundConfig;
        }

        public String toString() {
            return "FieldInfos{field=" + String.valueOf(this.field) + ", boundConfig=" + String.valueOf(this.boundConfig) + "}";
        }
    }

    private static final class BoundSearchResult {
        final BoundConfig parentConfig;
        final FieldInfos fieldInfos;
        final BoundConfig subConfig;

        BoundSearchResult(BoundConfig boundConfig, Object object) {
            this.parentConfig = boundConfig;
            if (object instanceof FieldInfos) {
                this.fieldInfos = (FieldInfos)object;
                this.subConfig = this.fieldInfos.boundConfig == null ? null : this.fieldInfos.getUpdatedConfig(boundConfig.object);
            } else {
                this.fieldInfos = null;
                this.subConfig = (BoundConfig)object;
            }
        }

        boolean hasFieldInfos() {
            return this.fieldInfos != null;
        }

        boolean hasSubConfig() {
            return this.subConfig != null;
        }
    }
}

