/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.CommentedConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.Config;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.concurrent.ConcurrentCommentedConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.concurrent.StampedConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.CommentedFileConfig;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.ConfigLoadFilter;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.DebouncedRunnable;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.file.FileNotFoundAction;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.io.ConfigParser;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.io.ConfigWriter;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.io.ParsingMode;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.io.WritingException;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.io.WritingMode;
import me.roundaround.enchantmentcompat.roundalib.nightconfig.core.utils.CommentedConfigWrapper;

final class AsyncFileConfig
extends CommentedConfigWrapper<StampedConfig>
implements CommentedFileConfig {
    static final Duration DEFAULT_WRITE_DEBOUNCE_TIME = Duration.ofSeconds(1L);
    private final boolean asyncLoad;
    private volatile boolean closed;
    private final Path nioPath;
    private final DebouncedRunnable saveTask;
    private BufferedWriter fileWriter;
    private final ConfigWriter configWriter;
    private final WritingMode writingMode;
    private final ConfigParser<?> configParser;
    private final ParsingMode parsingMode;
    private final FileNotFoundAction notFoundAction;
    private final Charset charset;
    private final ConfigLoadFilter reloadFilter;
    private final Runnable saveListener;
    private final Runnable loadListener;

    AsyncFileConfig(StampedConfig stampedConfig, Path path, Charset charset, ConfigWriter configWriter, WritingMode writingMode, ConfigParser<?> configParser, ParsingMode parsingMode, FileNotFoundAction fileNotFoundAction, boolean bl, ConfigLoadFilter configLoadFilter, Runnable runnable, Runnable runnable2, Duration duration) {
        super(stampedConfig);
        this.asyncLoad = bl;
        this.nioPath = path;
        this.writingMode = writingMode;
        this.configWriter = configWriter;
        this.saveTask = new DebouncedRunnable(this::saveNow, duration);
        this.configParser = configParser;
        this.parsingMode = parsingMode;
        this.notFoundAction = fileNotFoundAction;
        this.charset = charset;
        this.reloadFilter = configLoadFilter;
        this.saveListener = runnable;
        this.loadListener = runnable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveNow() {
        StampedConfig.Accumulator accumulator = ((StampedConfig)this.config).newAccumulatorCopy();
        AsyncFileConfig asyncFileConfig = this;
        synchronized (asyncFileConfig) {
            block20: {
                if (this.writingMode == WritingMode.REPLACE_ATOMIC) {
                    Path path = this.nioPath.resolveSibling(String.valueOf(this.nioPath.getFileName()) + ".new.tmp");
                    try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, this.charset, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                        this.configWriter.write((UnmodifiableConfig)accumulator, bufferedWriter);
                        Files.move(path, this.nioPath, StandardCopyOption.ATOMIC_MOVE);
                        break block20;
                    }
                    catch (AtomicMoveNotSupportedException atomicMoveNotSupportedException) {
                        String string = String.format("Failed to atomically move the config from '%s' to '%s': WritingMode.REPLACE_ATOMIC is not supported for this path, use WritingMode.REPLACE instead.\n%s", path.toString(), this.nioPath.toString(), "Note: you may see *.new.tmp files after this error, they contain the \"new version\" of your configurations and can be safely removed.If you want, you can manually copy their content into your regular configuration files (replacing the old config).");
                        throw new WritingException(string, atomicMoveNotSupportedException);
                    }
                    catch (IOException iOException) {
                        String string = String.format("Failed to write (%s) the config to: %s", this.writingMode.toString(), path.toString());
                        throw new WritingException(string, iOException);
                    }
                }
                if (this.fileWriter == null) {
                    StandardOpenOption standardOpenOption = this.writingMode == WritingMode.APPEND ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING;
                    try {
                        this.fileWriter = Files.newBufferedWriter(this.nioPath, this.charset, StandardOpenOption.WRITE, StandardOpenOption.CREATE, standardOpenOption);
                    }
                    catch (IOException iOException) {
                        throw new WritingException("Failed to open a BufferedWriter on: " + String.valueOf(this.nioPath), iOException);
                    }
                }
                this.configWriter.write((UnmodifiableConfig)accumulator, this.fileWriter);
                try {
                    if (this.closed) {
                        this.fileWriter.close();
                    } else {
                        this.fileWriter.flush();
                    }
                }
                catch (IOException iOException) {
                    String string = this.closed ? "close" : "flush";
                    String string2 = String.format("Buffer %s failed while saving asynchronous FileConfig.", string);
                    throw new WritingException(string2, iOException);
                }
            }
        }
        this.saveListener.run();
    }

    private void loadNow() {
        Object obj = this.configParser.parse(this.nioPath, this.notFoundAction, this.charset);
        CommentedConfig commentedConfig = CommentedConfig.fake(obj);
        if (this.reloadFilter != null && !this.reloadFilter.acceptNewVersion(commentedConfig)) {
            return;
        }
        switch (this.parsingMode) {
            case REPLACE: {
                StampedConfig stampedConfig = ((StampedConfig)this.config).createSubConfig();
                stampedConfig.putAll(commentedConfig);
                ((StampedConfig)this.config).replaceContentBy(stampedConfig);
                break;
            }
            default: {
                AsyncFileConfig.putWithParsingMode(this.parsingMode, commentedConfig, (ConcurrentCommentedConfig)this.config);
            }
        }
        this.loadListener.run();
    }

    static void putWithParsingMode(ParsingMode parsingMode, CommentedConfig commentedConfig, ConcurrentCommentedConfig concurrentCommentedConfig) {
        concurrentCommentedConfig.bulkCommentedUpdate((? super CommentedConfig commentedConfig2) -> {
            for (CommentedConfig.Entry entry : commentedConfig.entrySet()) {
                List<String> list = Collections.singletonList(entry.getKey());
                Object object = entry.getRawValue();
                if (object instanceof UnmodifiableConfig && object.getClass() != concurrentCommentedConfig.getClass()) {
                    ConcurrentCommentedConfig concurrentCommentedConfig2 = concurrentCommentedConfig.createSubConfig();
                    concurrentCommentedConfig2.putAll((UnmodifiableConfig)object);
                    object = concurrentCommentedConfig2;
                }
                parsingMode.put((Config)commentedConfig2, list, object);
            }
        });
    }

    @Override
    public File getFile() {
        return this.nioPath.toFile();
    }

    @Override
    public Path getNioPath() {
        return this.nioPath;
    }

    @Override
    public void save() {
        if (this.closed) {
            throw new IllegalStateException("This FileConfig is closed, cannot save().");
        }
        this.saveTask.run(LazyExecutorHolder.sharedExecutor);
    }

    public void asyncLoad() {
        LazyExecutorHolder.sharedExecutor.execute(() -> this.loadNow());
    }

    @Override
    public void load() {
        if (this.closed) {
            throw new IllegalStateException("This FileConfig is closed, cannot load().");
        }
        if (this.asyncLoad) {
            this.asyncLoad();
        } else {
            this.loadNow();
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public <R> R bulkCommentedUpdate(Function<? super CommentedConfig, R> function) {
        return ((StampedConfig)this.config).bulkCommentedUpdate(function);
    }

    @Override
    public <R> R bulkUpdate(Function<? super Config, R> function) {
        return ((StampedConfig)this.config).bulkUpdate(function);
    }

    private static final class LazyExecutorHolder {
        private static final ScheduledExecutorService sharedExecutor;

        private LazyExecutorHolder() {
        }

        static {
            int n = Runtime.getRuntime().availableProcessors();
            ThreadFactory threadFactory = Executors.defaultThreadFactory();
            ThreadFactory threadFactory2 = runnable -> {
                Thread thread = threadFactory.newThread(runnable);
                thread.setDaemon(true);
                return thread;
            };
            sharedExecutor = Executors.newScheduledThreadPool(n, threadFactory2);
        }
    }
}

